/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.filter.response;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5200)
public class XsltExecutableFilter
implements ContainerResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(XsltExecutableFilter.class);
    @Inject
    Application system;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> application;
    @Context
    UriInfo uriInfo;

    public void filter(ContainerRequestContext req, ContainerResponseContext resp) throws IOException {
        if (resp.getMediaType() != null && (resp.getMediaType().isCompatible(MediaType.TEXT_HTML_TYPE) || resp.getMediaType().isCompatible(MediaType.APPLICATION_XHTML_XML_TYPE))) {
            URI stylesheet;
            URI uRI = stylesheet = this.getApplication().getStylesheet() != null ? URI.create(this.getApplication().getStylesheet().getURI()) : null;
            if (stylesheet != null) {
                req.setProperty(AC.stylesheet.getURI(), (Object)this.getXsltExecutable(stylesheet));
            } else {
                req.setProperty(AC.stylesheet.getURI(), (Object)this.getSystem().getXsltExecutable());
            }
        }
    }

    public XsltExecutable getXsltExecutable(URI stylesheet) {
        try {
            return this.getXsltExecutable(stylesheet, this.getXsltExecutableCache());
        }
        catch (SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("XSLT transformer not configured property", (Throwable)ex);
            }
            throw new InternalServerErrorException((Throwable)ex);
        }
        catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("XSLT stylesheet not found or error reading it", (Throwable)ex);
            }
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    public XsltExecutable getXsltExecutable(URI stylesheet, Map<URI, XsltExecutable> xsltExecCache) throws IOException, SaxonApiException {
        if (this.isCacheStylesheet()) {
            if (!xsltExecCache.containsKey(stylesheet)) {
                xsltExecCache.put(stylesheet, this.getXsltExecutable(this.getSource(stylesheet.toString())));
            }
            return xsltExecCache.get(stylesheet);
        }
        return this.getXsltExecutable(this.getSource(stylesheet.toString()));
    }

    public XsltExecutable getXsltExecutable(Source source) throws SaxonApiException {
        return this.getXsltCompiler().compile(source);
    }

    public Source getSource(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("URI name cannot be null");
        }
        URI uri = this.getUriInfo().getBaseUri().resolve(url);
        if (log.isDebugEnabled()) {
            log.debug("Loading Source using '{}' scheme from URL '{}'", (Object)uri.getScheme(), (Object)uri);
        }
        if (uri.getScheme().equals("file") || uri.getScheme().equals("jndi")) {
            try (InputStream is = uri.toURL().openStream();){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                StreamSource streamSource = new StreamSource(new ByteArrayInputStream(bytes), url);
                return streamSource;
            }
        }
        if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            WebTarget webResource = this.getClient().target(uri);
            Invocation.Builder builder = webResource.request();
            try (Response cr = builder.accept(new javax.ws.rs.core.MediaType[]{MediaType.TEXT_XSL_TYPE}).get();){
                StreamSource streamSource;
                block23: {
                    if (!cr.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                        throw new IOException("XSLT stylesheet could not be successfully loaded over HTTP");
                    }
                    InputStream is = (InputStream)cr.readEntity(InputStream.class);
                    try {
                        byte[] bytes = IOUtils.toByteArray((InputStream)is);
                        streamSource = new StreamSource(new ByteArrayInputStream(bytes), uri.toString());
                        if (is == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return streamSource;
            }
        }
        return null;
    }

    public Client getClient() {
        return this.getSystem().getClient();
    }

    public XsltCompiler getXsltCompiler() {
        return this.getSystem().getXsltCompiler();
    }

    public boolean isCacheStylesheet() {
        return this.getSystem().isCacheStylesheet();
    }

    public Map<URI, XsltExecutable> getXsltExecutableCache() {
        return this.getSystem().getXsltExecutableCache();
    }

    public Application getSystem() {
        return this.system;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.application.get();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

