/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.interceptor;

import com.atomgraph.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.canonical.Canonicalizer;
import org.apache.commons.io.IOUtils;
import org.apache.jena.riot.RiotException;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=4000)
public class RDFPostCleanupInterceptor
implements ReaderInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RDFPostCleanupInterceptor.class);

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (context.getMediaType() != null && context.getMediaType().isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)context.getInputStream(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String formData = writer.toString();
            if (formData.startsWith("rdf")) {
                String charsetName = StandardCharsets.UTF_8.name();
                String[] params = formData.split("&");
                ArrayList<String> keys = new ArrayList<String>();
                List<String> values = new ArrayList();
                for (String param : params) {
                    String[] keyValue = param.split("=");
                    try {
                        String key = URLDecoder.decode(keyValue[0], charsetName);
                        keys.add(key);
                        if (keyValue.length > 1) {
                            String value = URLDecoder.decode(keyValue[1], charsetName);
                            values.add(value);
                            continue;
                        }
                        values.add(null);
                    }
                    catch (UnsupportedEncodingException ex) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unsupported encoding", (Throwable)ex);
                        }
                        throw new RiotException((Throwable)ex);
                    }
                }
                try {
                    Object rdfPost = "";
                    values = this.fixValues(keys, values, charsetName);
                    for (int j = 0; j < keys.size(); ++j) {
                        String key = (String)keys.get(j);
                        String value = (String)values.get(j);
                        rdfPost = (String)rdfPost + URLEncoder.encode(key, charsetName) + "=";
                        if (value != null) {
                            rdfPost = (String)rdfPost + URLEncoder.encode(value, charsetName);
                        }
                        if (j + 1 >= keys.size()) continue;
                        rdfPost = (String)rdfPost + "&";
                    }
                    context.setInputStream((InputStream)new ByteArrayInputStream(((String)rdfPost).getBytes(charsetName)));
                    context.setMediaType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_URLENCODED_TYPE);
                }
                catch (IOException | ParsingException ex) {
                    if (log.isWarnEnabled()) {
                        log.warn("Error parsing RDF/POST token", ex);
                    }
                    throw new RiotException(ex);
                }
            } else {
                context.setInputStream((InputStream)new ByteArrayInputStream(formData.getBytes(StandardCharsets.UTF_8)));
            }
        }
        return context.proceed();
    }

    public List<String> fixValues(List<String> keys, List<String> values, String charsetName) throws ParsingException, IOException {
        if (keys == null) {
            throw new IllegalArgumentException("List<String> cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("List<String> cannot be null");
        }
        for (int i = 0; i < keys.size(); ++i) {
            String xml;
            if (i >= 1 && i + 1 < keys.size() && keys.get(i - 1).equals("pu") && values.get(i - 1) != null && values.get(i - 1).equals(RDF.value.getURI()) && keys.get(i).equals("ol") && keys.get(i + 1).equals("lt") && values.get(i + 1) != null && values.get(i + 1).equals(RDF.xmlLiteral.getURI()) && values.get(i) != null) {
                xml = values.get(i);
                values.set(i, this.canonicalizeXML(this.wrapXHTML(xml), charsetName));
            }
            if (i < 2 || !keys.get(i - 2).equals("pu") || values.get(i - 2) == null || !values.get(i - 2).equals(RDF.value.getURI()) || !keys.get(i - 1).equals("lt") || values.get(i - 1) == null || !values.get(i - 1).equals(RDF.xmlLiteral.getURI()) || !keys.get(i).equals("ol") || values.get(i) == null) continue;
            xml = values.get(i);
            values.set(i, this.canonicalizeXML(this.wrapXHTML(xml), charsetName));
        }
        return values;
    }

    public String wrapXHTML(String xhtml) {
        if (xhtml == null) {
            throw new IllegalArgumentException("XHTML String cannot be null");
        }
        return "<div xmlns='http://www.w3.org/1999/xhtml'>" + xhtml + "</div>";
    }

    public String canonicalizeXML(String xml, String charsetName) throws IOException, ParsingException {
        if (xml == null) {
            throw new IllegalArgumentException("XML String cannot be null");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset String cannot be null");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(charsetName));){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Document xhtml = new Builder().build((InputStream)bais);
                new Canonicalizer((OutputStream)baos).write((Node)xhtml);
                string = baos.toString(StandardCharsets.UTF_8.name());
            }
            return string;
        }
    }
}

