/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.interceptor;

import com.atomgraph.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.canonical.Canonicalizer;
import org.apache.commons.io.IOUtils;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=4010)
public class UpdateRequestCleanupInterceptor
implements ReaderInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UpdateRequestCleanupInterceptor.class);

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (context.getMediaType() != null && context.getMediaType().isCompatible((javax.ws.rs.core.MediaType)MediaType.APPLICATION_SPARQL_UPDATE_TYPE)) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)context.getInputStream(), (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String updateString = writer.toString();
            if (updateString.contains("<" + RDF.xmlLiteral.getURI() + ">")) {
                Pattern pattern = Pattern.compile("\\\"(.*)\\\"\\^\\^<http:\\/\\/www\\.w3\\.org\\/1999\\/02\\/22-rdf-syntax-ns#XMLLiteral>", 32);
                Matcher matcher = pattern.matcher(updateString);
                while (matcher.find()) {
                    String xml = matcher.group(1);
                    try {
                        xml = this.canonicalizeXML(this.wrapXHTML(xml), StandardCharsets.UTF_8.name());
                        String xmlLiteral = "\"\"\"" + xml + "\"\"\"^^<" + RDF.xmlLiteral.getURI() + ">";
                        updateString = matcher.replaceFirst(xmlLiteral);
                    }
                    catch (ParsingException ex) {
                        throw new IOException(ex);
                    }
                }
            }
            context.setInputStream((InputStream)new ByteArrayInputStream(updateString.getBytes(StandardCharsets.UTF_8)));
        }
        return context.proceed();
    }

    public String wrapXHTML(String xhtml) {
        if (xhtml == null) {
            throw new IllegalArgumentException("XHTML String cannot be null");
        }
        return "<div xmlns='http://www.w3.org/1999/xhtml'>" + xhtml + "</div>";
    }

    public String canonicalizeXML(String xml, String charsetName) throws IOException, ParsingException {
        if (xml == null) {
            throw new IllegalArgumentException("XML String cannot be null");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset String cannot be null");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(charsetName));){
            String string;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Document xhtml = new Builder().build((InputStream)bais);
                new Canonicalizer((OutputStream)baos).write((Node)xhtml);
                string = baos.toString(StandardCharsets.UTF_8.name());
            }
            return string;
        }
    }
}

