/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.io;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.MediaType;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.event.AuthorizationCreated;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.processor.vocabulary.SIOC;
import com.atomgraph.server.exception.SPINConstraintViolationException;
import com.atomgraph.spinrdf.constraints.ConstraintViolation;
import com.atomgraph.spinrdf.constraints.ObjectPropertyPath;
import com.atomgraph.spinrdf.vocabulary.SP;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.commons.codec.binary.Hex;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdfxml.xmloutput.impl.Basic;
import org.apache.jena.riot.Lang;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidatingModelProvider
extends com.atomgraph.server.io.ValidatingModelProvider {
    private static final Logger log = LoggerFactory.getLogger(ValidatingModelProvider.class);
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;
    @Context
    SecurityContext securityContext;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> application;
    @Inject
    Application system;
    @Inject
    Provider<Optional<AgentContext>> agentContextProvider;
    private final MessageDigest messageDigest;

    public ValidatingModelProvider(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public Model write(Model model, OutputStream os, Lang lang, String baseURI) {
        if (lang == null) {
            throw new IllegalArgumentException("Lang must be not null");
        }
        if (lang.equals((Object)Lang.RDFXML)) {
            Basic writer = new Basic();
            writer.setProperty("allowBadURIs", (Object)true);
            writer.write(model, os, null);
            return model;
        }
        return super.write(model, os, lang, baseURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model processRead(Model model) {
        try (ResIterator it = model.listSubjects();){
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                this.processRead(resource);
            }
        }
        return super.processRead(model);
    }

    public Resource processRead(Resource resource) {
        Resource email;
        if (resource.hasProperty(DCTerms.format) && resource.getProperty(DCTerms.format).getObject().isLiteral()) {
            Resource format = resource.getProperty(DCTerms.format).changeObject((RDFNode)MediaType.toResource((javax.ws.rs.core.MediaType)javax.ws.rs.core.MediaType.valueOf((String)resource.getProperty(DCTerms.format).getString()))).getResource();
            if (log.isDebugEnabled()) {
                log.debug("Resource: {} Format: {}", (Object)resource, (Object)format);
            }
        }
        if (resource.hasProperty(FOAF.mbox) && resource.getProperty(FOAF.mbox).getObject().isLiteral()) {
            email = resource.getProperty(FOAF.mbox).changeObject((RDFNode)resource.getModel().createResource("mailto:" + resource.getProperty(FOAF.mbox).getString())).getResource();
            if (log.isDebugEnabled()) {
                log.debug("Resource: {} Email: {}", (Object)resource, (Object)email);
            }
        }
        if (resource.hasProperty(FOAF.phone) && resource.getProperty(FOAF.phone).getObject().isLiteral()) {
            Resource phone = resource.getProperty(FOAF.phone).changeObject((RDFNode)resource.getModel().createResource("tel:" + resource.getProperty(FOAF.phone).getString())).getResource();
            if (log.isDebugEnabled()) {
                log.debug("Resource: {} Phone: {}", (Object)resource, (Object)phone);
            }
        }
        if (resource.hasProperty((Property)SIOC.EMAIL) && resource.getProperty((Property)SIOC.EMAIL).getObject().isLiteral()) {
            email = resource.getProperty((Property)SIOC.EMAIL).changeObject((RDFNode)resource.getModel().createResource("mailto:" + resource.getProperty((Property)SIOC.EMAIL).getString())).getResource();
            if (log.isDebugEnabled()) {
                log.debug("Resource: {} Email: {}", (Object)resource, (Object)email);
            }
        }
        if (resource.hasProperty(SP.text) && resource.getProperty(SP.text).getObject().isLiteral()) {
            try {
                String queryString = resource.getProperty(SP.text).getString();
                QueryFactory.create((String)queryString);
            }
            catch (QueryParseException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Bad request - SPARQL query is syntactically incorrect", (Throwable)ex);
                }
                ArrayList<ConstraintViolation> cvs = new ArrayList<ConstraintViolation>();
                ArrayList<ObjectPropertyPath> paths = new ArrayList<ObjectPropertyPath>();
                paths.add(new ObjectPropertyPath(resource, SP.text));
                cvs.add(new ConstraintViolation(resource, paths, null, ex.getMessage(), null));
                throw new SPINConstraintViolationException(cvs, resource.getModel());
            }
        }
        if (resource.hasProperty(RDF.type, (RDFNode)SP.Update) && resource.hasProperty(SP.text) && resource.getProperty(SP.text).getObject().isLiteral()) {
            String updateString = resource.getProperty(SP.text).getString();
            try {
                UpdateRequest update = UpdateFactory.create((String)updateString);
                RDFNode type = null;
                if (type != null) {
                    resource.addProperty(RDF.type, type);
                    if (log.isDebugEnabled()) {
                        log.debug("Resource: {} adding type: {}", (Object)resource, type);
                    }
                }
            }
            catch (QueryParseException ex) {
                if (log.isDebugEnabled()) {
                    log.debug("Bad request - SPARQL update is syntactically incorrect", (Throwable)ex);
                }
                ArrayList<ConstraintViolation> cvs = new ArrayList<ConstraintViolation>();
                ArrayList<ObjectPropertyPath> paths = new ArrayList<ObjectPropertyPath>();
                paths.add(new ObjectPropertyPath(resource, SP.text));
                cvs.add(new ConstraintViolation(resource, paths, null, ex.getMessage(), null));
                throw new SPINConstraintViolationException(cvs, resource.getModel());
            }
        }
        if (this.getApplication().canAs(AdminApplication.class) && resource.hasProperty(RDF.type, (RDFNode)OWL.Ontology)) {
            this.getSystem().getOntModelSpec().getDocumentManager().getFileManager().removeCacheModel(resource.getURI());
        }
        if (resource.hasProperty(RDF.type, (RDFNode)ACL.Authorization)) {
            LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes()).delegation(this.getUriInfo().getBaseUri(), (AgentContext)((Optional)this.getAgentContextProvider().get()).orElse(null));
            this.getSystem().getEventBus().post((Object)new AuthorizationCreated((com.atomgraph.linkeddatahub.apps.model.Application)this.getEndUserApplication(), ldc, resource));
        }
        return resource;
    }

    public Model processWrite(Model model) {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return model;
        }
        if (this.getSecurityContext() != null && this.getSecurityContext().getUserPrincipal() instanceof Agent) {
            return model;
        }
        return super.processWrite((Model)ValidatingModelProvider.hashMboxes((MessageDigest)this.getMessageDigest()).apply(model));
    }

    public static Function<Model, Model> hashMboxes(MessageDigest messageDigest) {
        return model -> {
            StmtIterator it = model.listStatements(null, FOAF.mbox, (RDFNode)((Resource)null));
            List mboxes = it.toList();
            it.close();
            List mboxHashes = mboxes.stream().map(stmt -> ValidatingModelProvider.mboxHashStmt((Statement)stmt, (MessageDigest)messageDigest)).filter(Objects::nonNull).collect(Collectors.toList());
            model.remove(mboxes);
            model.add(mboxHashes);
            return model;
        };
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Statement mboxHashStmt(Statement stmt, MessageDigest messageDigest) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(stmt.getResource().getURI().getBytes(StandardCharsets.UTF_8));){
            Statement statement;
            try (DigestInputStream dis = new DigestInputStream(is, messageDigest);){
                String sha1Sum = Hex.encodeHexString((byte[])dis.getMessageDigest().digest());
                statement = stmt.getModel().createStatement(stmt.getSubject(), FOAF.mbox_sha1sum, sha1Sum);
            }
            return statement;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public EndUserApplication getEndUserApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return (EndUserApplication)this.getApplication().as(EndUserApplication.class);
        }
        return ((AdminApplication)this.getApplication().as(AdminApplication.class)).getEndUserApplication();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.application.get();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public Application getSystem() {
        return this.system;
    }

    public Provider<Optional<AgentContext>> getAgentContextProvider() {
        return this.agentContextProvider;
    }
}

