/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.mapper.auth;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.apps.model.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.server.exception.auth.AuthorizationException;
import com.atomgraph.linkeddatahub.vocabulary.LACL;
import com.atomgraph.server.mapper.ExceptionMapperBase;
import com.atomgraph.server.vocabulary.HTTP;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

@Provider
public class AuthorizationExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<AuthorizationException> {
    @Context
    SecurityContext securityContext;
    @Inject
    javax.inject.Provider<Application> application;

    @Inject
    public AuthorizationExceptionMapper(MediaTypes mediaTypes) {
        super(mediaTypes);
    }

    public Response toResponse(AuthorizationException ex) {
        Resource exRes = this.toResource((Exception)ex, (Response.StatusType)Response.Status.FORBIDDEN, ResourceFactory.createResource((String)"http://www.w3.org/2011/http-statusCodes#Forbidden")).addLiteral((Property)HTTP.absoluteURI, (Object)ex.getAbsolutePath().toString());
        if (this.getSecurityContext().getUserPrincipal() != null && this.getApplication().canAs(EndUserApplication.class)) {
            Resource adminBase = ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication().getBase();
            URI requestAccessURI = UriBuilder.fromUri((String)adminBase.getURI()).path("request access").build(new Object[0]);
            exRes.addProperty((Property)LACL.requestAccess, (RDFNode)exRes.getModel().createResource(requestAccessURI.toString()));
        }
        return this.getResponseBuilder(exRes.getModel()).status(Response.Status.FORBIDDEN).tag((EntityTag)null).build();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Application getApplication() {
        return (Application)this.application.get();
    }
}

