/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.mapper.auth.oauth2;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.server.mapper.ExceptionMapperBase;
import com.auth0.jwt.exceptions.TokenExpiredException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.jena.rdf.model.ResourceFactory;

public class TokenExpiredExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<TokenExpiredException> {
    @Context
    UriInfo uriInfo;
    @Inject
    Provider<Application> application;

    @Inject
    public TokenExpiredExceptionMapper(MediaTypes mediaTypes) {
        super(mediaTypes);
    }

    public Response toResponse(TokenExpiredException ex) {
        String path = this.getApplication().getBaseURI().getPath();
        NewCookie expiredCookie = new NewCookie("LinkedDataHub.id_token", "", path, null, 1, null, 0, false);
        Response.ResponseBuilder builder = this.getResponseBuilder(this.toResource((Exception)ex, (Response.StatusType)Response.Status.BAD_REQUEST, ResourceFactory.createResource((String)"http://www.w3.org/2011/http-statusCodes#BadRequest")).getModel()).cookie(new NewCookie[]{expiredCookie});
        URI redirectUri = UriBuilder.fromUri((URI)this.getAdminApplication().getBaseURI()).path("/oauth2/authorize/google").queryParam("referer", new Object[]{this.getUriInfo().getRequestUri()}).build(new Object[0]);
        if (!this.getUriInfo().getAbsolutePath().equals(redirectUri)) {
            builder.status(Response.Status.SEE_OTHER).location(redirectUri);
        }
        return builder.build();
    }

    public AdminApplication getAdminApplication() {
        if (this.getApplication().canAs(EndUserApplication.class)) {
            return ((EndUserApplication)this.getApplication().as(EndUserApplication.class)).getAdminApplication();
        }
        return (AdminApplication)this.getApplication().as(AdminApplication.class);
    }

    public Application getApplication() {
        return (Application)this.application.get();
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

