/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.mapper.auth.webid;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.server.exception.auth.webid.InvalidWebIDPublicKeyException;
import com.atomgraph.linkeddatahub.vocabulary.Cert;
import com.atomgraph.linkeddatahub.vocabulary.PROV;
import com.atomgraph.server.mapper.ExceptionMapperBase;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class InvalidWebIDPublicKeyExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<InvalidWebIDPublicKeyException> {
    @Inject
    public InvalidWebIDPublicKeyExceptionMapper(MediaTypes mediaTypes) {
        super(mediaTypes);
    }

    public Response toResponse(InvalidWebIDPublicKeyException ex) {
        Resource resource = this.toResource((Exception)ex, (Response.StatusType)Response.Status.BAD_REQUEST, ResourceFactory.createResource((String)"http://www.w3.org/2011/http-statusCodes#BadRequest"));
        if (ex.getPublicKey() != null) {
            resource.addProperty((Property)PROV.wasDerivedFrom, (RDFNode)resource.getModel().createResource().addProperty(RDF.type, (RDFNode)Cert.PublicKey).addLiteral((Property)Cert.modulus, ResourceFactory.createTypedLiteral((String)ex.getPublicKey().getModulus().toString(16), (RDFDatatype)XSDDatatype.XSDhexBinary)).addLiteral((Property)Cert.exponent, ResourceFactory.createTypedLiteral((Object)ex.getPublicKey().getPublicExponent())));
        }
        return this.getResponseBuilder(resource.getModel()).status(Response.Status.BAD_REQUEST).build();
    }
}

