/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.model.impl;

import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.resource.Add;
import com.atomgraph.linkeddatahub.resource.Importer;
import com.atomgraph.linkeddatahub.resource.Namespace;
import com.atomgraph.linkeddatahub.resource.Transform;
import com.atomgraph.linkeddatahub.resource.admin.Clear;
import com.atomgraph.linkeddatahub.resource.admin.RequestAccess;
import com.atomgraph.linkeddatahub.resource.admin.SignUp;
import com.atomgraph.linkeddatahub.resource.admin.oauth2.Login;
import com.atomgraph.linkeddatahub.resource.admin.oauth2.google.Authorize;
import com.atomgraph.linkeddatahub.resource.graph.Item;
import com.atomgraph.linkeddatahub.server.model.impl.GraphStoreImpl;
import com.atomgraph.linkeddatahub.server.model.impl.ProxyResourceBase;
import com.atomgraph.linkeddatahub.server.model.impl.SPARQLEndpointImpl;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    private final UriInfo uriInfo;
    private final Optional<Dataset> dataset;
    private final Application system;

    @Inject
    public Dispatcher(@Context UriInfo uriInfo, Optional<Dataset> dataset, Application system) {
        this.uriInfo = uriInfo;
        this.dataset = dataset;
        this.system = system;
    }

    @Path(value="{path: .*}")
    public Object getSubResource() {
        if (this.getSystem().isEnableLinkedDataProxy() && this.getUriInfo().getQueryParameters().containsKey((Object)AC.uri.getLocalName())) {
            if (log.isDebugEnabled()) {
                log.debug("No Application matched request URI <{}>, dispatching to ProxyResourceBase", this.getUriInfo().getQueryParameters().getFirst((Object)AC.uri.getLocalName()));
            }
            return ProxyResourceBase.class;
        }
        if (this.getDataset().isPresent()) {
            if (log.isDebugEnabled()) {
                log.debug("Serving request URI <{}> from Dataset <{}>, dispatching to ProxyResourceBase", (Object)this.getUriInfo().getAbsolutePath(), this.getDataset().get());
            }
            return ProxyResourceBase.class;
        }
        return this.getResourceClass();
    }

    @Path(value="sparql")
    public Object getSPARQLEndpoint() {
        return SPARQLEndpointImpl.class;
    }

    @Path(value="service")
    public Object getGraphStore() {
        return GraphStoreImpl.class;
    }

    @Path(value="ns")
    public Object getNamespace() {
        return Namespace.class;
    }

    @Path(value="ns/{slug}/")
    public Object getSubOntology() {
        return Namespace.class;
    }

    @Path(value="sign up")
    public Object getSignUp() {
        return SignUp.class;
    }

    @Path(value="request access")
    public Object getRequestAccess() {
        return RequestAccess.class;
    }

    @Path(value="uploads/{sha1sum}")
    public Object getFileItem() {
        return com.atomgraph.linkeddatahub.resource.upload.sha1.Item.class;
    }

    @Path(value="importer")
    public Object getImportEndpoint() {
        return Importer.class;
    }

    @Path(value="add")
    public Object getAddEndpoint() {
        return Add.class;
    }

    @Path(value="transform")
    public Object getTransformEndpoint() {
        return Transform.class;
    }

    @Path(value="clear")
    public Object getClearEndpoint() {
        return Clear.class;
    }

    @Path(value="oauth2/authorize/google")
    public Object getAuthorizeGoogle() {
        return Authorize.class;
    }

    @Path(value="oauth2/login")
    public Object getOAuth2Login() {
        return Login.class;
    }

    public Class getResourceClass() {
        return Item.class;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Optional<Dataset> getDataset() {
        return this.dataset;
    }

    public Application getSystem() {
        return this.system;
    }
}

