/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.model.impl;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.riot.lang.RDFPostReader;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.MediaType;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.io.ValidatingModelProvider;
import com.atomgraph.linkeddatahub.server.model.Patchable;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.util.PatchUpdateVisitor;
import com.atomgraph.linkeddatahub.server.util.Skolemizer;
import com.atomgraph.linkeddatahub.vocabulary.Default;
import com.atomgraph.linkeddatahub.vocabulary.NFO;
import com.atomgraph.processor.vocabulary.DH;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.datatypes.xsd.XSDDateTime;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.update.UpdateRequest;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStoreImpl
extends com.atomgraph.core.model.impl.GraphStoreImpl
implements Patchable {
    private static final Logger log = LoggerFactory.getLogger(GraphStoreImpl.class);
    public static Function<Model, Resource> CREATE_GRAPH = new /* Unavailable Anonymous Inner Class!! */;
    private final UriInfo uriInfo;
    private final com.atomgraph.linkeddatahub.apps.model.Application application;
    private final Ontology ontology;
    private final Service service;
    private final Providers providers;
    private final Application system;
    private final UriBuilder uploadsUriBuilder;
    private final MessageDigest messageDigest;
    private final URI ownerDocURI;
    private final URI secretaryDocURI;
    private final SecurityContext securityContext;
    private final Optional<AgentContext> agentContext;

    @Inject
    public GraphStoreImpl(@Context Request request, @Context UriInfo uriInfo, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Ontology> ontology, Optional<Service> service, @Context SecurityContext securityContext, Optional<AgentContext> agentContext, @Context Providers providers, Application system) {
        super(request, (com.atomgraph.core.model.Service)service.get(), mediaTypes);
        if (ontology.isEmpty()) {
            throw new InternalServerErrorException("Ontology is not specified");
        }
        if (service.isEmpty()) {
            throw new InternalServerErrorException("Service is not specified");
        }
        this.uriInfo = uriInfo;
        this.application = application;
        this.ontology = ontology.get();
        this.service = service.get();
        this.securityContext = securityContext;
        this.agentContext = agentContext;
        this.providers = providers;
        this.system = system;
        this.messageDigest = system.getMessageDigest();
        this.uploadsUriBuilder = uriInfo.getBaseUriBuilder().path("uploads");
        URI ownerURI = URI.create(application.getMaker().getURI());
        try {
            this.ownerDocURI = new URI(ownerURI.getScheme(), ownerURI.getSchemeSpecificPart(), null).normalize();
            this.secretaryDocURI = new URI(system.getSecretaryWebIDURI().getScheme(), system.getSecretaryWebIDURI().getSchemeSpecificPart(), null).normalize();
        }
        catch (URISyntaxException ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    @POST
    public Response post(Model model, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        boolean created;
        if (log.isTraceEnabled()) {
            log.trace("POST Graph Store request with RDF payload: {} payload size(): {}", (Object)model, (Object)model.size());
        }
        if (!defaultGraph.booleanValue() && graphUri == null) {
            Resource graph = (Resource)CREATE_GRAPH.apply(model);
            if (graph == null) {
                throw new InternalServerErrorException("Named graph skolemization failed");
            }
            graphUri = URI.create(graph.getURI());
            created = true;
            model.createResource(graphUri.toString()).addLiteral(DCTerms.created, ResourceFactory.createTypedLiteral((Object)GregorianCalendar.getInstance()));
        } else {
            created = false;
        }
        new Skolemizer(graphUri.toString()).apply(model);
        Response response = super.post(model, Boolean.valueOf(false), graphUri);
        if (created) {
            return Response.created((URI)graphUri).build();
        }
        return response;
    }

    @PUT
    public Response put(Model model, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        if (graphUri == null) {
            throw new BadRequestException("Named graph not specified");
        }
        if (this.getOwnerDocURI().equals(graphUri)) {
            throw new BadRequestException("Cannot update application owner's document");
        }
        if (this.getSecretaryDocURI().equals(graphUri)) {
            throw new BadRequestException("Cannot update application secretary's document");
        }
        if (!(model.createResource(graphUri.toString()).hasProperty(RDF.type, (RDFNode)Default.Root) || model.createResource(graphUri.toString()).hasProperty(RDF.type, (RDFNode)DH.Container) || model.createResource(graphUri.toString()).hasProperty(RDF.type, (RDFNode)DH.Item))) {
            throw new BadRequestException("Named graph <" + graphUri + "> must contain a document resource (instance of dh:Container or dh:Item)");
        }
        model.createResource(graphUri.toString()).removeAll(DCTerms.modified).addLiteral(DCTerms.modified, ResourceFactory.createTypedLiteral((Object)GregorianCalendar.getInstance()));
        new Skolemizer(graphUri.toString()).apply(model);
        return super.put(model, defaultGraph, graphUri);
    }

    @PATCH
    public Response patch(UpdateRequest updateRequest, @QueryParam(value="graph") URI graphUri) {
        if (updateRequest == null) {
            throw new BadRequestException("SPARQL update not specified");
        }
        if (graphUri == null) {
            throw new BadRequestException("Named graph not specified");
        }
        updateRequest.getOperations().forEach(update -> {
            PatchUpdateVisitor visitor = new PatchUpdateVisitor();
            update.visit((UpdateVisitor)visitor);
            if (visitor.isContainsNamedGraph()) {
                if (log.isWarnEnabled()) {
                    log.debug("SPARQL update used with PATCH method cannot contain the GRAPH keyword");
                }
                throw new WebApplicationException("SPARQL update used with PATCH method cannot contain the GRAPH keyword", 422);
            }
            if (!(update instanceof UpdateModify)) {
                throw new WebApplicationException("Only UpdateModify form of SPARQL Update is supported", 422);
            }
            UpdateModify updateModify = (UpdateModify)update;
            updateModify.setWithIRI(NodeFactory.createURI((String)graphUri.toString()));
        });
        this.getService().getEndpointAccessor().update(updateRequest, Collections.emptyList(), Collections.emptyList());
        return Response.ok().build();
    }

    @OPTIONS
    public Response options() {
        Response.ResponseBuilder rb = Response.ok().allow(new String[]{"GET"}).allow(new String[]{"POST"}).allow(new String[]{"PUT"}).allow(new String[]{"DELETE"});
        String acceptWritable = StringUtils.join((Iterable)this.getWritableMediaTypes(Model.class), (String)",");
        rb.header("Accept-Post", (Object)acceptWritable);
        return rb.build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response postMultipart(FormDataMultiPart multiPart, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        if (log.isDebugEnabled()) {
            log.debug("MultiPart fields: {} body parts: {}", (Object)multiPart.getFields(), (Object)multiPart.getBodyParts());
        }
        try {
            boolean created;
            Model model = this.parseModel(multiPart);
            MessageBodyReader reader = this.getProviders().getMessageBodyReader(Model.class, null, null, (javax.ws.rs.core.MediaType)com.atomgraph.core.MediaType.APPLICATION_NTRIPLES_TYPE);
            if (reader instanceof ValidatingModelProvider) {
                ValidatingModelProvider validatingModelProvider = (ValidatingModelProvider)reader;
                model = validatingModelProvider.processRead(model);
            }
            if (!defaultGraph.booleanValue() && graphUri == null) {
                Resource graph = (Resource)CREATE_GRAPH.apply(model);
                if (graph == null) {
                    throw new InternalServerErrorException("Named graph skolemization failed");
                }
                graphUri = URI.create(graph.getURI());
                created = true;
                model.createResource(graphUri.toString()).addLiteral(DCTerms.created, ResourceFactory.createTypedLiteral((Object)GregorianCalendar.getInstance()));
            } else {
                created = false;
            }
            new Skolemizer(graphUri.toString()).apply(model);
            int fileCount = this.writeFiles(model, this.getFileNameBodyPartMap(multiPart));
            if (log.isDebugEnabled()) {
                log.debug("# of files uploaded: {} ", (Object)fileCount);
            }
            if (log.isDebugEnabled()) {
                log.debug("POSTed Model size: {}", (Object)model.size());
            }
            Response response = this.post(model, defaultGraph, graphUri);
            if (created) {
                return Response.created((URI)graphUri).build();
            }
            return response;
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("URI '{}' has syntax error in request with media type: {}", (Object)ex.getInput(), (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
        catch (RuntimeIOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not read uploaded file as media type: {}", (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    public Response putMultipart(FormDataMultiPart multiPart, @QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        if (graphUri == null) {
            throw new InternalServerErrorException("Named graph not specified");
        }
        if (log.isDebugEnabled()) {
            log.debug("MultiPart fields: {} body parts: {}", (Object)multiPart.getFields(), (Object)multiPart.getBodyParts());
        }
        try {
            Model model = this.parseModel(multiPart);
            MessageBodyReader reader = this.getProviders().getMessageBodyReader(Model.class, null, null, (javax.ws.rs.core.MediaType)com.atomgraph.core.MediaType.APPLICATION_NTRIPLES_TYPE);
            if (reader instanceof ValidatingModelProvider) {
                ValidatingModelProvider validatingModelProvider = (ValidatingModelProvider)reader;
                model = validatingModelProvider.processRead(model);
            }
            if (log.isDebugEnabled()) {
                log.debug("POSTed Model size: {}", (Object)model.size());
            }
            int fileCount = this.writeFiles(model, this.getFileNameBodyPartMap(multiPart));
            if (log.isDebugEnabled()) {
                log.debug("# of files uploaded: {} ", (Object)fileCount);
            }
            new Skolemizer(graphUri.toString()).apply(model);
            return this.put(model, defaultGraph, graphUri);
        }
        catch (URISyntaxException ex) {
            if (log.isErrorEnabled()) {
                log.error("URI '{}' has syntax error in request with media type: {}", (Object)ex.getInput(), (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
        catch (RuntimeIOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Could not read uploaded file as media type: {}", (Object)multiPart.getMediaType());
            }
            throw new BadRequestException((Throwable)ex);
        }
    }

    @DELETE
    public Response delete(@QueryParam(value="default") @DefaultValue(value="false") Boolean defaultGraph, @QueryParam(value="graph") URI graphUri) {
        if (this.getApplication().getBaseURI().equals(graphUri)) {
            throw new BadRequestException("Cannot delete Root document at application's base URI");
        }
        if (this.getOwnerDocURI().equals(graphUri)) {
            throw new BadRequestException("Cannot delete application owner's document");
        }
        if (this.getSecretaryDocURI().equals(graphUri)) {
            throw new BadRequestException("Cannot delete application secretary's document");
        }
        return super.delete(Boolean.valueOf(false), graphUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeFiles(Model model, Map<String, FormDataBodyPart> fileNameBodyPartMap) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (fileNameBodyPartMap == null) {
            throw new IllegalArgumentException("Map<String, FormDataBodyPart> cannot be null");
        }
        int count = 0;
        try (ResIterator resIt = model.listResourcesWithProperty((Property)NFO.fileName);){
            while (resIt.hasNext()) {
                Resource file = (Resource)resIt.next();
                String fileName = file.getProperty((Property)NFO.fileName).getString();
                FormDataBodyPart bodyPart = fileNameBodyPartMap.get(fileName);
                if (bodyPart == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Writing FormDataBodyPart with fileName {} to file with URI {}", (Object)fileName, (Object)file.getURI());
                }
                this.writeFile(file, bodyPart);
                ++count;
            }
        }
        return count;
    }

    public Model parseModel(FormDataMultiPart multiPart) throws URISyntaxException {
        if (multiPart == null) {
            throw new IllegalArgumentException("FormDataMultiPart cannot be null");
        }
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (FormDataBodyPart bodyPart : multiPart.getBodyParts()) {
            if (log.isDebugEnabled()) {
                log.debug("Body part media type: {} headers: {}", (Object)bodyPart.getMediaType(), (Object)bodyPart.getHeaders());
            }
            if (bodyPart.getContentDisposition().getFileName() != null && !bodyPart.getContentDisposition().getFileName().isEmpty()) {
                keys.add(bodyPart.getName());
                if (log.isDebugEnabled()) {
                    log.debug("FormDataBodyPart name: {} value: {}", (Object)bodyPart.getName(), (Object)bodyPart.getContentDisposition().getFileName());
                }
                values.add(bodyPart.getContentDisposition().getFileName());
                continue;
            }
            if (!bodyPart.isSimple() || bodyPart.getValue().isEmpty()) continue;
            keys.add(bodyPart.getName());
            if (log.isDebugEnabled()) {
                log.debug("FormDataBodyPart name: {} value: {}", (Object)bodyPart.getName(), (Object)bodyPart.getValue());
            }
            values.add(bodyPart.getValue());
        }
        return RDFPostReader.parse(keys, values);
    }

    public Map<String, FormDataBodyPart> getFileNameBodyPartMap(FormDataMultiPart multiPart) {
        if (multiPart == null) {
            throw new IllegalArgumentException("FormDataMultiPart cannot be null");
        }
        HashMap<String, FormDataBodyPart> fileNameBodyPartMap = new HashMap<String, FormDataBodyPart>();
        for (FormDataBodyPart bodyPart : multiPart.getBodyParts()) {
            if (log.isDebugEnabled()) {
                log.debug("Body part media type: {} headers: {}", (Object)bodyPart.getMediaType(), (Object)bodyPart.getHeaders());
            }
            if (bodyPart.getContentDisposition().getFileName() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("FormDataBodyPart name: {} value: {}", (Object)bodyPart.getName(), (Object)bodyPart.getContentDisposition().getFileName());
            }
            fileNameBodyPartMap.put(bodyPart.getContentDisposition().getFileName(), bodyPart);
        }
        return fileNameBodyPartMap;
    }

    public File writeFile(URI uri, URI base, InputStream is) {
        return this.writeFile(uri, base, this.getSystem().getUploadRoot(), is);
    }

    public File writeFile(URI uri, URI base, URI uploadRoot, InputStream is) {
        if (uri == null) {
            throw new IllegalArgumentException("File URI cannot be null");
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("File URI must be absolute");
        }
        if (base == null) {
            throw new IllegalArgumentException("Base URI cannot be null");
        }
        if (uploadRoot == null) {
            throw new IllegalArgumentException("Upload root URI cannot be null");
        }
        URI relative = base.relativize(uri);
        if (log.isDebugEnabled()) {
            log.debug("Upload folder root URI: {}", (Object)uploadRoot);
        }
        File file = new File(uploadRoot.resolve(relative));
        return this.writeFile(file, is);
    }

    public File writeFile(File file, InputStream is) {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("File InputStream cannot be null");
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Writing input stream: {} to file: {}", (Object)is, (Object)file);
            }
            FileChannel destination = fos.getChannel();
            destination.transferFrom(Channels.newChannel(is), 0L, 0x6400000L);
            file2 = file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Error writing file: {}", (Object)file);
                }
                throw new InternalServerErrorException((Throwable)ex);
            }
        }
        fos.close();
        return file2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File writeFile(Resource resource, FormDataBodyPart bodyPart) {
        if (resource == null) {
            throw new IllegalArgumentException("File Resource cannot be null");
        }
        if (!resource.isURIResource()) {
            throw new IllegalArgumentException("File Resource must have a URI");
        }
        if (bodyPart == null) {
            throw new IllegalArgumentException("FormDataBodyPart cannot be null");
        }
        try (InputStream is = (InputStream)bodyPart.getEntityAs(InputStream.class);){
            File file;
            try (DigestInputStream dis = new DigestInputStream(is, this.getMessageDigest());){
                dis.getMessageDigest().reset();
                File tempFile = File.createTempFile("tmp", null);
                FileChannel destination = new FileOutputStream(tempFile).getChannel();
                destination.transferFrom(Channels.newChannel(dis), 0L, 0x6400000L);
                String sha1Hash = Hex.encodeHexString((byte[])dis.getMessageDigest().digest());
                if (log.isDebugEnabled()) {
                    log.debug("Wrote file: {} with SHA1 hash: {}", (Object)tempFile, (Object)sha1Hash);
                }
                resource.addLiteral(FOAF.sha1, (Object)sha1Hash);
                if (!resource.hasProperty(DCTerms.format)) {
                    resource.addProperty(DCTerms.format, (RDFNode)MediaType.toResource((javax.ws.rs.core.MediaType)bodyPart.getMediaType()));
                }
                URI sha1Uri = this.getUploadsUriBuilder().path("{sha1}").build(new Object[]{sha1Hash});
                if (log.isDebugEnabled()) {
                    log.debug("Renaming resource: {} to SHA1 based URI: {}", (Object)resource, (Object)sha1Uri);
                }
                ResourceUtils.renameResource((Resource)resource, (String)sha1Uri.toString());
                file = this.writeFile(sha1Uri, this.getUriInfo().getBaseUri(), (InputStream)new FileInputStream(tempFile));
            }
            return file;
        }
        catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("File I/O error", (Throwable)ex);
            }
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    public Date getLastModified(Model model, URI graphUri) {
        if (graphUri == null) {
            return null;
        }
        return this.getLastModified(model.createResource(graphUri.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastModified(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        try (StmtIterator createdIt = resource.listProperties(DCTerms.created);){
            while (createdIt.hasNext()) {
                Statement stmt = (Statement)createdIt.next();
                if (!stmt.getObject().isLiteral() || !(stmt.getObject().asLiteral().getValue() instanceof XSDDateTime)) continue;
                dates.add(((XSDDateTime)stmt.getObject().asLiteral().getValue()).asCalendar().getTime());
            }
        }
        try (StmtIterator modifiedIt = resource.listProperties(DCTerms.modified);){
            while (modifiedIt.hasNext()) {
                Statement stmt = (Statement)modifiedIt.next();
                if (!stmt.getObject().isLiteral() || !(stmt.getObject().asLiteral().getValue() instanceof XSDDateTime)) continue;
                dates.add(((XSDDateTime)stmt.getObject().asLiteral().getValue()).asCalendar().getTime());
            }
        }
        if (!dates.isEmpty()) {
            return (Date)Collections.max(dates);
        }
        return null;
    }

    public List<Locale> getLanguages() {
        return this.getSystem().getSupportedLanguages();
    }

    public UriBuilder getUploadsUriBuilder() {
        return this.uploadsUriBuilder.clone();
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return this.application;
    }

    public Ontology getOntology() {
        return this.ontology;
    }

    public Service getService() {
        return this.service;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public Optional<AgentContext> getAgentContext() {
        return this.agentContext;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public Application getSystem() {
        return this.system;
    }

    public URI getOwnerDocURI() {
        return this.ownerDocURI;
    }

    public URI getSecretaryDocURI() {
        return this.secretaryDocURI;
    }
}

