/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.model.impl;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.core.client.SPARQLClient;
import com.atomgraph.core.exception.BadGatewayException;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.Dataset;
import com.atomgraph.linkeddatahub.client.filter.auth.IDTokenDelegationFilter;
import com.atomgraph.linkeddatahub.client.filter.auth.WebIDDelegationFilter;
import com.atomgraph.linkeddatahub.model.Service;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.server.security.IDTokenSecurityContext;
import com.atomgraph.linkeddatahub.server.security.WebIDSecurityContext;
import com.atomgraph.linkeddatahub.vocabulary.LDH;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.FileManager;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyResourceBase
extends com.atomgraph.client.model.impl.ProxyResourceBase {
    private static final Logger log = LoggerFactory.getLogger(ProxyResourceBase.class);
    private final UriInfo uriInfo;
    private final ContainerRequestContext crc;
    private final com.atomgraph.linkeddatahub.apps.model.Application application;
    private final Service service;
    private final DataManager dataManager;
    private final MediaType[] readableMediaTypes;
    private final Providers providers;
    private final Application system;

    @Inject
    public ProxyResourceBase(@Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Service> service, @Context SecurityContext securityContext, @Context ContainerRequestContext crc, Application system, @Context HttpServletRequest httpServletRequest, DataManager dataManager, Optional<AgentContext> agentContext, @Context Providers providers, Optional<Dataset> dataset) {
        this(uriInfo, request, httpHeaders, mediaTypes, application, service, securityContext, crc, uriInfo.getQueryParameters().getFirst((Object)AC.uri.getLocalName()) == null ? (dataset.isEmpty() ? null : dataset.get().getProxied(uriInfo.getAbsolutePath())) : URI.create((String)uriInfo.getQueryParameters().getFirst((Object)AC.uri.getLocalName())), uriInfo.getQueryParameters().getFirst((Object)AC.endpoint.getLocalName()) == null ? null : URI.create((String)uriInfo.getQueryParameters().getFirst((Object)AC.endpoint.getLocalName())), uriInfo.getQueryParameters().getFirst((Object)AC.accept.getLocalName()) == null ? null : MediaType.valueOf((String)((String)uriInfo.getQueryParameters().getFirst((Object)AC.accept.getLocalName()))), uriInfo.getQueryParameters().getFirst((Object)AC.mode.getLocalName()) == null ? null : URI.create((String)uriInfo.getQueryParameters().getFirst((Object)AC.mode.getLocalName())), system, httpServletRequest, dataManager, agentContext, providers);
    }

    protected ProxyResourceBase(@Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders, MediaTypes mediaTypes, com.atomgraph.linkeddatahub.apps.model.Application application, Optional<Service> service, @Context SecurityContext securityContext, @Context ContainerRequestContext crc, @QueryParam(value="uri") URI uri, @QueryParam(value="endpoint") URI endpoint, @QueryParam(value="accept") MediaType accept, @QueryParam(value="mode") URI mode, Application system, @Context HttpServletRequest httpServletRequest, DataManager dataManager, Optional<AgentContext> agentContext, @Context Providers providers) {
        super(uriInfo, request, httpHeaders, mediaTypes, uri, endpoint, accept, mode, system.getClient(), httpServletRequest);
        this.uriInfo = uriInfo;
        this.application = application;
        this.service = service.get();
        this.crc = crc;
        this.dataManager = dataManager;
        this.providers = providers;
        this.system = system;
        ArrayList readableMediaTypesList = new ArrayList();
        readableMediaTypesList.addAll(mediaTypes.getReadable(Model.class));
        readableMediaTypesList.addAll(mediaTypes.getReadable(ResultSet.class));
        this.readableMediaTypes = (MediaType[])readableMediaTypesList.toArray(MediaType[]::new);
        if (agentContext.isPresent()) {
            AgentContext agentContext2;
            if (agentContext.get() instanceof WebIDSecurityContext) {
                super.getWebTarget().register((Object)new WebIDDelegationFilter((Resource)agentContext.get().getAgent()));
            }
            if ((agentContext2 = agentContext.get()) instanceof IDTokenSecurityContext) {
                IDTokenSecurityContext iDTokenSecurityContext = (IDTokenSecurityContext)agentContext2;
                super.getWebTarget().register((Object)new IDTokenDelegationFilter((Resource)agentContext.get().getAgent(), iDTokenSecurityContext.getJWTToken(), uriInfo.getBaseUri().getPath(), null));
            }
        }
    }

    public Response get(WebTarget target) {
        if (((FileManager)this.getDataManager()).hasCachedModel(target.getUri().toString()) || this.getDataManager().isResolvingMapped() && this.getDataManager().isMapped(target.getUri().toString())) {
            if (log.isDebugEnabled()) {
                log.debug("hasCachedModel({}): {}", (Object)target.getUri(), (Object)((FileManager)this.getDataManager()).hasCachedModel(target.getUri().toString()));
            }
            if (log.isDebugEnabled()) {
                log.debug("isMapped({}): {}", (Object)target.getUri(), (Object)this.getDataManager().isMapped(target.getUri().toString()));
            }
            return this.getResponse(this.getDataManager().loadModel(target.getUri().toString()));
        }
        if (this.getApplication().getBaseURI().relativize(target.getUri()).isAbsolute()) {
            SPARQLClient sparqlClient;
            if (this.getUriInfo().getQueryParameters().containsKey((Object)AC.endpoint.getLocalName())) {
                String endpointURI = (String)this.getUriInfo().getQueryParameters().getFirst((Object)AC.endpoint.getLocalName());
                sparqlClient = SPARQLClient.create((WebTarget)this.getClient().target(endpointURI));
            } else {
                sparqlClient = this.getService().getSPARQLClient();
            }
            Query query = QueryFactory.create((String)("DESCRIBE <" + target.getUri() + ">"));
            Model localModel = sparqlClient.loadModel(query);
            this.getContainerRequestContext().setProperty(LDH.localGraph.getURI(), (Object)localModel);
            try {
                Response response = super.get(target);
                Object object = response.getEntity();
                if (object instanceof Model) {
                    Model model = (Model)object;
                    if (target.getUri().getFragment() != null) {
                        model = ModelFactory.createDefaultModel().add(model.getResource(target.getUri().toString()).listProperties());
                    }
                    this.getContainerRequestContext().setProperty(LDH.originalGraph.getURI(), (Object)ModelFactory.createDefaultModel().add(model));
                    model.add(localModel);
                }
            }
            catch (BadGatewayException ex) {
                this.getContainerRequestContext().setProperty(LDH.originalGraph.getURI(), (Object)ModelFactory.createDefaultModel());
                if (!localModel.isEmpty()) {
                    return this.getResponse(localModel);
                }
                throw ex;
            }
        }
        return super.get(target);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response postMultipart(FormDataMultiPart multiPart) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        try (Response cr = this.getWebTarget().request().accept((MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(MediaType[]::new)).post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));){
            if (log.isDebugEnabled()) {
                log.debug("POSTing multipart data to URI: {}", (Object)this.getWebTarget().getUri());
            }
            Response response = this.getResponse(cr);
            return response;
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    public Response putMultipart(FormDataMultiPart multiPart) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        try (Response cr = this.getWebTarget().request().accept((MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(MediaType[]::new)).put(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()));){
            if (log.isDebugEnabled()) {
                log.debug("PUTing multipart data to URI: {}", (Object)this.getWebTarget().getUri());
            }
            Response response = this.getResponse(cr);
            return response;
        }
    }

    public List<Locale> getLanguages() {
        return this.getSystem().getSupportedLanguages();
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return this.application;
    }

    public Service getService() {
        return this.service;
    }

    public ContainerRequestContext getContainerRequestContext() {
        return this.crc;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public MediaType[] getReadableMediaTypes() {
        return this.readableMediaTypes;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public Application getSystem() {
        return this.system;
    }
}

