/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.security;

import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentSecurityContext
implements SecurityContext,
AgentContext {
    private static final Logger log = LoggerFactory.getLogger(AgentSecurityContext.class);
    private final Agent agent;
    private final String authScheme;

    public AgentSecurityContext(String authScheme, Agent agent) {
        this.authScheme = authScheme;
        this.agent = agent;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public Principal getUserPrincipal() {
        return this.getAgent();
    }

    public boolean isUserInRole(String groupURI) {
        return this.getAgent().getModel().contains(this.getAgent().getModel().createResource(groupURI), FOAF.member, (RDFNode)this.getAgent());
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        return this.authScheme;
    }
}

