/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.util;

import com.atomgraph.linkeddatahub.server.util.MessageBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MessageBuilder {
    private final MimeMessage message;
    private final MultipartBuilder multipartBuilder = new MultipartBuilder(this);

    private MessageBuilder(Session session) {
        this.message = new MimeMessage(session);
    }

    private MessageBuilder(Properties properties) {
        this(Session.getDefaultInstance((Properties)properties));
    }

    private MessageBuilder(Properties properties, Authenticator auth) {
        this(Session.getDefaultInstance((Properties)properties, (Authenticator)auth));
    }

    public static MessageBuilder fromSession(Session session) {
        return new MessageBuilder(session);
    }

    public static MessageBuilder fromProperties(Properties properties) {
        return new MessageBuilder(properties);
    }

    public static MessageBuilder fromPropertiesAndAuth(Properties properties, Authenticator auth) {
        return new MessageBuilder(properties, auth);
    }

    public MessageBuilder from(Address address) throws MessagingException {
        this.getMessage().setFrom(address);
        return this;
    }

    public MessageBuilder from(String from, String personal) throws MessagingException, UnsupportedEncodingException {
        return this.from((Address)new InternetAddress(from, personal));
    }

    public MessageBuilder recipient(Message.RecipientType type, Address address) throws MessagingException {
        this.getMessage().addRecipient(type, address);
        return this;
    }

    public MessageBuilder recipient(Message.RecipientType type, String to) throws MessagingException, UnsupportedEncodingException {
        return this.recipient(type, (Address)new InternetAddress(to));
    }

    public MessageBuilder recipient(Message.RecipientType type, String to, String personal) throws MessagingException, UnsupportedEncodingException {
        return this.recipient(type, (Address)new InternetAddress(to, personal));
    }

    public MessageBuilder to(Address address) throws MessagingException, UnsupportedEncodingException {
        return this.recipient(Message.RecipientType.TO, address);
    }

    public MessageBuilder to(String to) throws MessagingException, UnsupportedEncodingException {
        return this.recipient(Message.RecipientType.TO, to);
    }

    public MessageBuilder to(String to, String personal) throws MessagingException, UnsupportedEncodingException {
        return this.recipient(Message.RecipientType.TO, to, personal);
    }

    public MessageBuilder replyTo(Address[] addresses) throws MessagingException, UnsupportedEncodingException {
        this.getMessage().setReplyTo(addresses);
        return this;
    }

    public MessageBuilder replyTo(Address address) throws MessagingException, UnsupportedEncodingException {
        if (this.getMessage().getReplyTo() == null) {
            return this.replyTo(new Address[]{address});
        }
        Address[] addresses = Arrays.copyOf(this.getMessage().getReplyTo(), this.getMessage().getReplyTo().length + 1);
        addresses[addresses.length - 1] = address;
        return this.replyTo(addresses);
    }

    public MessageBuilder replyTo(String replyTo) throws MessagingException, UnsupportedEncodingException {
        return this.replyTo((Address)new InternetAddress(replyTo));
    }

    public MessageBuilder replyTo(String replyTo, String personal) throws MessagingException, UnsupportedEncodingException {
        return this.replyTo((Address)new InternetAddress(replyTo, personal));
    }

    public MessageBuilder subject(String subject) throws MessagingException {
        this.getMessage().setSubject(subject);
        return this;
    }

    public MessageBuilder text(String text) throws MessagingException {
        this.getMessage().setText(text);
        return this;
    }

    public MessageBuilder bodyPart(BodyPart bodyPart) throws MessagingException {
        this.getMultipartBuilder().part(bodyPart);
        return this;
    }

    public MessageBuilder textBodyPart(String body) throws MessagingException {
        this.getMultipartBuilder().textPart(body);
        return this;
    }

    public MessageBuilder dataBodyPart(DataSource source, String fileName) throws MessagingException {
        this.getMultipartBuilder().dataPart(source, fileName);
        return this;
    }

    public MessageBuilder byteArrayBodyPart(byte[] data, String type, String fileName) throws MessagingException {
        this.getMultipartBuilder().byteArrayPart(data, type, fileName);
        return this;
    }

    public MessageBuilder inputStreamBodyPart(InputStream data, String type, String fileName) throws MessagingException, IOException {
        this.getMultipartBuilder().inputStreamPart(data, type, fileName);
        return this;
    }

    public MessageBuilder debug() {
        this.getMessage().getSession().setDebug(true);
        return this;
    }

    public Message build() throws MessagingException {
        this.getMessage().setContent(this.getMultipartBuilder().getMultipart());
        return this.getMessage();
    }

    private MimeMessage getMessage() {
        return this.message;
    }

    private MultipartBuilder getMultipartBuilder() {
        return this.multipartBuilder;
    }
}

