/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.util;

import com.atomgraph.client.vocabulary.LDT;
import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.processor.exception.OntologyException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.Client;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ModelGetter;
import org.apache.jena.rdf.model.ModelReader;
import org.apache.jena.util.FileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyModelGetter
implements ModelGetter {
    private static final Logger log = LoggerFactory.getLogger(OntologyModelGetter.class);
    private final EndUserApplication app;
    private final OntModelSpec ontModelSpec;
    private final Query ontologyQuery;

    public OntologyModelGetter(EndUserApplication app, OntModelSpec ontModelSpec, Query ontologyQuery, Client client, MediaTypes mediaTypes) {
        this(app, ontModelSpec, ontologyQuery);
    }

    public OntologyModelGetter(EndUserApplication app, OntModelSpec ontModelSpec, Query ontologyQuery) {
        this.app = app;
        this.ontModelSpec = ontModelSpec;
        this.ontologyQuery = ontologyQuery;
    }

    public Model getModel(String uri) {
        ParameterizedSparqlString ontologyPss = new ParameterizedSparqlString(this.getOntologyQuery().toString());
        ontologyPss.setIri(LDT.ontology.getLocalName(), uri);
        Model model = this.getApplication().getAdminApplication().getService().getSPARQLClient().loadModel(ontologyPss.asQuery());
        if (!model.isEmpty()) {
            return model;
        }
        try {
            URI ontologyURI = URI.create(uri);
            URI ontDocURI = new URI(ontologyURI.getScheme(), ontologyURI.getSchemeSpecificPart(), null).normalize();
            FileManager fileManager = this.getOntModelSpec().getDocumentManager().getFileManager();
            return fileManager.loadModel(uri, ontDocURI.toString(), null);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Model getModel(String uri, ModelReader loadIfAbsent) {
        try {
            return this.getModel(uri);
        }
        catch (OntologyException ex) {
            return loadIfAbsent.readModel(ModelFactory.createDefaultModel(), uri);
        }
    }

    public EndUserApplication getApplication() {
        return this.app;
    }

    public OntModelSpec getOntModelSpec() {
        return this.ontModelSpec;
    }

    public Query getOntologyQuery() {
        return this.ontologyQuery;
    }
}

