/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.server.util;

import com.atomgraph.linkeddatahub.vocabulary.LDH;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class Skolemizer
implements Function<Model, Model> {
    private final String base;
    private final Property fragmentProperty;

    public Skolemizer(String base, Property fragmentProperty) {
        this.base = base;
        this.fragmentProperty = fragmentProperty;
    }

    public Skolemizer(String base) {
        this(base, (Property)LDH.fragment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model apply(Model model) {
        HashMap<Resource, Object> bnodes = new HashMap<Resource, Object>();
        try (ExtendedIterator it = model.listSubjects().filterKeep(res -> res.isAnon());){
            while (it.hasNext()) {
                Resource bnode = (Resource)it.next();
                Object fragment = bnode.hasProperty(this.getFragmentProperty()) ? bnode.getProperty(this.getFragmentProperty()).getString() : "id" + UUID.randomUUID().toString();
                bnodes.put(bnode, fragment);
            }
        }
        bnodes.entrySet().forEach(entry -> {
            if (this.getFragmentProperty() != null) {
                ((Resource)entry.getKey()).removeAll(this.getFragmentProperty());
            }
            ResourceUtils.renameResource((Resource)((Resource)entry.getKey()), (String)UriBuilder.fromUri((String)this.getBase()).fragment((String)entry.getValue()).build(new Object[0]).toString());
        });
        return model;
    }

    public String getBase() {
        return this.base;
    }

    public Property getFragmentProperty() {
        return this.fragmentProperty;
    }
}

