/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.writer;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.client.vocabulary.LDT;
import com.atomgraph.core.util.Link;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.AdminApplication;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.model.auth.Agent;
import com.atomgraph.linkeddatahub.server.io.ValidatingModelProvider;
import com.atomgraph.linkeddatahub.server.security.AuthorizationContext;
import com.atomgraph.linkeddatahub.vocabulary.ACL;
import com.atomgraph.linkeddatahub.vocabulary.FOAF;
import com.atomgraph.linkeddatahub.vocabulary.Google;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import com.atomgraph.linkeddatahub.vocabulary.LDH;
import com.atomgraph.linkeddatahub.vocabulary.LDHC;
import com.atomgraph.linkeddatahub.writer.Mode;
import com.atomgraph.linkeddatahub.writer.factory.xslt.XsltExecutableSupplier;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ModelXSLTWriterBase
extends com.atomgraph.client.writer.ModelXSLTWriterBase {
    private static final Logger log = LoggerFactory.getLogger(ModelXSLTWriterBase.class);
    private static final Set<String> NAMESPACES = new HashSet();
    public static final String TRANSLATIONS_PATH = "static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf";
    @Context
    SecurityContext securityContext;
    @Inject
    Application system;
    @Inject
    Provider<com.atomgraph.linkeddatahub.apps.model.Application> application;
    @Inject
    Provider<DataManager> dataManager;
    @Inject
    Provider<XsltExecutableSupplier> xsltExecSupplier;
    @Inject
    Provider<List<Mode>> modes;
    @Inject
    Provider<ContainerRequestContext> crc;
    @Inject
    Provider<Optional<AuthorizationContext>> authorizationContext;
    private final MessageDigest messageDigest;

    public ModelXSLTWriterBase(XsltExecutable xsltExec, OntModelSpec ontModelSpec, DataManager dataManager, MessageDigest messageDigest) {
        super(xsltExec, ontModelSpec, dataManager);
        this.messageDigest = messageDigest;
    }

    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headerMap, OutputStream entityStream) throws IOException {
        if (headerMap.containsKey((Object)"ETag") && headerMap.getFirst((Object)"ETag") instanceof EntityTag && this.getSecurityContext() != null && this.getSecurityContext().getUserPrincipal() instanceof Agent) {
            EntityTag eTag = (EntityTag)headerMap.getFirst((Object)"ETag");
            BigInteger eTagHash = new BigInteger(eTag.getValue(), 16);
            Agent agent = (Agent)this.getSecurityContext().getUserPrincipal();
            eTagHash = eTagHash.add(BigInteger.valueOf(agent.hashCode()));
            headerMap.replace((Object)"ETag", Arrays.asList(new EntityTag(eTagHash.toString(16))));
        }
        super.writeTo(this.processWrite(model), type, type, annotations, mediaType, headerMap, entityStream);
    }

    public <T extends XdmValue> Map<QName, XdmValue> getParameters(MultivaluedMap<String, Object> headerMap) throws TransformerException {
        Map params = super.getParameters(headerMap);
        try {
            Object originalModel;
            Object localModel;
            params.put(new QName("ldh", LDH.absolutePath.getNameSpace(), LDH.absolutePath.getLocalName()), new XdmAtomicValue(this.getAbsolutePath()));
            params.put(new QName("ldh", LDH.requestUri.getNameSpace(), LDH.requestUri.getLocalName()), new XdmAtomicValue(this.getRequestURI()));
            if (this.getURI() != null) {
                params.put(new QName("ac", AC.uri.getNameSpace(), AC.uri.getLocalName()), new XdmAtomicValue(this.getURI()));
            } else {
                params.put(new QName("ac", AC.uri.getNameSpace(), AC.uri.getLocalName()), new XdmAtomicValue(this.getAbsolutePath()));
            }
            com.atomgraph.linkeddatahub.apps.model.Application app = (com.atomgraph.linkeddatahub.apps.model.Application)this.getApplication().get();
            if (log.isDebugEnabled()) {
                log.debug("Passing $lapp:Application to XSLT: <{}>", (Object)app);
            }
            params.put(new QName("ldt", LDT.base.getNameSpace(), LDT.base.getLocalName()), new XdmAtomicValue(app.getBaseURI()));
            params.put(new QName("ldt", LDT.ontology.getNameSpace(), LDT.ontology.getLocalName()), new XdmAtomicValue(URI.create(app.getOntology().getURI())));
            params.put(new QName("lapp", LAPP.Application.getNameSpace(), LAPP.Application.getLocalName()), this.getXsltExecutable().getProcessor().newDocumentBuilder().build((Source)ModelXSLTWriterBase.getSource((Model)this.getAppModel(app, true))));
            URI endpointURI = this.getLinkURI(headerMap, SD.endpoint);
            if (endpointURI != null) {
                params.put(new QName("sd", SD.endpoint.getNameSpace(), SD.endpoint.getLocalName()), new XdmAtomicValue(endpointURI));
            }
            if (this.getSecurityContext() != null && this.getSecurityContext().getUserPrincipal() instanceof Agent) {
                Agent agent = (Agent)this.getSecurityContext().getUserPrincipal();
                if (log.isDebugEnabled()) {
                    log.debug("Passing $foaf:Agent to XSLT: <{}>", (Object)agent);
                }
                StreamSource source = ModelXSLTWriterBase.getSource((Model)agent.getModel());
                URI agentURI = URI.create(agent.getURI());
                URI agentDocUri = new URI(agentURI.getScheme(), agentURI.getSchemeSpecificPart(), null);
                source.setSystemId(agentDocUri.toString());
                params.put(new QName("acl", ACL.agent.getNameSpace(), ACL.agent.getLocalName()), new XdmAtomicValue(URI.create(agent.getURI())));
                params.put(new QName("foaf", FOAF.Agent.getNameSpace(), FOAF.Agent.getLocalName()), this.getXsltExecutable().getProcessor().newDocumentBuilder().build((Source)source));
            }
            if (((Optional)this.getAuthorizationContext().get()).isPresent()) {
                params.put(new QName("acl", ACL.mode.getNameSpace(), ACL.mode.getLocalName()), XdmValue.makeSequence((Iterable)((AuthorizationContext)((Optional)this.getAuthorizationContext().get()).get()).getModeURIs()));
            }
            if (this.getUriInfo().getQueryParameters().containsKey((Object)LDH.createGraph.getLocalName())) {
                params.put(new QName("ldh", LDH.createGraph.getNameSpace(), LDH.createGraph.getLocalName()), new XdmAtomicValue(Boolean.valueOf((String)this.getUriInfo().getQueryParameters().getFirst((Object)LDH.createGraph.getLocalName())).booleanValue()));
            }
            if (this.getUriInfo().getQueryParameters().containsKey((Object)LDH.access_to.getLocalName())) {
                params.put(new QName("ldh", LDH.access_to.getNameSpace(), LDH.access_to.getLocalName()), new XdmAtomicValue(URI.create((String)this.getUriInfo().getQueryParameters().getFirst((Object)LDH.access_to.getLocalName()))));
            }
            if (this.getHttpHeaders().getRequestHeader("Referer") != null) {
                URI referer = URI.create((String)this.getHttpHeaders().getRequestHeader("Referer").get(0));
                if (log.isDebugEnabled()) {
                    log.debug("Passing $Referer URI to XSLT: {}", (Object)referer);
                }
                params.put(new QName("", "", "Referer"), new XdmAtomicValue(referer));
            }
            if ((localModel = this.getContainerRequestContext().getProperty(LDH.localGraph.getURI())) instanceof Model) {
                Model model = (Model)localModel;
                params.put(new QName("ldh", LDH.localGraph.getNameSpace(), LDH.localGraph.getLocalName()), this.getXsltExecutable().getProcessor().newDocumentBuilder().build((Source)ModelXSLTWriterBase.getSource((Model)model)));
            }
            if ((originalModel = this.getContainerRequestContext().getProperty(LDH.originalGraph.getURI())) instanceof Model) {
                Model model = (Model)originalModel;
                params.put(new QName("ldh", LDH.originalGraph.getNameSpace(), LDH.originalGraph.getLocalName()), this.getXsltExecutable().getProcessor().newDocumentBuilder().build((Source)ModelXSLTWriterBase.getSource((Model)model)));
            }
            params.put(new QName("ldhc", LDHC.enableWebIDSignUp.getNameSpace(), LDHC.enableWebIDSignUp.getLocalName()), new XdmAtomicValue(this.getSystem().isEnableWebIDSignUp()));
            if (this.getSystem().getProperty(Google.clientID.getURI()) != null) {
                params.put(new QName("google", Google.clientID.getNameSpace(), Google.clientID.getLocalName()), new XdmAtomicValue((String)this.getSystem().getProperty(Google.clientID.getURI())));
            }
            return params;
        }
        catch (IOException | URISyntaxException | SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("Error reading Source stream");
            }
            throw new TransformerException(ex);
        }
    }

    public Model getAppModel(com.atomgraph.linkeddatahub.apps.model.Application app, boolean includeEndUserAdmin) {
        StmtIterator appStmts = app.listProperties();
        Model model = ModelFactory.createDefaultModel().add(appStmts);
        appStmts.close();
        if (includeEndUserAdmin) {
            if (app.canAs(AdminApplication.class)) {
                AdminApplication adminApp = (AdminApplication)app.as(AdminApplication.class);
                StmtIterator endUserAppStmts = adminApp.getEndUserApplication().listProperties();
                model.add(endUserAppStmts);
                endUserAppStmts.close();
            }
            if (app.canAs(EndUserApplication.class)) {
                EndUserApplication endUserApp = (EndUserApplication)app.as(EndUserApplication.class);
                StmtIterator adminApp = endUserApp.getAdminApplication().listProperties();
                model.add(adminApp);
                adminApp.close();
            }
        }
        return model;
    }

    public Model processWrite(Model model) {
        if (((com.atomgraph.linkeddatahub.apps.model.Application)this.getApplication().get()).canAs(EndUserApplication.class)) {
            return model;
        }
        if (this.getSecurityContext() != null && this.getSecurityContext().getUserPrincipal() instanceof Agent) {
            return model;
        }
        return (Model)ValidatingModelProvider.hashMboxes((MessageDigest)this.getMessageDigest()).apply(model);
    }

    public URI getLinkURI(MultivaluedMap<String, Object> headerMap, ObjectProperty property) {
        if (headerMap.get((Object)"Link") == null) {
            return null;
        }
        List<String> linkTokens = Arrays.asList(((List)headerMap.get((Object)"Link")).get(0).toString().split(","));
        List baseLinks = linkTokens.stream().map(header -> {
            try {
                return Link.valueOf((String)header.trim());
            }
            catch (URISyntaxException ex) {
                if (log.isWarnEnabled()) {
                    log.warn("Could not parse Link URI", (Throwable)ex);
                }
                return null;
            }
        }).filter(link -> link != null && link.getRel() != null && link.getRel().equals(property.getURI())).map(link -> link.getHref()).collect(Collectors.toList());
        if (!baseLinks.isEmpty()) {
            return (URI)baseLinks.get(0);
        }
        return null;
    }

    public Application getSystem() {
        return this.system;
    }

    public OntModelSpec getOntModelSpec() {
        return this.getSystem().getOntModelSpec();
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public DataManager getDataManager() {
        return (DataManager)this.getDataManagerProvider().get();
    }

    public Provider<DataManager> getDataManagerProvider() {
        return this.dataManager;
    }

    public URI getURI() throws URISyntaxException {
        return this.getURIParam(this.getUriInfo(), AC.uri.getLocalName());
    }

    public String getQuery() {
        if (this.getUriInfo().getQueryParameters().containsKey((Object)AC.query.getLocalName())) {
            return (String)this.getUriInfo().getQueryParameters().getFirst((Object)AC.query.getLocalName());
        }
        return null;
    }

    public XsltExecutable getXsltExecutable() {
        return (XsltExecutable)((XsltExecutableSupplier)this.xsltExecSupplier.get()).get();
    }

    public List<URI> getModes(Set<String> namespaces) {
        return this.getModes().stream().map(Mode::get).collect(Collectors.toList());
    }

    public List<Mode> getModes() {
        return (List)this.modes.get();
    }

    public Set<String> getSupportedNamespaces() {
        return NAMESPACES;
    }

    public Provider<com.atomgraph.linkeddatahub.apps.model.Application> getApplication() {
        return this.application;
    }

    public Provider<Optional<AuthorizationContext>> getAuthorizationContext() {
        return this.authorizationContext;
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public ContainerRequestContext getContainerRequestContext() {
        return (ContainerRequestContext)this.crc.get();
    }

    static {
        NAMESPACES.add("https://w3id.org/atomgraph/client#");
        NAMESPACES.add("https://w3id.org/atomgraph/linkeddatahub/templates#");
    }
}

