/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.writer.factory;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.core.MediaTypes;
import com.atomgraph.linkeddatahub.Application;
import com.atomgraph.linkeddatahub.apps.model.EndUserApplication;
import com.atomgraph.linkeddatahub.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import com.atomgraph.linkeddatahub.vocabulary.LAPP;
import com.atomgraph.linkeddatahub.writer.impl.DataManagerImpl;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.jena.util.LocationMapper;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DataManagerFactory
implements Factory<DataManager> {
    private static final Logger log = LoggerFactory.getLogger(DataManagerFactory.class);
    @Context
    UriInfo uriInfo;
    @Context
    ResourceContext resourceContext;
    @Context
    HttpServletRequest httpServletRequest;
    @Context
    Providers providers;
    @Context
    ServiceLocator serviceLocator;
    @Inject
    Application system;

    public DataManager provide() {
        return this.getDataManager(this.getApplication());
    }

    public void dispose(DataManager t) {
    }

    public DataManager getDataManager(com.atomgraph.linkeddatahub.apps.model.Application app) {
        Object baseManager = app.canAs(EndUserApplication.class) ? (com.atomgraph.core.util.jena.DataManager)this.getSystem().getOntModelSpec((EndUserApplication)app.as(EndUserApplication.class)).getDocumentManager().getFileManager() : this.getSystem().getDataManager();
        LinkedDataClient ldc = LinkedDataClient.create((Client)this.getSystem().getClient(), (MediaTypes)this.getSystem().getMediaTypes()).delegation(this.getUriInfo().getBaseUri(), this.getAgentContext());
        return new DataManagerImpl(LocationMapper.get(), new HashMap(baseManager.getModelCache()), (com.atomgraph.core.client.LinkedDataClient)ldc, true, this.getSystem().isPreemptiveAuth(), this.getSystem().isResolvingUncached(), URI.create(this.getHttpServletRequest().getRequestURL().toString()).resolve(this.getHttpServletRequest().getContextPath() + "/"), this.getAgentContext());
    }

    public Application getSystem() {
        return this.system;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public AgentContext getAgentContext() {
        return (AgentContext)this.getContainerRequestContext().getProperty(AgentContext.class.getCanonicalName());
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public ContainerRequestContext getContainerRequestContext() {
        return (ContainerRequestContext)this.serviceLocator.getService(ContainerRequestContext.class, new Annotation[0]);
    }

    public com.atomgraph.linkeddatahub.apps.model.Application getApplication() {
        return (com.atomgraph.linkeddatahub.apps.model.Application)this.getContainerRequestContext().getProperty(LAPP.Application.getURI());
    }
}

