/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.writer.function;

import com.atomgraph.linkeddatahub.writer.ModelXSLTWriter;
import java.io.IOException;
import javax.xml.transform.Source;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmValue;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class Construct
implements ExtensionFunction {
    private final Processor processor;

    public Construct(Processor processor) {
        this.processor = processor;
    }

    public QName getName() {
        return new QName("https://w3id.org/atomgraph/linkeddatahub#", "construct");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.DOCUMENT_NODE, (OccurrenceIndicator)OccurrenceIndicator.ONE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)new ItemTypeFactory(this.getProcessor()).getMapType(ItemType.ANY_URI, SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_MORE)), (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
        try {
            Model model = ModelFactory.createDefaultModel();
            if (!arguments[0].isEmpty()) {
                arguments[0].itemAt(0).asMap().forEach((forClass, constructors) -> {
                    Resource instance = model.createResource();
                    QuerySolutionMap qsm = new QuerySolutionMap();
                    qsm.add("this", (RDFNode)instance);
                    instance.addProperty(RDF.type, (RDFNode)ResourceFactory.createResource((String)forClass.getStringValue()));
                    constructors.stream().forEach(constructor -> {
                        try (QueryExecution qex = QueryExecution.model((Model)model).query(constructor.getStringValue()).initialBinding((QuerySolution)qsm).build();){
                            qex.execConstruct(model);
                        }
                    });
                });
            }
            return this.getProcessor().newDocumentBuilder().build((Source)ModelXSLTWriter.getSource((Model)model));
        }
        catch (IOException ex) {
            throw new SaxonApiException((Throwable)ex);
        }
    }

    public Processor getProcessor() {
        return this.processor;
    }
}

