/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.linkeddatahub.writer.impl;

import com.atomgraph.core.client.LinkedDataClient;
import com.atomgraph.linkeddatahub.server.security.AgentContext;
import java.net.URI;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.LocationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManagerImpl
extends com.atomgraph.client.util.DataManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(DataManagerImpl.class);
    private final URI rootContextURI;
    private final AgentContext agentContext;

    public DataManagerImpl(LocationMapper mapper, Map<String, Model> modelCache, LinkedDataClient ldc, boolean cacheModelLoads, boolean preemptiveAuth, boolean resolvingUncached, URI rootContextURI, AgentContext agentContext) {
        super(mapper, modelCache, ldc, cacheModelLoads, preemptiveAuth, resolvingUncached);
        this.rootContextURI = rootContextURI;
        this.agentContext = agentContext;
    }

    public boolean resolvingUncached(String filenameOrURI) {
        if (super.resolvingUncached(filenameOrURI) && !this.isMapped(filenameOrURI)) {
            boolean relative = !this.getRootContextURI().relativize(URI.create(filenameOrURI)).isAbsolute();
            return relative;
        }
        return false;
    }

    public URI getRootContextURI() {
        return this.rootContextURI;
    }

    public AgentContext getAgentContext() {
        return this.agentContext;
    }
}

