<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:a="https://w3id.org/atomgraph/core#" xmlns:ac="https://w3id.org/atomgraph/client#" xmlns:acl="http://www.w3.org/ns/auth/acl#" xmlns:bs2="http://graphity.org/xsl/bootstrap/2.3.2" xmlns:dh="https://www.w3.org/ns/ldt/document-hierarchy#" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:lacl="https://w3id.org/atomgraph/linkeddatahub/admin/acl#" xmlns:ldh="https://w3id.org/atomgraph/linkeddatahub#" xmlns:ldt="https://www.w3.org/ns/ldt#" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:sioc="http://rdfs.org/sioc/ns#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" exclude-result-prefixes="#all">

    <xsl:template match="*[@rdf:about = 'http://www.w3.org/ns/auth/acl#Authorization']" mode="ac:label">
        <xsl:apply-templates select="key('resources', 'authorization', document('../../../translations.rdf'))" mode="#current"/>
    </xsl:template>
    
    <xsl:template match="acl:mode/@rdf:resource | acl:mode/@rdf:nodeID" mode="bs2:FormControl" priority="1">
        <xsl:param name="type-label" select="true()" as="xs:boolean"/>
        <xsl:variable name="this" select="../concat(namespace-uri(), local-name())" as="xs:string"/>
        <xsl:variable name="properties" select="../../*[concat(namespace-uri(), local-name()) = $this]" as="element()*"/>

        <xsl:variable name="modes" select="key('resources-by-subclass', 'http://www.w3.org/ns/auth/acl#Access', document(ac:document-uri('http://www.w3.org/ns/auth/acl#')))" as="element()*"/>
        <select name="ou" id="{generate-id()}" multiple="multiple" size="{count($modes)}">
            <xsl:for-each select="$modes">
                <xsl:sort select="ac:label(.)" lang="{$ldt:lang}"/>
                <xsl:apply-templates select="." mode="xhtml:Option">
                    <xsl:with-param name="selected" select="@rdf:about = $properties/@rdf:resource"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </select>

        <xsl:if test="$type-label">
            <xsl:apply-templates select="." mode="bs2:FormControlTypeLabel"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="acl:mode[position() &gt; 1]" mode="bs2:FormControl" priority="2"/>

    <xsl:template match="*[lacl:requestAccessTo/@rdf:resource]" mode="bs2:Block" priority="1">
        <xsl:param name="method" select="'post'" as="xs:string"/>
        <xsl:param name="action" select="ac:build-uri($a:graphStore, map{ 'forClass': 'http://www.w3.org/ns/auth/acl#Authorization' })" as="xs:anyURI"/>
        <xsl:param name="id" select="concat('form-', generate-id())" as="xs:string?"/>
        <xsl:param name="class" select="'form-horizontal'" as="xs:string?"/>
        <xsl:param name="accept-charset" select="'UTF-8'" as="xs:string?"/>
        <xsl:param name="enctype" as="xs:string?"/> <!-- TO-DO: override with "multipart/form-data" for File instances -->

        <xsl:next-match/>
        
        <xsl:if test="lacl:requestMode/@rdf:resource = 'http://www.w3.org/ns/auth/acl#Control'">
            <div class="alert">
                <p>
                    <strong>Warning!</strong> By allowing <code>Control</code> access mode you are effectively granting full control of the dataspace.
                </p>
            </div>
        </xsl:if>
        
        <!-- .form-horizontal is required so that client.xsl can match this form and intercept its onsubmit event -->
        <form method="{$method}" action="{$action}">
            <xsl:if test="$id">
                <xsl:attribute name="id" select="$id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
            <xsl:if test="$accept-charset">
                <xsl:attribute name="accept-charset" select="$accept-charset"/>
            </xsl:if>
            <xsl:if test="$enctype">
                <xsl:attribute name="enctype" select="$enctype"/>
            </xsl:if>
            
            <xsl:comment>This form uses RDF/POST encoding: http://www.lsrn.org/semweb/rdfpost.html</xsl:comment>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'rdf'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>

            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'sb'"/>
                <xsl:with-param name="value" select="'auth'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ou'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/ns/auth/acl#Authorization'"/> <!-- Authorization class URI -->
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/2000/01/rdf-schema#label'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:variable name="label" select="string-join(lacl:requestMode/@rdf:resource/ac:label(key('resources', ., document(ac:document-uri('http://www.w3.org/ns/auth/acl#')))), ', ')" as="xs:string"/>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ol'"/>
                <xsl:with-param name="value" select="'Allowed ' || $label || ' access'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/ns/auth/acl#agent'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ou'"/>
                <xsl:with-param name="value" select="lacl:requestAgent/@rdf:resource"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:for-each select="lacl:requestAccessTo/@rdf:resource">
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'pu'"/>
                    <xsl:with-param name="value" select="'http://www.w3.org/ns/auth/acl#accessTo'"/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'ou'"/>
                    <xsl:with-param name="value" select="."/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="lacl:requestAccessToClass/@rdf:resource">
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'pu'"/>
                    <xsl:with-param name="value" select="'http://www.w3.org/ns/auth/acl#accessToClass'"/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'ou'"/>
                    <xsl:with-param name="value" select="."/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:for-each select="lacl:requestMode/@rdf:resource">
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'pu'"/>
                    <xsl:with-param name="value" select="'http://www.w3.org/ns/auth/acl#mode'"/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'ou'"/>
                    <xsl:with-param name="value" select="."/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>
            </xsl:for-each>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/ns/prov#wasDerivedFrom'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ou'"/>
                <xsl:with-param name="value" select="@rdf:about"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>

            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'sb'"/>
                <xsl:with-param name="value" select="'auth-item'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ou'"/>
                <xsl:with-param name="value" select="'https://www.w3.org/ns/ldt/document-hierarchy#Item'"/> <!-- Item class URI -->
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://rdfs.org/sioc/ns#has_container'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ou'"/>
                <xsl:with-param name="value" select="resolve-uri('acl/authorizations/', $ldt:base)"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://purl.org/dc/terms/title'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:variable name="label" select="string-join(lacl:requestMode/@rdf:resource/ac:label(key('resources', ., document(ac:document-uri('http://www.w3.org/ns/auth/acl#')))), ', ')" as="xs:string"/>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ol'"/>
                <xsl:with-param name="value" select="'Allowed ' || $label || ' access'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'pu'"/>
                <xsl:with-param name="value" select="'http://xmlns.com/foaf/0.1/primaryTopic'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'ob'"/>
                <xsl:with-param name="value" select="'auth'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Allow</button>
            </div>
        </form>
    </xsl:template>
    
</xsl:stylesheet>