<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:a="https://w3id.org/atomgraph/core#" xmlns:ac="https://w3id.org/atomgraph/client#" xmlns:acl="http://www.w3.org/ns/auth/acl#" xmlns:bs2="http://graphity.org/xsl/bootstrap/2.3.2" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:lapp="https://w3id.org/atomgraph/linkeddatahub/apps#" xmlns:ldh="https://w3id.org/atomgraph/linkeddatahub#" xmlns:ldt="https://www.w3.org/ns/ldt#" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:sioc="http://rdfs.org/sioc/ns#" xmlns:spin="http://spinrdf.org/spin#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" exclude-result-prefixes="#all">

    <xsl:import href="../layout.xsl"/>
    <xsl:include href="acl/layout.xsl"/>

    <xsl:param name="default-classes" as="map(xs:string, xs:anyURI)">
        <xsl:map>
            <xsl:map-entry key="'http://www.w3.org/2002/07/owl#Ontology'" select="resolve-uri('model/ontologies/', $ldt:base)"/>
            <xsl:map-entry key="'http://www.w3.org/ns/auth/acl#Authorization'" select="resolve-uri('acl/authorizations/', $ldt:base)"/>
            <xsl:map-entry key="'http://xmlns.com/foaf/0.1/Person'" select="resolve-uri('acl/agents/', $ldt:base)"/>
            <xsl:map-entry key="'http://www.w3.org/ns/auth/cert#PublicKey'" select="resolve-uri('acl/public-keys/', $ldt:base)"/>
            <xsl:map-entry key="'http://rdfs.org/sioc/ns#UserAccount'" select="resolve-uri('acl/users/', $ldt:base)"/>
            <xsl:map-entry key="'http://xmlns.com/foaf/0.1/Group'" select="resolve-uri('acl/groups/', $ldt:base)"/>
        </xsl:map>
    </xsl:param>
    
    <xsl:template match="rdf:RDF[$foaf:Agent]" mode="bs2:Create" priority="1">
        <xsl:param name="classes" as="element()*"/>
        <xsl:param name="create-graph" select="false()" as="xs:boolean"/>

        <div class="btn-group pull-left">
            <button type="button" title="{ac:label(key('resources', 'create-instance-title', document('../translations.rdf')))}">
                <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/client#ConstructMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))" mode="ldh:logo">
                    <xsl:with-param name="class" select="'btn btn-primary dropdown-toggle'"/>
                </xsl:apply-templates>
                <xsl:value-of>
                    <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/client#ConstructMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))" mode="ac:label"/>
                </xsl:value-of>
                <xsl:text> </xsl:text>
                <span class="caret"/>
            </button>

            <ul class="dropdown-menu">
                <xsl:apply-templates select="$classes" mode="bs2:ConstructorListItem">
                    <xsl:with-param name="create-graph" select="$create-graph"/>
                    <xsl:sort select="ac:label(.)"/>
                </xsl:apply-templates>
            </ul>
        </div>
    </xsl:template>
    
    <!-- ADD DATA -->
    
    <xsl:template match="rdf:RDF[$acl:mode = 'http://www.w3.org/ns/auth/acl#Append']" mode="bs2:AddData" priority="1">
        <div class="btn-group pull-left">
            <button type="button" class="btn btn-primary dropdown-toggle" title="{ac:label(key('resources', 'add', document('../translations.rdf')))}">
                <xsl:value-of>
                    <xsl:apply-templates select="key('resources', 'add', document('../translations.rdf'))" mode="ac:label"/>
                </xsl:value-of>
                <xsl:text> </xsl:text>
                <span class="caret"/>
            </button>
            
            <ul class="dropdown-menu">
                <li>
                    <button type="button" title="{ac:label(key('resources', 'add-data-title', document('../translations.rdf')))}" class="btn btn-add-data">
                        <xsl:value-of>
                            <xsl:apply-templates select="key('resources', 'add-data', document('../translations.rdf'))" mode="ac:label"/>
                        </xsl:value-of>
                    </button>
                </li>
                <li>
                    <button type="button" title="{ac:label(key('resources', 'import-ontology-title', document('../translations.rdf')))}" class="btn btn-add-ontology">
                        <xsl:value-of>
                            <xsl:apply-templates select="key('resources', 'import-ontology', document('../translations.rdf'))" mode="ac:label"/>
                        </xsl:value-of>
                    </button>
                </li>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="*" mode="bs2:AddData"/>
    
    <!-- ROW FORM - we need the overriding templates as well -->

    <xsl:template match="rdf:RDF[$ac:forClass = ('https://w3id.org/atomgraph/linkeddatahub#CSVImport', 'https://w3id.org/atomgraph/linkeddatahub#RDFImport')][$ac:method = 'GET']" mode="bs2:RowForm" priority="2" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ac:build-uri(resolve-uri('importer', $ldt:base), map{ 'forClass': string($ac:forClass), 'mode': 'https://w3id.org/atomgraph/client#EditMode' })" as="xs:anyURI"/>
        <xsl:param name="classes" as="element()*"/>

        <xsl:next-match>
            <xsl:with-param name="action" select="$action"/>
            <xsl:with-param name="classes" select="$classes"/>
        </xsl:next-match>
    </xsl:template>
    
    <xsl:template match="rdf:RDF[$ac:forClass][$ac:method = 'GET']" mode="bs2:RowForm" priority="1" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ac:build-uri($a:graphStore, map{ 'forClass': string($ac:forClass), 'mode': 'https://w3id.org/atomgraph/client#EditMode' })" as="xs:anyURI"/>
        <xsl:param name="classes" as="element()*"/>

        <xsl:next-match>
            <xsl:with-param name="action" select="$action"/>
            <xsl:with-param name="classes" select="$classes"/>
        </xsl:next-match>
    </xsl:template>
    
    <!-- add sp:Construct to the creatable class list below the form. Needs to pass parameters from signup.xsl and request-access.xsl!!! -->
    <xsl:template match="rdf:RDF[$ac:method = 'GET']" mode="bs2:RowForm" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ldh:href($ldt:base, ldh:absolute-path(ldh:href()), map{}, ac:build-uri(ac:uri(), map{ '_method': 'PUT', 'mode': for $mode in $ac:mode return string($mode) }))" as="xs:anyURI"/>
        <xsl:param name="enctype" select="'multipart/form-data'" as="xs:string?"/>
        <xsl:param name="create-resource" select="true()" as="xs:boolean"/>
        <!-- TO-DO: generate ontology classes from the OWL vocabulary -->
        <xsl:param name="ontology-classes" select="for $class-uri in ('https://w3id.org/atomgraph/linkeddatahub#Constructor', 'http://www.w3.org/2002/07/owl#Class', 'http://www.w3.org/2002/07/owl#DatatypeProperty', 'http://www.w3.org/2002/07/owl#ObjectProperty', 'http://www.w3.org/2002/07/owl#Restriction') return key('resources', $class-uri, document(ac:document-uri($class-uri)))" as="element()*"/>

        <xsl:next-match>
            <xsl:with-param name="classes" select="$ontology-classes"/>
            <xsl:with-param name="action" select="$action"/>
            <xsl:with-param name="enctype" select="$enctype"/>
            <xsl:with-param name="create-resource" select="$create-resource"/>
        </xsl:next-match>
    </xsl:template>
    
    <!-- allow subject editing in admin EditMode -->
    <xsl:template match="*[*][@rdf:about or @rdf:nodeID]" mode="bs2:FormControl">
        <xsl:apply-imports>
            <xsl:with-param name="show-subject" select="not(rdf:type/@rdf:resource = ('https://www.w3.org/ns/ldt/document-hierarchy#Item', 'https://www.w3.org/ns/ldt/document-hierarchy#Container'))" tunnel="yes"/>
        </xsl:apply-imports>
    </xsl:template>
    
    <!-- show "Clear" button for ontologies -->
    <xsl:template match="*[rdf:type/@rdf:resource = 'http://www.w3.org/2002/07/owl#Ontology'][$foaf:Agent//@rdf:about]" mode="bs2:Actions">
        <form class="pull-right" action="{resolve-uri('clear', $ldt:base)}" method="post">
            <input type="hidden" name="uri" value="{@rdf:about}"/>
            
            <button class="btn btn-primary" type="submit">
                <xsl:value-of>
                    <xsl:apply-templates select="key('resources', 'clear', document('../translations.rdf'))" mode="ac:label"/>
                </xsl:value-of>
            </button>
        </form>

        <xsl:next-match/>
    </xsl:template>
    
</xsl:stylesheet>