<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:a="https://w3id.org/atomgraph/core#" xmlns:ac="https://w3id.org/atomgraph/client#" xmlns:acl="http://www.w3.org/ns/auth/acl#" xmlns:bs2="http://graphity.org/xsl/bootstrap/2.3.2" xmlns:dct="http://purl.org/dc/terms/" xmlns:dh="https://www.w3.org/ns/ldt/document-hierarchy#" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:geo="http://www.w3.org/2003/01/geo/wgs84_pos#" xmlns:http="http://www.w3.org/2011/http#" xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT" xmlns:ldh="https://w3id.org/atomgraph/linkeddatahub#" xmlns:ldt="https://www.w3.org/ns/ldt#" xmlns:map="http://www.w3.org/2005/xpath-functions/map" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:sioc="http://rdfs.org/sioc/ns#" xmlns:sp="http://spinrdf.org/sp#" xmlns:spin="http://spinrdf.org/spin#" xmlns:srx="http://www.w3.org/2005/sparql-results#" xmlns:void="http://rdfs.org/ns/void#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0" exclude-result-prefixes="#all" extension-element-prefixes="ixsl">
    
    <xsl:param name="main-doc" select="/" as="document-node()"/>
    <xsl:param name="acl:Agent" as="document-node()?"/>
    <xsl:param name="acl:mode" select="$foaf:Agent//*[acl:accessToClass/@rdf:resource = (key('resources', ac:uri(), $main-doc)/rdf:type/@rdf:resource, key('resources', ac:uri(), $main-doc)/rdf:type/@rdf:resource/ldh:listSuperClasses(.))]/acl:mode/@rdf:resource" as="xs:anyURI*"/>

    <!-- BODY -->
    
    <!-- always show errors (except ConstraintViolations) in block mode -->
    <xsl:template match="rdf:RDF[not(key('resources', ac:uri()))][key('resources-by-type', 'http://www.w3.org/2011/http#Response')][not(key('resources-by-type', 'http://spinrdf.org/spin#ConstraintViolation'))]" mode="xhtml:Body" priority="1">
        <xsl:param name="id" as="xs:string?"/>
        <xsl:param name="class" select="'span12'" as="xs:string?"/>
        
        <div>
            <xsl:if test="$id">
                <xsl:attribute name="id" select="$id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
        
            <xsl:apply-templates mode="bs2:Block"/>
        </div>
    </xsl:template>
    
    <!-- MODE TABS -->
    
    <xsl:template match="rdf:RDF" mode="bs2:ModeTabs">
        <xsl:param name="has-content" as="xs:boolean"/>
        <xsl:param name="active-mode" as="xs:anyURI?"/>
        <xsl:param name="forClass" as="xs:anyURI?"/>
        <xsl:param name="ajax-rendering" select="true()" as="xs:boolean"/>

        <div class="row-fluid">
            <ul class="nav nav-tabs offset2 span7">
                <li class="content-mode{if ((empty($active-mode) and $has-content and not($forClass)) or $active-mode = 'https://w3id.org/atomgraph/linkeddatahub#ContentMode') then ' active' else() }">
                    <a href="{ldh:href($ldt:base, ldh:absolute-path(ldh:href()), ldh:query-params(xs:anyURI('https://w3id.org/atomgraph/linkeddatahub#ContentMode')), ac:uri())}">
                        <xsl:value-of>
                            <xsl:apply-templates select="key('resources', 'content', document('translations.rdf'))" mode="ac:label"/>
                        </xsl:value-of>
                    </a>
                </li>

                <xsl:for-each select="key('resources', 'https://w3id.org/atomgraph/client#ReadMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))">
                    <xsl:apply-templates select="." mode="bs2:ModeTabsItem">
                        <xsl:with-param name="active" select="@rdf:about = $active-mode or (empty($active-mode) and not($has-content))"/>
                    </xsl:apply-templates>
                </xsl:for-each>
                <xsl:for-each select="key('resources', 'https://w3id.org/atomgraph/client#MapMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))">
                    <xsl:apply-templates select="." mode="bs2:ModeTabsItem">
                        <xsl:with-param name="active" select="@rdf:about = $active-mode"/>
                    </xsl:apply-templates>
                </xsl:for-each>
                <xsl:if test="$ajax-rendering">
                    <xsl:for-each select="key('resources', 'https://w3id.org/atomgraph/client#ChartMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))">
                        <xsl:apply-templates select="." mode="bs2:ModeTabsItem">
                            <xsl:with-param name="active" select="@rdf:about = $active-mode"/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </xsl:if>
                <xsl:for-each select="key('resources', 'https://w3id.org/atomgraph/client#GraphMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))">
                    <xsl:apply-templates select="." mode="bs2:ModeTabsItem">
                        <xsl:with-param name="active" select="@rdf:about = $active-mode"/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </ul>
        </div>
    </xsl:template>
    
    <!-- CONTENT LIST -->
    
    <xsl:template match="rdf:RDF" mode="ldh:ContentList">
        <xsl:apply-templates select="key('resources', ac:uri())" mode="#current"/>
        
        <!-- only show buttons to agents who have sufficient access to modify them -->
        <xsl:if test="$acl:mode = 'http://www.w3.org/ns/auth/acl#Append'">
            <div class="row-fluid">
                <div class="offset2 span7">
                    <p>
                        <button type="button" class="btn btn-primary create-action add-resource-content">
                            <xsl:apply-templates select="key('resources', 'resource', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                        </button>
                        <button type="button" class="btn btn-primary create-action add-xhtml-content">
                            <xsl:apply-templates select="key('resources', 'html', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                        </button>
                    </p>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- ROW BLOCK -->
    
    <xsl:template match="rdf:RDF" mode="bs2:Row">
        <!-- select elements explicitly, because Saxon-JS chokes on text nodes here -->
        <!-- hide the current document resource and the content resources -->
        <xsl:apply-templates select="*[not(@rdf:about = ac:uri() and rdf:type/@rdf:resource = ('https://w3id.org/atomgraph/linkeddatahub/default#Root', 'https://www.w3.org/ns/ldt/document-hierarchy#Container', 'https://www.w3.org/ns/ldt/document-hierarchy#Item')) and not(rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub#Content')]" mode="#current">
            <xsl:sort select="ac:label(.)"/>
        </xsl:apply-templates>
    </xsl:template>

    <!-- MAP -->
    
    <xsl:template match="rdf:RDF" mode="bs2:Map">
        <xsl:param name="canvas-id" as="xs:string"/>
        <xsl:param name="class" select="'map-canvas'" as="xs:string?"/>

        <div>
            <xsl:if test="$canvas-id">
                <xsl:attribute name="id" select="$canvas-id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
        </div>
    </xsl:template>
        
    <!-- CHART -->

    <!-- graph chart (for RDF/XML results) -->

    <xsl:template match="rdf:RDF" mode="bs2:Chart">
        <xsl:param name="canvas-id" as="xs:string"/>
        <xsl:param name="class" select="'chart-canvas'" as="xs:string?"/>
        <xsl:param name="chart-type" select="xs:anyURI('https://w3id.org/atomgraph/client#Table')" as="xs:anyURI?"/>
        <xsl:param name="category" as="xs:string?"/>
        <xsl:param name="series" select="distinct-values(*/*/concat(namespace-uri(), local-name()))" as="xs:string*"/>
        <xsl:param name="show-save" select="true()" as="xs:boolean"/>

        <xsl:apply-templates select="." mode="bs2:ChartForm">
            <xsl:with-param name="chart-type" select="$chart-type"/>
            <xsl:with-param name="category" select="$category"/>
            <xsl:with-param name="series" select="$series"/>
            <xsl:with-param name="show-save" select="$show-save"/>
        </xsl:apply-templates>

        <div>
            <xsl:if test="$canvas-id">
                <xsl:attribute name="id" select="$canvas-id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="rdf:RDF" mode="bs2:ChartForm" priority="-1">
        <xsl:param name="method" select="'post'" as="xs:string"/>
        <xsl:param name="doc-type" select="xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item')" as="xs:anyURI"/>
        <xsl:param name="type" select="xs:anyURI('https://w3id.org/atomgraph/linkeddatahub#GraphChart')" as="xs:anyURI"/>
        <xsl:param name="action" select="ac:build-uri(resolve-uri('charts/', $ldt:base), map{ 'forClass': string($type) })" as="xs:anyURI"/>
        <xsl:param name="id" as="xs:string?"/>
        <xsl:param name="class" select="'form-inline'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn'" as="xs:string?"/>
        <xsl:param name="accept-charset" select="'UTF-8'" as="xs:string?"/>
        <xsl:param name="enctype" as="xs:string?"/>
        <xsl:param name="chart-type" select="xs:anyURI('https://w3id.org/atomgraph/client#Table')" as="xs:anyURI?"/> <!-- table is the default chart type -->
        <xsl:param name="category" as="xs:string?"/>
        <xsl:param name="series" as="xs:string*"/>
        <xsl:param name="chart-type-id" select="'chart-type'" as="xs:string"/>
        <xsl:param name="category-id" select="'category'" as="xs:string"/>
        <xsl:param name="series-id" select="'series'" as="xs:string"/>
        <xsl:param name="width" as="xs:string?"/>
        <xsl:param name="height" select="'480'" as="xs:string?"/>
        <xsl:param name="uri" as="xs:anyURI?"/>
        <xsl:param name="query" as="xs:string?"/>
        <xsl:param name="show-controls" select="true()" as="xs:boolean"/>
        <xsl:param name="show-save" select="true()" as="xs:boolean"/>

        <xsl:if test="$show-controls">
            <form method="{$method}" action="{$action}">
                <xsl:if test="$id">
                    <xsl:attribute name="id" select="$id"/>
                </xsl:if>
                <xsl:if test="$class">
                    <xsl:attribute name="class" select="$class"/>
                </xsl:if>
                <xsl:if test="$accept-charset">
                    <xsl:attribute name="accept-charset" select="$accept-charset"/>
                </xsl:if>
                <xsl:if test="$enctype">
                    <xsl:attribute name="enctype" select="$enctype"/>
                </xsl:if>

                <fieldset>
                    <div class="row-fluid">
                        <div class="span4">
                            <label for="{$chart-type-id}">
                                <xsl:value-of>
                                    <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/linkeddatahub#chartType', document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub#')))" mode="ac:label"/>
                                </xsl:value-of>
                            </label>
                            <br/>
                            <!-- TO-DO: replace with xsl:apply-templates on ac:Chart subclasses as in imports/ldh.xsl -->
                            <select id="{$chart-type-id}" name="ou" class="input-medium chart-type">
                                <option value="https://w3id.org/atomgraph/client#Table">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#Table'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Table</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#ScatterChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#ScatterChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Scatter chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#LineChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#LineChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Line chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#BarChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#BarChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Bar chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#Timeline">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#Timeline'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Timeline</xsl:text>
                                </option>
                            </select>
                        </div>
                        <div class="span4">
                            <label for="{$category-id}">Category</label>
                            <br/>
                            <select id="{$category-id}" name="ou" class="input-large chart-category">
                                <option value="">
                                    <!-- URI is the default category -->
                                    <xsl:if test="not($category)">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>[URI/ID]</xsl:text>
                                </option>

                                <xsl:for-each-group select="*/*" group-by="concat(namespace-uri(), local-name())">
                                    <xsl:sort select="ac:property-label(.)" order="ascending" lang="{$ldt:lang}" use-when="system-property('xsl:product-name') = 'SAXON'"/>
                                    <xsl:sort select="ac:property-label(.)" order="ascending" use-when="system-property('xsl:product-name') eq 'SaxonJS'"/>

                                    <option value="{current-grouping-key()}">
                                        <xsl:if test="$category = current-grouping-key()">
                                            <xsl:attribute name="selected" select="'selected'"/>
                                        </xsl:if>

                                        <xsl:value-of>
                                            <xsl:apply-templates select="current-group()[1]" mode="ac:property-label"/>
                                        </xsl:value-of>
                                    </option>
                                </xsl:for-each-group>
                            </select>
                        </div>
                        <div class="span4">
                            <label for="{$series-id}">Series</label>
                            <br/>
                            <select id="{$series-id}" name="ou" multiple="multiple" class="input-large chart-series">
                                <xsl:for-each-group select="*/*" group-by="concat(namespace-uri(), local-name())">
                                    <xsl:sort select="ac:property-label(.)" order="ascending" lang="{$ldt:lang}" use-when="system-property('xsl:product-name') = 'SAXON'"/>
                                    <xsl:sort select="ac:property-label(.)" order="ascending" use-when="system-property('xsl:product-name') eq 'SaxonJS'"/>

                                    <option value="{current-grouping-key()}">
                                        <xsl:if test="$series = current-grouping-key()">
                                            <xsl:attribute name="selected" select="'selected'"/>
                                        </xsl:if>

                                        <xsl:value-of>
                                            <xsl:apply-templates select="current-group()[1]" mode="ac:property-label"/>
                                        </xsl:value-of>
                                    </option>
                                </xsl:for-each-group>
                            </select>
                        </div>
                    </div>
                </fieldset>

                <xsl:if test="$show-save">
                    <div class="form-actions">
                        <button class="btn btn-primary btn-save-chart" type="button">
                            <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                                <xsl:with-param name="class" select="'btn btn-primary btn-save-chart'"/>
                            </xsl:apply-templates>
                            
                            <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                        </button>
                    </div>
                </xsl:if>
            </form>
        </xsl:if>
    </xsl:template>

    <!-- table chart (for SPARQL XML results) -->

    <xsl:template match="srx:sparql" mode="bs2:Chart">
        <xsl:param name="canvas-id" as="xs:string"/>
        <xsl:param name="class" select="'chart-canvas'" as="xs:string?"/>
        <xsl:param name="chart-type" select="xs:anyURI('https://w3id.org/atomgraph/client#Table')" as="xs:anyURI?"/>
        <xsl:param name="category" select="srx:head/srx:variable[1]/@name" as="xs:string?"/>
        <xsl:param name="series" select="srx:head/srx:variable/@name" as="xs:string*"/>
        <xsl:param name="show-save" select="true()" as="xs:boolean"/>

        <xsl:apply-templates select="." mode="bs2:ChartForm">
            <xsl:with-param name="chart-type" select="$chart-type"/>
            <xsl:with-param name="category" select="$category"/>
            <xsl:with-param name="series" select="$series"/>
            <xsl:with-param name="show-save" select="$show-save"/>
        </xsl:apply-templates>

        <div>
            <xsl:if test="$canvas-id">
                <xsl:attribute name="id" select="$canvas-id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="srx:sparql" mode="bs2:ChartForm">
        <xsl:param name="method" select="'post'" as="xs:string"/>
        <xsl:param name="doc-type" select="xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item')" as="xs:anyURI"/>
        <xsl:param name="type" select="xs:anyURI('https://w3id.org/atomgraph/linkeddatahub#ResultSetChart')" as="xs:anyURI"/>
        <xsl:param name="action" select="ac:build-uri(resolve-uri('charts/', $ldt:base), map{ 'forClass': string($type) })" as="xs:anyURI"/>
        <xsl:param name="id" as="xs:string?"/>
        <xsl:param name="class" select="'form-inline'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn'" as="xs:string?"/>
        <xsl:param name="accept-charset" select="'UTF-8'" as="xs:string?"/>
        <xsl:param name="enctype" as="xs:string?"/>
        <xsl:param name="chart-type" select="xs:anyURI('https://w3id.org/atomgraph/client#Table')" as="xs:anyURI?"/> <!-- table is the default chart type -->
        <xsl:param name="category" as="xs:string?"/>
        <xsl:param name="series" as="xs:string*"/>
        <xsl:param name="chart-type-id" select="'chart-type'" as="xs:string"/>
        <xsl:param name="category-id" select="'category'" as="xs:string"/>
        <xsl:param name="series-id" select="'series'" as="xs:string"/>
        <xsl:param name="width" as="xs:string?"/>
        <xsl:param name="height" select="'480'" as="xs:string?"/>
        <xsl:param name="uri" as="xs:anyURI?"/>
        <xsl:param name="query" as="xs:string?"/>
        <xsl:param name="show-controls" select="true()" as="xs:boolean"/>
        <xsl:param name="show-save" select="true()" as="xs:boolean"/>

        <xsl:if test="$show-controls">
            <form method="{$method}" action="{$action}">
                <xsl:if test="$id">
                    <xsl:attribute name="id" select="$id"/>
                </xsl:if>
                <xsl:if test="$class">
                    <xsl:attribute name="class" select="$class"/>
                </xsl:if>
                <xsl:if test="$accept-charset">
                    <xsl:attribute name="accept-charset" select="$accept-charset"/>
                </xsl:if>
                <xsl:if test="$enctype">
                    <xsl:attribute name="enctype" select="$enctype"/>
                </xsl:if>

                <fieldset>
                    <div class="row-fluid">
                        <div class="span4">
                            <label for="{$chart-type-id}">
                                <xsl:value-of>
                                    <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/linkeddatahub#chartType', document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub#')))" mode="ac:label"/>
                                </xsl:value-of>
                            </label>
                            <br/>
                            <select id="{$chart-type-id}" name="ou" class="input-medium chart-type">
                                <option value="https://w3id.org/atomgraph/client#Table">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#Table'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Table</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#ScatterChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#ScatterChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Scatter chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#LineChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#LineChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Line chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#BarChart">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#BarChart'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Bar chart</xsl:text>
                                </option>
                                <option value="https://w3id.org/atomgraph/client#Timeline">
                                    <xsl:if test="$chart-type = 'https://w3id.org/atomgraph/client#Timeline'">
                                        <xsl:attribute name="selected" select="'selected'"/>
                                    </xsl:if>

                                    <xsl:text>Timeline</xsl:text>
                                </option>
                            </select>
                        </div>
                        <div class="span4">
                            <xsl:call-template name="xhtml:Input">
                                <xsl:with-param name="name" select="'pu'"/>
                                <xsl:with-param name="type" select="'hidden'"/>
                                <xsl:with-param name="value" select="'https://w3id.org/atomgraph/linkeddatahub#categoryVarName'"/>
                            </xsl:call-template>

                            <label for="{$category-id}">Category</label>
                            <br/>
                            <select id="{$category-id}" name="ol" class="input-large chart-category">
                                <xsl:for-each select="srx:head/srx:variable">
                                    <!-- leave the original variable order so it can be controlled from query -->

                                    <option value="{@name}">
                                        <xsl:if test="$category = @name">
                                            <xsl:attribute name="selected" select="'selected'"/>
                                        </xsl:if>

                                        <xsl:value-of select="@name"/>
                                    </option>
                                </xsl:for-each>
                            </select>
                        </div>
                        <div class="span4">
                            <label for="{$series-id}">Series</label>
                            <br/>
                            <select id="{$series-id}" name="ol" multiple="multiple" class="input-large chart-series">
                                <xsl:for-each select="srx:head/srx:variable">
                                    <!-- leave the original variable order so it can be controlled from query -->

                                    <option value="{@name}">
                                        <xsl:if test="$series = @name">
                                            <xsl:attribute name="selected" select="'selected'"/>
                                        </xsl:if>

                                        <xsl:value-of select="@name"/>
                                    </option>
                                </xsl:for-each>
                            </select>
                        </div>
                    </div>
                </fieldset>
                
                <xsl:if test="$show-save">
                    <div class="form-actions">
                        <button class="btn btn-primary btn-save-chart" type="button">
                            <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                                <xsl:with-param name="class" select="'btn btn-primary btn-save-chart'"/>
                            </xsl:apply-templates>
                            
                            <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                        </button>
                    </div>
                </xsl:if>
            </form>
        </xsl:if>
    </xsl:template>

    <!-- CONSTRUCTOR -->
    
    <xsl:template match="rdf:RDF" mode="ldh:Constructor" as="document-node()">
        <xsl:param name="forClass" as="xs:anyURI"/>
        <xsl:param name="createGraph" as="xs:boolean"/>
        <xsl:param name="constructor-query" as="xs:string?"/>
        
        <xsl:choose>
            <!-- if $forClass is not a document class or content, then pair the instance with a document instance -->
            <xsl:when test="$createGraph and not($forClass = ('https://www.w3.org/ns/ldt/document-hierarchy#Container', 'https://www.w3.org/ns/ldt/document-hierarchy#Item', 'https://w3id.org/atomgraph/linkeddatahub#Content'))">
                <xsl:document>
                    <!-- construct a combined graph of dh:Item and $forClass instances -->
                    <xsl:for-each select="ldh:construct(map{ xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item'): spin:constructors(xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item'), resolve-uri('ns', $ldt:base), $constructor-query)//srx:binding[@name = 'construct']/srx:literal/string(),                             $forClass: spin:constructors($forClass, resolve-uri('ns', $ldt:base), $constructor-query)//srx:binding[@name = 'construct']/srx:literal/string() })">
                        <xsl:apply-templates select="." mode="ldh:SetPrimaryTopic">
                            <!-- avoid selecting object blank nodes which only have rdf:type --> 
                            <xsl:with-param name="topic-id" select="key('resources-by-type', $forClass)[* except rdf:type]/@rdf:nodeID" tunnel="yes"/>
                            <xsl:with-param name="doc-id" select="key('resources-by-type', 'https://www.w3.org/ns/ldt/document-hierarchy#Item')/@rdf:nodeID" tunnel="yes"/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </xsl:document>
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="ldh:construct(map{ $forClass: spin:constructors($forClass, resolve-uri('ns', $ldt:base), $constructor-query)//srx:binding[@name = 'construct']/srx:literal/string() })"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- MODAL FORM -->

    <xsl:template match="rdf:RDF[$ac:forClass][$ac:method = 'GET']" mode="bs2:ModalForm" priority="1" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ac:build-uri($a:graphStore, map{ 'forClass': string($ac:forClass), 'mode': ('https://w3id.org/atomgraph/client#EditMode', 'https://w3id.org/atomgraph/client#ModalMode') })" as="xs:anyURI"/>

        <xsl:next-match>
            <xsl:with-param name="action" select="$action"/>
        </xsl:next-match>
    </xsl:template>
    
    <xsl:template match="rdf:RDF" mode="bs2:ModalForm" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="method" select="'post'" as="xs:string"/>
        <xsl:param name="action" select="ac:build-uri($a:graphStore, map{ 'forClass': string($ac:forClass), 'mode': 'https://w3id.org/atomgraph/client#ModalMode' })" as="xs:anyURI"/>
        <xsl:param name="id" select="concat('form-', generate-id())" as="xs:string?"/>
        <xsl:param name="class" select="'form-horizontal'" as="xs:string?"/>
        <xsl:param name="accept-charset" select="'UTF-8'" as="xs:string?"/>
        <xsl:param name="enctype" select="'multipart/form-data'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn btn-primary wymupdate'" as="xs:string?"/>

        <div class="modal modal-constructor fade in">
            <form method="{$method}" action="{$action}">
                <xsl:if test="$id">
                    <xsl:attribute name="id" select="$id"/>
                </xsl:if>
                <xsl:if test="$class">
                    <xsl:attribute name="class" select="$class"/>
                </xsl:if>
                <xsl:if test="$accept-charset">
                    <xsl:attribute name="accept-charset" select="$accept-charset"/>
                </xsl:if>
                <xsl:if test="$enctype">
                    <xsl:attribute name="enctype" select="$enctype"/>
                </xsl:if>

                <xsl:comment>This form uses RDF/POST encoding: http://www.lsrn.org/semweb/rdfpost.html</xsl:comment>
                <xsl:call-template name="xhtml:Input">
                    <xsl:with-param name="name" select="'rdf'"/>
                    <xsl:with-param name="type" select="'hidden'"/>
                </xsl:call-template>

                <input type="hidden" class="target-id"/>

                <div class="modal-header">
                    <button type="button" class="close">×</button>

                    <!--<xsl:apply-templates select="." mode="bs2:Legend"/>-->
                </div>

                <div class="modal-body">
                    <xsl:apply-templates mode="bs2:Exception"/>

                    <xsl:apply-templates select="*" mode="#current">
                        <xsl:sort select="ac:label(.)"/>
                        <xsl:with-param name="inline" select="false()" tunnel="yes"/>
                    </xsl:apply-templates>
                </div>

                <xsl:apply-templates select="." mode="bs2:ModalFormActions">
                    <xsl:with-param name="button-class" select="$button-class"/>
                </xsl:apply-templates>
            </form>
        </div>
    </xsl:template>
    
    <!-- ROW FORM -->

    <xsl:template match="rdf:RDF[$ac:forClass = ('https://w3id.org/atomgraph/linkeddatahub#CSVImport', 'https://w3id.org/atomgraph/linkeddatahub#RDFImport')][$ac:method = 'GET']" mode="bs2:RowForm" priority="2" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ac:build-uri(resolve-uri('importer', $ldt:base), map{ 'forClass': string($ac:forClass), 'mode': 'https://w3id.org/atomgraph/client#EditMode' })" as="xs:anyURI"/>
        <xsl:param name="classes" as="element()*"/>

        <xsl:next-match>
            <xsl:with-param name="action" select="$action"/>
            <xsl:with-param name="classes" select="$classes"/>
        </xsl:next-match>
    </xsl:template>
    
    <xsl:template match="rdf:RDF[$ac:forClass][$ac:method = 'GET']" mode="bs2:RowForm" priority="1" use-when="system-property('xsl:product-name') = 'SAXON'">
        <xsl:param name="action" select="ac:build-uri($a:graphStore, map{ 'forClass': string($ac:forClass), 'mode': 'https://w3id.org/atomgraph/client#EditMode' })" as="xs:anyURI"/>
        <xsl:param name="classes" as="element()*"/>

        <xsl:next-match>
            <xsl:with-param name="action" select="$action"/>
            <xsl:with-param name="classes" select="$classes"/>
        </xsl:next-match>
    </xsl:template>
    
    <xsl:template match="rdf:RDF" mode="bs2:RowForm">
        <xsl:param name="method" select="'post'" as="xs:string"/>
        <xsl:param name="action" select="ldh:href($ldt:base, ldh:absolute-path(ldh:href()), map{}, ac:build-uri(ac:uri(), map{ '_method': 'PUT', 'mode': for $mode in $ac:mode return string($mode) }))" as="xs:anyURI"/>
        <xsl:param name="id" select="concat('form-', generate-id())" as="xs:string?"/>
        <xsl:param name="class" select="'form-horizontal'" as="xs:string?"/>
        <xsl:param name="accept-charset" select="'UTF-8'" as="xs:string?"/>
        <xsl:param name="enctype" select="'multipart/form-data'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn btn-primary wymupdate'" as="xs:string?"/>
        <xsl:param name="create-resource" select="true()" as="xs:boolean"/>
        <xsl:param name="classes" as="element()*"/>

        <form method="{$method}" action="{$action}">
            <xsl:if test="$id">
                <xsl:attribute name="id" select="$id"/>
            </xsl:if>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
            <xsl:if test="$accept-charset">
                <xsl:attribute name="accept-charset" select="$accept-charset"/>
            </xsl:if>
            <xsl:if test="$enctype">
                <xsl:attribute name="enctype" select="$enctype"/>
            </xsl:if>

            <xsl:comment>This form uses RDF/POST encoding: http://www.lsrn.org/semweb/rdfpost.html</xsl:comment>
            <xsl:call-template name="xhtml:Input">
                <xsl:with-param name="name" select="'rdf'"/>
                <xsl:with-param name="type" select="'hidden'"/>
            </xsl:call-template>

            <input type="hidden" class="target-id"/>

            <xsl:apply-templates mode="bs2:Exception"/>

            <!-- show the current document on the top -->
            <xsl:apply-templates select="*[@rdf:about = ac:uri()]" mode="#current">
                <xsl:with-param name="inline" select="false()" tunnel="yes"/>
            </xsl:apply-templates>
            <!-- show the rest of the resources (contents, instances) below it -->
            <xsl:apply-templates select="*[not(@rdf:about = ac:uri())]" mode="#current">
                <xsl:sort select="ac:label(.)"/>
                <xsl:with-param name="inline" select="false()" tunnel="yes"/>
            </xsl:apply-templates>

            <xsl:if test="$create-resource">
                <div class="create-resource row-fluid">
                    <div class="offset2 span7">
                        <xsl:apply-templates select="." mode="bs2:Create">
                            <xsl:with-param name="classes" select="$classes"/>
                            <xsl:with-param name="show-document-classes" select="false()"/>
                        </xsl:apply-templates>
                        
                        <!-- separate "Create" button only for Content -->
                        <a href="{ac:build-uri(ac:uri(), map{ 'forClass': 'https://w3id.org/atomgraph/linkeddatahub#Content' })}" class="btn btn-primary add-constructor create-action">
                            <xsl:value-of>
                                <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/linkeddatahub#Content', document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub#')))" mode="ac:label"/>
                            </xsl:value-of>
                            <input type="hidden" class="forClass" value="https://w3id.org/atomgraph/linkeddatahub#Content"/>
                        </a>
                    </div>
                </div>
            </xsl:if>

            <xsl:apply-templates select="." mode="bs2:FormActions">
                <xsl:with-param name="button-class" select="$button-class"/>
            </xsl:apply-templates>
        </form>
    </xsl:template>

    <!-- MODAL FORM ACTIONS -->
    
    <xsl:template match="rdf:RDF" mode="bs2:ModalFormActions">
        <xsl:param name="class" select="'form-actions modal-footer'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn btn-primary'" as="xs:string?"/>
        
        <div>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
            
            <button type="submit" class="{$button-class}">
                <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                    <xsl:with-param name="class" select="$button-class"/>
                </xsl:apply-templates>
                
                <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
            </button>

            <button type="button" class="btn">
                <xsl:apply-templates select="key('resources', 'close', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                    <xsl:with-param name="class" select="'btn'"/>
                </xsl:apply-templates>
                
                <xsl:apply-templates select="key('resources', 'close', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
            </button>

            <button type="reset" class="btn">
                <xsl:apply-templates select="key('resources', 'reset', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                    <xsl:with-param name="class" select="'btn'"/>
                </xsl:apply-templates>
                
                <xsl:apply-templates select="key('resources', 'reset', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
            </button>
        </div>
    </xsl:template>

    <!-- FORM ACTIONS -->
    
    <xsl:template match="rdf:RDF" mode="bs2:FormActions">
        <xsl:param name="class" select="'row-fluid'" as="xs:string?"/>
        <xsl:param name="button-class" select="'btn btn-primary'" as="xs:string?"/>
        
        <div>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
            
            <div class="form-actions offset2 span7">
                <button type="submit" class="{$button-class}">
                    <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                        <xsl:with-param name="class" select="$button-class"/>
                    </xsl:apply-templates>
                    
                    <xsl:apply-templates select="key('resources', 'save', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                </button>

                <button type="reset" class="btn">
                    <xsl:apply-templates select="key('resources', 'reset', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ldh:logo">
                        <xsl:with-param name="class" select="'btn'"/>
                    </xsl:apply-templates>
                    
                    <xsl:apply-templates select="key('resources', 'reset', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri)))" mode="ac:label"/>
                </button>
            </div>
        </div>
    </xsl:template>

    <!-- EXCEPTION -->
    
    <xsl:template match="*[http:sc/@rdf:resource = 'http://www.w3.org/2011/http-statusCodes#Conflict']" mode="bs2:Exception" priority="1">
        <xsl:param name="class" select="'alert alert-error'" as="xs:string?"/>

        <div>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>

            <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/linkeddatahub#ResourceExistsException', document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub#')))" mode="ldh:logo">
                <xsl:with-param name="class" select="$class"/>
            </xsl:apply-templates>
            <xsl:text> </xsl:text>
            <xsl:value-of>
                <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/linkeddatahub#ResourceExistsException', document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub#')))" mode="ac:label"/>
            </xsl:value-of>
        </div>
    </xsl:template>

    <!-- CREATE -->
    
    <xsl:template match="rdf:RDF[$acl:mode = 'http://www.w3.org/ns/auth/acl#Append']" mode="bs2:Create" priority="1">
        <xsl:param name="class" select="'btn-group'" as="xs:string?"/>
        <xsl:param name="classes" as="element()*"/>
        <xsl:param name="show-document-classes" select="true()" as="xs:boolean"/>
        <xsl:param name="create-graph" select="false()" as="xs:boolean"/>

        <div>
            <xsl:if test="$class">
                <xsl:attribute name="class" select="$class"/>
            </xsl:if>
            
            <button type="button" title="{ac:label(key('resources', 'create-instance-title', document(resolve-uri('static/com/atomgraph/linkeddatahub/xsl/bootstrap/2.3.2/translations.rdf', $ac:contextUri))))}">
                <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/client#ConstructMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))" mode="ldh:logo">
                    <xsl:with-param name="class" select="'btn btn-primary dropdown-toggle'"/>
                </xsl:apply-templates>
                <xsl:value-of>
                    <xsl:apply-templates select="key('resources', 'https://w3id.org/atomgraph/client#ConstructMode', document(ac:document-uri('https://w3id.org/atomgraph/client#')))" mode="ac:label"/>
                </xsl:value-of>
                <xsl:text> </xsl:text>
                <span class="caret"/>
            </button>

            <ul class="dropdown-menu">
                <xsl:if test="$show-document-classes">
                    <!--if the current resource is a Container, show Container and Item constructors--> 
                    <xsl:variable name="document-classes" select="key('resources', ('https://www.w3.org/ns/ldt/document-hierarchy#Container', 'https://www.w3.org/ns/ldt/document-hierarchy#Item'), document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub/default#')))" as="element()*"/>
                    <!-- current resource is a container -->
                    <xsl:if test="exists($document-classes) and key('resources', ac:uri())/rdf:type/@rdf:resource = ('https://w3id.org/atomgraph/linkeddatahub/default#Root', 'https://www.w3.org/ns/ldt/document-hierarchy#Container')">
                        <xsl:apply-templates select="$document-classes" mode="bs2:ConstructorListItem">
                            <xsl:with-param name="create-graph" select="$create-graph"/>
                            <xsl:sort select="ac:label(.)"/>
                        </xsl:apply-templates>

                        <xsl:if test="$classes">
                            <li class="divider"/>
                        </xsl:if>
                    </xsl:if>
                </xsl:if>
                
                <xsl:apply-templates select="key('resources', 'http://www.w3.org/2002/07/owl#NamedIndividual', document(ac:document-uri('http://www.w3.org/2002/07/owl#')))" mode="bs2:ConstructorListItem">
                    <xsl:with-param name="create-graph" select="$create-graph"/>
                    <xsl:sort select="ac:label(.)"/>
                </xsl:apply-templates>

                <li class="divider"/>
                
                <xsl:apply-templates select="$classes" mode="bs2:ConstructorListItem">
                    <xsl:with-param name="create-graph" select="$create-graph"/>
                    <xsl:sort select="ac:label(.)"/>
                </xsl:apply-templates>
            </ul>
        </div>
    </xsl:template>

    <xsl:template match="*" mode="bs2:Create"/>
    
    <!-- OBJECT -->
    
    <xsl:template match="rdf:RDF" mode="bs2:Object">
        <xsl:apply-templates mode="#current"/>
    </xsl:template>
    
</xsl:stylesheet>