<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:ac="https://w3id.org/atomgraph/client#" xmlns:acl="http://www.w3.org/ns/auth/acl#" xmlns:bs2="http://graphity.org/xsl/bootstrap/2.3.2" xmlns:dct="http://purl.org/dc/terms/" xmlns:dh="https://www.w3.org/ns/ldt/document-hierarchy#" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:http="http://www.w3.org/2011/http#" xmlns:lacl="https://w3id.org/atomgraph/linkeddatahub/admin/acl#" xmlns:ldh="https://w3id.org/atomgraph/linkeddatahub#" xmlns:ldt="https://www.w3.org/ns/ldt#" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#" xmlns:sioc="http://rdfs.org/sioc/ns#" xmlns:spin="http://spinrdf.org/spin#" xmlns:srx="http://www.w3.org/2005/sparql-results#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" exclude-result-prefixes="#all">

    <xsl:param name="ldh:access-to" as="xs:anyURI?"/>

    <xsl:template match="rdf:RDF[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ac:method = 'POST'][key('resources-by-type', 'http://spinrdf.org/spin#ConstraintViolation')]" mode="xhtml:Body" priority="3">
        <xsl:apply-templates select="." mode="bs2:RowForm">
            <xsl:with-param name="action" select="ac:uri()"/>
            <xsl:with-param name="enctype" select="()"/> <!-- don't use 'multipart/form-data' which is the default -->
            <xsl:with-param name="create-resource" select="false()"/>
            <xsl:with-param name="constructor-query" select="$constructor-query" tunnel="yes"/>
            <xsl:with-param name="constraint-query" select="$constraint-query" tunnel="yes"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="rdf:RDF[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ac:method = 'GET']" mode="xhtml:Body" priority="2">
        <body>
            <xsl:apply-templates select="." mode="bs2:NavBar"/>

            <div id="content-body" class="container-fluid">
                <xsl:apply-templates select="key('resources', ac:uri())" mode="ldh:ContentList"/>

                <xsl:apply-templates select="." mode="bs2:Row"/>
            </div>

            <xsl:apply-templates select="." mode="bs2:Footer"/>
        </body>
    </xsl:template>

    <!-- currently doesn't work because the client-side does not refresh the bs2:NavBarActions -->
    <!--<xsl:template match="rdf:RDF[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = '&adm;RequestAccess']" mode="bs2:NavBarActions" priority="2"/>-->

    <xsl:template match="rdf:RDF[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:ModeTabs" priority="2"/>

    <xsl:template match="*[rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ac:method = 'GET']" mode="bs2:Row" priority="2">
        <xsl:variable name="constructor" as="document-node()">
            <xsl:document>
                <!-- construct a combined graph of dh:Item and lacl:AuthorizationRequest instances -->
                <xsl:for-each select="ldh:construct(map{ xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item'): spin:constructors(xs:anyURI('https://www.w3.org/ns/ldt/document-hierarchy#Item'), resolve-uri('ns', $ldt:base), $constructor-query)//srx:binding[@name = 'construct']/srx:literal/string(),                         xs:anyURI('https://w3id.org/atomgraph/linkeddatahub/admin/acl#AuthorizationRequest'): spin:constructors(xs:anyURI('https://w3id.org/atomgraph/linkeddatahub/admin/acl#AuthorizationRequest'), resolve-uri('ns', $ldt:base), $constructor-query)//srx:binding[@name = 'construct']/srx:literal/string() })">
                    <xsl:apply-templates select="." mode="ldh:SetPrimaryTopic">
                        <xsl:with-param name="topic-id" select="key('resources-by-type', 'https://w3id.org/atomgraph/linkeddatahub/admin/acl#AuthorizationRequest')/@rdf:nodeID" tunnel="yes"/>
                        <xsl:with-param name="doc-id" select="key('resources-by-type', 'https://www.w3.org/ns/ldt/document-hierarchy#Item')/@rdf:nodeID" tunnel="yes"/>
                    </xsl:apply-templates>
                </xsl:for-each>
            </xsl:document>
        </xsl:variable>
        
        <xsl:apply-templates select="$constructor" mode="bs2:RowForm">
            <xsl:with-param name="action" select="ac:uri()"/>
            <xsl:with-param name="enctype" select="()"/> <!-- don't use 'multipart/form-data' which is the default -->
            <xsl:with-param name="create-resource" select="false()"/>
            <xsl:with-param name="constructor-query" select="$constructor-query" tunnel="yes"/>
            <xsl:with-param name="constraint-query" select="$constraint-query" tunnel="yes"/>
        </xsl:apply-templates>
    </xsl:template>

    <!-- display stored AuthorizationRequest data after successful POST (without ConstraintViolations) -->
    <!-- match the first resource, whatever it is -->
    <xsl:template match="*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ac:method = 'POST'][not(key('resources-by-type', 'http://www.w3.org/2011/http#Response'))][1]" mode="bs2:Row" priority="3">
        <xsl:param name="id" as="xs:string?"/>
        <xsl:param name="class" select="'offset2 span7'" as="xs:string?"/>

        <div class="row-fluid">
            <div class="offset2 span7">
                <div class="alert alert-success row-fluid ">
                    <div class="span1">
                        <img src="{resolve-uri('static/com/atomgraph/linkeddatahub/icons/baseline_done_white_48dp.png', $ac:contextUri)}" alt="Request created"/>
                    </div>
                    <div class="span11">
                        <p>Your access request has been created.</p>
                        <p>You will be notified when the administrator approves or rejects it.</p>
                    </div>
                </div>
            </div>
        </div>
    </xsl:template>

    <!-- suppress other resources -->
    <xsl:template match="*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ac:method = 'POST'][not(key('resources-by-type', 'http://www.w3.org/2011/http#Response'))]" mode="bs2:Row" priority="2"/>

    <!-- hide object blank nodes (that only have a single rdf:type property) from constructed models -->
    <xsl:template match="rdf:Description[$ac:method = 'GET'][@rdf:nodeID][not(rdf:type/@rdf:resource = ('https://w3id.org/atomgraph/linkeddatahub/admin/acl#AuthorizationRequest', 'https://www.w3.org/ns/ldt/document-hierarchy#Item'))][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:RowForm" priority="3"/>

    <xsl:template match="*[*][@rdf:about or @rdf:nodeID][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="1">
        <xsl:next-match>
            <xsl:with-param name="show-subject" select="false()" tunnel="yes"/>
            <xsl:with-param name="legend" select="false()"/>
            <xsl:with-param name="required" select="true()"/>
        </xsl:next-match>
    </xsl:template>

    <!-- make properties required -->
    <xsl:template match="*[*][@rdf:about or @rdf:nodeID][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']/*" mode="bs2:FormControl" priority="1">
        <xsl:next-match>
            <xsl:with-param name="required" select="true()"/>
        </xsl:next-match>
    </xsl:template>
    
    <xsl:template match="*[@rdf:about or @rdf:nodeID][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']/sioc:has_parent | *[@rdf:about or @rdf:nodeID][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']/sioc:has_container" mode="bs2:FormControl" priority="4">
        <xsl:apply-templates select="." mode="xhtml:Input">
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:apply-templates>

        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'ou'"/>
            <xsl:with-param name="type" select="'hidden'"/>
            <xsl:with-param name="value" select="resolve-uri('acl/authorization-requests/', $ldt:base)"/>
        </xsl:call-template>
        <!-- generate Item title -->
        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'pu'"/>
            <xsl:with-param name="value" select="'http://purl.org/dc/terms/title'"/>
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:call-template>
        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'ol'"/>
            <xsl:with-param name="value" select="'Access request by ' || ac:label(key('resources-by-type', 'http://xmlns.com/foaf/0.1/Agent', $foaf:Agent))"/>
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="lacl:requestMode/@rdf:*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="2">
        <xsl:param name="id" select="generate-id()" as="xs:string"/>
        <xsl:param name="class" as="xs:string?"/>
        <xsl:param name="disabled" select="false()" as="xs:boolean"/>
        <xsl:param name="type-label" select="true()" as="xs:boolean"/>
        
        <xsl:variable name="this" select="../concat(namespace-uri(), local-name())" as="xs:string"/>
        <xsl:variable name="properties" select="../../*[concat(namespace-uri(), local-name()) = $this]" as="element()*"/>
        <xsl:variable name="modes" select="key('resources-by-subclass', 'http://www.w3.org/ns/auth/acl#Access', document(ac:document-uri('http://www.w3.org/ns/auth/acl#')))" as="element()*"/>
        <xsl:variable name="default" select="xs:anyURI('http://www.w3.org/ns/auth/acl#Read')" as="xs:anyURI*"/>
        <select name="ou" id="{generate-id()}" multiple="multiple" size="{count($modes)}">
            <xsl:for-each select="$modes">
                <xsl:sort select="ac:label(.)" lang="{$ldt:lang}"/>
                <xsl:apply-templates select="." mode="xhtml:Option">
                    <xsl:with-param name="selected" select="if ($ac:method = 'POST') then @rdf:about = $properties/@rdf:resource else @rdf:about = $default"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </select>
        
        <xsl:if test="$type-label">
            <xsl:apply-templates select="." mode="bs2:FormControlTypeLabel"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="lacl:requestAgent[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="2">
        <xsl:apply-templates select="." mode="xhtml:Input">
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:apply-templates>

        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'ou'"/>
            <xsl:with-param name="value" select="key('resources-by-type', 'http://xmlns.com/foaf/0.1/Agent', $foaf:Agent)/@rdf:about"/>
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:call-template>
        
        <!-- generate AuthorizationRequest label-->
        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'pu'"/>
            <xsl:with-param name="value" select="'http://www.w3.org/2000/01/rdf-schema#label'"/>
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:call-template>
        <xsl:call-template name="xhtml:Input">
            <xsl:with-param name="name" select="'ol'"/>
            <xsl:with-param name="value" select="'Access request by ' || ac:label(key('resources-by-type', 'http://xmlns.com/foaf/0.1/Agent', $foaf:Agent))"/>
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="lacl:requestAccessTo/@rdf:*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'][$ldh:access-to]" mode="bs2:FormControl" priority="2">
        <select name="ou" id="{generate-id()}" multiple="multiple" size="4">
            <option value="{resolve-uri('../add', $ldt:base)}" selected="selected">Add RDF endpoint</option>
            <option value="{resolve-uri('../service', $ldt:base)}" selected="selected">Graph Store endpoint</option>
            <option value="{resolve-uri('../ns', $ldt:base)}" selected="selected">Namespace endpoint</option>
            <option value="{resolve-uri('../sparql', $ldt:base)}" selected="selected">SPARQL endpoint</option>
        </select>
    </xsl:template>

    <!-- show first property as a select -->
    <xsl:template match="lacl:requestAccessToClass[1]/@rdf:*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="2">
        <xsl:variable name="this" select="../concat(namespace-uri(), local-name())" as="xs:string"/>
        <xsl:variable name="classes" select="key('resources', ('https://w3id.org/atomgraph/linkeddatahub/default#Root', 'https://www.w3.org/ns/ldt/document-hierarchy#Container','https://www.w3.org/ns/ldt/document-hierarchy#Item', 'http://www.semanticdesktop.org/ontologies/2007/03/22/nfo#FileDataObject'), document(ac:document-uri('https://w3id.org/atomgraph/linkeddatahub/default#')))" as="element()*"/>
        <select name="ou" id="{generate-id()}" multiple="multiple" size="{count($classes)}">
            <xsl:for-each select="$classes">
                <xsl:sort select="ac:label(.)" lang="{$ldt:lang}"/>
                <xsl:apply-templates select="." mode="xhtml:Option">
                    <xsl:with-param name="selected" select="true()"/>
                </xsl:apply-templates>
            </xsl:for-each>
        </select>
    </xsl:template>

    <!-- hide following properties -->
    <xsl:template match="lacl:requestAccessToClass/@rdf:*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="1"/>
    
    <!-- hide type control -->
    <xsl:template match="*[*][@rdf:about or @rdf:nodeID][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:TypeControl" priority="2">
        <xsl:next-match>
            <xsl:with-param name="hidden" select="true()"/>
        </xsl:next-match>
    </xsl:template>

    <!-- suppress properties -->
    <xsl:template match="dct:title[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'] | dct:description[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'] | rdf:_1[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:FormControl" priority="4"/>

    <!-- hide properties (including all of document resource properties) -->
    <xsl:template match="rdfs:label[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'] | foaf:isPrimaryTopicOf[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess'] | *[foaf:primaryTopic][doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']/*" mode="bs2:FormControl" priority="3">
        <xsl:apply-templates select="." mode="xhtml:Input">
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="node() | @rdf:resource | @rdf:nodeID" mode="#current">
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="@xml:lang | @rdf:datatype" mode="#current">
            <xsl:with-param name="type" select="'hidden'"/>
        </xsl:apply-templates>
    </xsl:template>

    <!-- turn off additional properties - it applies on the constructor document and not the $main-doc -->
    <xsl:template match="*[doc-available(ac:uri())][key('resources', ac:uri(), document(ac:uri()))/rdf:type/@rdf:resource = 'https://w3id.org/atomgraph/linkeddatahub/admin#RequestAccess']" mode="bs2:PropertyControl" priority="1"/>

</xsl:stylesheet>