/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.core.io.DatasetProvider;
import com.atomgraph.server.exception.SHACLConstraintViolationException;
import com.atomgraph.server.exception.SPINConstraintViolationException;
import com.atomgraph.server.util.Validator;
import com.atomgraph.spinrdf.constraints.ConstraintViolation;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingDatasetProvider
extends DatasetProvider {
    private static final Logger log = LoggerFactory.getLogger(ValidatingDatasetProvider.class);
    @Context
    private Providers providers;
    @Inject
    Provider<Optional<Ontology>> ontology;

    public Dataset readFrom(Class<Dataset> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.process(super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    public Dataset process(Dataset dataset) {
        return this.validate(dataset);
    }

    public Dataset validate(Dataset dataset) {
        if (this.getOntology().isPresent()) {
            Validator validator = new Validator(this.getOntology().get().getOntModel());
            List<ConstraintViolation> cvs = validator.validate(dataset.getDefaultModel());
            if (!cvs.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("SPIN constraint violations: {}", cvs);
                }
                throw new SPINConstraintViolationException(cvs, dataset.getDefaultModel());
            }
            Shapes shapes = Shapes.parse((Graph)this.getOntology().get().getOntModel().getGraph());
            ValidationReport report = ShaclValidator.get().validate(shapes, dataset.getDefaultModel().getGraph());
            if (!report.conforms()) {
                if (log.isDebugEnabled()) {
                    log.debug("SHACL constraint violations: {}", (Object)report);
                }
                throw new SHACLConstraintViolationException(report, dataset.getDefaultModel());
            }
            Iterator it = dataset.listNames();
            while (it.hasNext()) {
                String graphURI = (String)it.next();
                cvs = validator.validate(dataset.getNamedModel(graphURI));
                if (!cvs.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("SPIN constraint violations: {}", cvs);
                    }
                    throw new SPINConstraintViolationException(cvs, dataset.getNamedModel(graphURI), graphURI);
                }
                report = ShaclValidator.get().validate(shapes, dataset.getNamedModel(graphURI).getGraph());
                if (report.conforms()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("SHACL constraint violations: {}", (Object)report);
                }
                throw new SHACLConstraintViolationException(report, dataset.getNamedModel(graphURI));
            }
        }
        return dataset;
    }

    public Optional<Ontology> getOntology() {
        return (Optional)this.ontology.get();
    }

    public Providers getProviders() {
        return this.providers;
    }
}

