/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.server.exception.SHACLConstraintViolationException;
import com.atomgraph.server.exception.SPINConstraintViolationException;
import com.atomgraph.server.io.BasedModelProvider;
import com.atomgraph.server.util.Validator;
import com.atomgraph.spinrdf.constraints.ConstraintViolation;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.apache.jena.graph.Graph;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatingModelProvider
extends BasedModelProvider {
    private static final Logger log = LoggerFactory.getLogger(ValidatingModelProvider.class);
    @Context
    private Providers providers;
    @Inject
    Provider<Optional<Ontology>> ontology;

    @Override
    public Model readFrom(Class<Model> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.processRead(super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    public Model processRead(Model model) {
        return this.validate(model);
    }

    public Model validate(Model model) {
        if (this.getOntology().isPresent()) {
            List<ConstraintViolation> cvs = new Validator(this.getOntology().get().getOntModel()).validate(model);
            if (!cvs.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("SPIN constraint violations: {}", cvs);
                }
                throw new SPINConstraintViolationException(cvs, model);
            }
            Shapes shapes = Shapes.parse((Graph)this.getOntology().get().getOntModel().getGraph());
            ValidationReport report = ShaclValidator.get().validate(shapes, model.getGraph());
            if (!report.conforms()) {
                if (log.isDebugEnabled()) {
                    log.debug("SHACL constraint violations: {}", (Object)report);
                }
                throw new SHACLConstraintViolationException(report, model);
            }
        }
        return model;
    }

    @Override
    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        super.writeTo(this.processWrite(model), type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public Model processWrite(Model model) {
        return model;
    }

    public Optional<Ontology> getOntology() {
        return (Optional)this.ontology.get();
    }

    public Providers getProviders() {
        return this.providers;
    }
}

