/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.mapper;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.model.impl.Response;
import com.atomgraph.core.util.Link;
import com.atomgraph.core.util.ModelUtils;
import com.atomgraph.server.vocabulary.HTTP;
import com.atomgraph.server.vocabulary.LDT;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;

@Provider
public abstract class ExceptionMapperBase {
    @Context
    private Request request;
    @Context
    private UriInfo uriInfo;
    private final MediaTypes mediaTypes;

    @Inject
    public ExceptionMapperBase(MediaTypes mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public Resource toResource(Exception ex, Response.StatusType status, Resource statusResource) {
        if (ex == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Response.Status cannot be null");
        }
        Resource resource = ModelFactory.createDefaultModel().createResource().addProperty(RDF.type, (RDFNode)HTTP.Response).addLiteral((Property)HTTP.statusCodeValue, (long)status.getStatusCode()).addLiteral((Property)HTTP.reasonPhrase, (Object)status.getReasonPhrase());
        if (statusResource != null) {
            resource.addProperty((Property)HTTP.sc, (RDFNode)statusResource);
        }
        if (ex.getMessage() != null) {
            resource.addLiteral(DCTerms.title, (Object)ex.getMessage());
        }
        return resource;
    }

    public Response.ResponseBuilder getResponseBuilder(Model model) {
        List<Variant> variants = this.getVariants(Model.class);
        Variant variant = this.getRequest().selectVariant(variants);
        if (variant == null) {
            variant = new Variant((MediaType)com.atomgraph.core.MediaType.TEXT_TURTLE_TYPE, (Locale)null, null);
        }
        return new Response(this.getRequest(), (Object)model, null, new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)model))), variant).getResponseBuilder().header("Link", (Object)new Link(this.getUriInfo().getBaseUri(), LDT.base.getURI(), null));
    }

    public List<Variant> getVariants(Class clazz) {
        return this.getVariants(this.getWritableMediaTypes(clazz));
    }

    public List<Variant> getVariants(List<MediaType> mediaTypes) {
        return Response.getVariantListBuilder(mediaTypes, this.getLanguages(), this.getEncodings()).add().build();
    }

    public List<MediaType> getWritableMediaTypes(Class clazz) {
        return this.getMediaTypes().getWritable(clazz);
    }

    public List<Locale> getLanguages() {
        return new ArrayList<Locale>();
    }

    public List<String> getEncodings() {
        return new ArrayList<String>();
    }

    public Request getRequest() {
        return this.request;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

