/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.mapper;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.server.exception.SPINConstraintViolationException;
import com.atomgraph.server.mapper.ExceptionMapperBase;
import com.atomgraph.spinrdf.constraints.SPINConstraints;
import com.atomgraph.spinrdf.vocabulary.SPIN;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;

public class SPINConstraintViolationExceptionMapper
extends ExceptionMapperBase
implements ExceptionMapper<SPINConstraintViolationException> {
    @Inject
    public SPINConstraintViolationExceptionMapper(MediaTypes mediaTypes) {
        super(mediaTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response toResponse(SPINConstraintViolationException ex) {
        Resource exception = this.toResource(ex, (Response.StatusType)Response.Status.BAD_REQUEST, ResourceFactory.createResource((String)"http://www.w3.org/2011/http-statusCodes#BadRequest"));
        ex.getModel().add(exception.getModel());
        SPINConstraints.addConstraintViolationsRDF(ex.getConstraintViolations(), (Model)ex.getModel(), (boolean)true);
        try (ResIterator it = ex.getModel().listSubjectsWithProperty(RDF.type, (RDFNode)SPIN.ConstraintViolation);){
            while (it.hasNext()) {
                Resource violation = (Resource)it.next();
                ex.getModel().add(exception, ResourceFactory.createProperty((String)"http://www.w3.org/ns/prov#wasDerivedFrom"), (RDFNode)violation);
            }
        }
        return this.getResponseBuilder(ex.getModel()).status(422).build();
    }
}

