/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.timing;

import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import java.util.ArrayList;
import java.util.List;

public final class PooledAlarmTimer
implements AlarmTimer {
    private final List listeners;
    private final long timeout;
    private final Object runMonitor = new Object();
    private boolean runFlag = true;

    public PooledAlarmTimer(long timeout) {
        this.listeners = new ArrayList();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlarmTimerListener(AlarmTimerListener lstnr) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(lstnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlarmTimerListener(AlarmTimerListener lstnr) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(lstnr);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.runMonitor;
        synchronized (object) {
            return this.runFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.runMonitor;
        synchronized (object) {
            this.runFlag = false;
            this.runMonitor.notify();
        }
    }

    public void run() {
        while (this.isActive()) {
            try {
                this.doWait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isActive()) continue;
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        ArrayList tempList = new ArrayList(this.listeners);
        for (AlarmTimerListener list : tempList) {
            list.alarm(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWait(long millis) throws InterruptedException {
        Object object = this.runMonitor;
        synchronized (object) {
            this.runMonitor.wait(millis);
        }
    }
}

