/**
 * Copyright (C) 2000-2010 Atomikos <info@atomikos.com>
 *
 * This code ("Atomikos TransactionsEssentials"), by itself,
 * is being distributed under the
 * Apache License, Version 2.0 ("License"), a copy of which may be found at
 * http://www.atomikos.com/licenses/apache-license-2.0.txt .
 * You may not use this file except in compliance with the License.
 *
 * While the License grants certain patent license rights,
 * those patent license rights only extend to the use of
 * Atomikos TransactionsEssentials by itself.
 *
 * This code (Atomikos TransactionsEssentials) contains certain interfaces
 * in package (namespace) com.atomikos.icatch
 * (including com.atomikos.icatch.Participant) which, if implemented, may
 * infringe one or more patents held by Atomikos.
 * It should be appreciated that you may NOT implement such interfaces;
 * licensing to implement these interfaces must be obtained separately from Atomikos.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 */


//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Log: AbstractPropertiesTableModel.java,v $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/08/29 10:01:15  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Import of 3.0 essentials edition.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/04/29 08:55:51  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Initial import.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/03/29 13:21:41  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Imported.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/03/23 16:25:37  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Imported.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/03/22 13:47:03  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Import.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.1.1.1  2006/03/09 14:59:44  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Imported 3.0 development into CVS repository.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Revision 1.7  2003/03/11 06:43:40  guy

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//Merged in changes from transactionsJTA100 branch.

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//$Id: AbstractPropertiesTableModel.java,v 1.1.1.1 2006/08/29 10:01:15 guy Exp $

//

//Revision 1.6  2002/04/14 11:00:12  guy
//Removed import of applicationserver package: not needed.
//

//Revision 1.5.4.1  2002/04/14 15:51:16  guy
//Deleted obsolete imports and files from the applicationserver framework.
//

//Revision 1.5  2002/01/29 12:55:38  guy
//Added files again; deleted by mistake.
//
//Revision 1.3  2001/10/08 10:52:34  guy
//Changed constructor scope to public.
//
//Revision 1.2  2001/10/08 10:47:28  guy
//Added getData method to allow subclass implementations to
//retrieve the data.
//
//Revision 1.1  2001/10/08 09:45:02  guy
//Added this file to allow easier construction of new table models.
//Subclasses only need to override one method to implement their own
//PropertiesTableModel. Makes GUI integration easier.
//

package com.atomikos.swing;

import java.util.Vector;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;


/**
 *
 *
 *An abstract implementation of a properties table model.
 *
 *Subclasses need to override the getValueAt method.
 */

public abstract class AbstractPropertiesTableModel
extends AbstractTableModel
implements PropertiesTableModel
{

    private Vector data_;
    private String[] columnNames_;

    /**
     *Creates a new instance for a given data set and a
     *number of column names.
     *
     *@param data The data; each element in the vector is a row.
     *@param columnNames The column names to use.
     *The size determines the number of columns.
     */

    public AbstractPropertiesTableModel ( Vector data , String[] columnNames )
    {
        data_ = data;
        columnNames_ = columnNames;
    }

    protected Vector getData()
   {
	return data_;
   }

    /**
     *@see PropertiesTableModel
     */

    public TableModel getTableModel ()
    {
        return this;
    }


    public int getRowCount()
    {
        return data_.size();
    }


    public int getColumnCount()
    {
        return columnNames_.length;
    }

    public abstract Object getValueAt ( int row, int column );


    public String getColumnName ( int col )
    {
       return columnNames_[col];
    }

    public boolean isCellEditable ( int row, int col )
    {
        return false;
    }

    /**
     *@see PropertiesTableModel
     */

    public void rowDeleted ( int row )
    {
        fireTableRowsDeleted ( row, row );
    }

    /**
     *@see PropertiesTableModel
     */

    public void refresh()
    {
        fireTableRowsUpdated ( 0, data_.size() );
    }

    /**
     *@see PropertiesTableModel
     */

    public void rowInserted ()
    {
        fireTableRowsInserted ( 0, data_.size() );
    }

}

