/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch;

import com.atomikos.icatch.Participant;
import com.atomikos.icatch.SysException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Extent {
    public static final String VERSION = "2019";
    private final Map<String, Integer> participants = new Hashtable<String, Integer>();
    private boolean queried = false;
    private final Stack<Participant> directs = new Stack();
    private String parentTransactionId;

    public Extent() {
    }

    public Extent(String parentTransactionId) {
        this.parentTransactionId = parentTransactionId;
    }

    public Extent(Extent extent) {
        this.parentTransactionId = extent.getParentTransactionId();
        this.addRemoteParticipants(extent.participants);
    }

    public String getParentTransactionId() {
        return this.parentTransactionId;
    }

    public void addRemoteParticipants(Map<String, Integer> participants) throws IllegalStateException, SysException {
        if (participants == null) {
            return;
        }
        Set<String> parts = participants.keySet();
        for (String participant : parts) {
            Integer count = this.participants.get(participant);
            if (count == null) {
                count = 0;
            }
            Integer cnt = participants.get(participant);
            count = count + cnt;
            this.participants.put(participant, count);
        }
    }

    public Map<String, Integer> getRemoteParticipants() {
        this.queried = true;
        return new HashMap<String, Integer>(this.participants);
    }

    public Stack<Participant> getParticipants() {
        this.queried = true;
        return (Stack)this.directs.clone();
    }

    public synchronized void add(Participant participant, int count) throws SysException, IllegalStateException {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        table.put(participant.getURI(), count);
        this.addRemoteParticipants(table);
        this.directs.push(participant);
    }

    public synchronized void add(Extent extent) throws IllegalStateException, SysException {
        if (this.queried) {
            throw new IllegalStateException("Adding extent no longer allowed");
        }
        this.addRemoteParticipants(extent.getRemoteParticipants());
        Enumeration enumm = extent.getParticipants().elements();
        while (enumm.hasMoreElements()) {
            Participant part = (Participant)enumm.nextElement();
            this.directs.push(part);
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("version=").append(VERSION).append(",");
        String delimiter = "";
        if (this.parentTransactionId != null) {
            ret.append("parent=").append(this.parentTransactionId);
            delimiter = ",";
        }
        HashSet<String> alreadyAdded = new HashSet<String>();
        for (Participant p : this.directs) {
            ret.append(delimiter).append("uri=").append(p.getURI()).append(",").append("responseCount=").append(this.participants.get(p.getURI())).append(",").append("direct=").append("true");
            delimiter = ",";
            alreadyAdded.add(p.getURI());
        }
        for (String pUri : this.participants.keySet()) {
            if (alreadyAdded.contains(pUri)) continue;
            ret.append(delimiter).append("uri=").append(pUri).append(",").append("responseCount=").append(this.participants.get(pUri)).append(",").append("direct=").append("false");
        }
        return ret.toString();
    }
}

