/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.hibernate3;

import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyUtils;
import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.atomikos.jdbc.AtomikosSQLException;
import com.atomikos.jdbc.nonxa.AtomikosNonXADataSourceBean;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;

public class AtomikosConnectionProvider
implements ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosConnectionProvider.class);
    private static final String PROPERTIES_PREFIX = "hibernate.connection.atomikos.";
    private static final String PROPERTY_NONXA = "hibernate.connection.atomikos.nonxa";
    private AbstractDataSourceBean dataSource = null;

    public void close() throws HibernateException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
        this.dataSource = null;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void configure(Properties props) throws HibernateException {
        if (this.dataSource != null) {
            return;
        }
        this.dataSource = "true".equalsIgnoreCase(props.getProperty(PROPERTY_NONXA)) ? new AtomikosNonXADataSourceBean() : new AtomikosDataSourceBean();
        Properties atomikosProperties = this.filterOutHibernateProperties(props);
        LOGGER.logInfo("configuring AtomikosConnectionProvider with properties: " + atomikosProperties);
        try {
            PropertyUtils.setProperties((Object)this.dataSource, (Map)atomikosProperties);
        }
        catch (PropertyException ex) {
            throw new HibernateException("cannot create Atomikos DataSource", (Throwable)ex);
        }
        try {
            this.dataSource.init();
        }
        catch (AtomikosSQLException ex) {
            throw new HibernateException("cannot initialize Atomikos DataSource", (Throwable)ex);
        }
    }

    private Properties filterOutHibernateProperties(Properties props) {
        Properties atomikosProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(PROPERTIES_PREFIX) || key.equals(PROPERTY_NONXA)) continue;
            atomikosProperties.setProperty(key.substring(PROPERTIES_PREFIX.length()), value);
        }
        return atomikosProperties;
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null) {
            throw new HibernateException("datasource is not configured");
        }
        return this.dataSource.getConnection();
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

