/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AtomikosSQLException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;

public class JdbcConnectionProxyHelper {
    public static void convertProxyError(Throwable ex, String msg) throws SQLException {
        if (ex instanceof Error) {
            Error err = (Error)ex;
            Configuration.logWarning((String)msg, (Throwable)err);
            throw err;
        }
        if (ex instanceof RuntimeException) {
            RuntimeException rte = (RuntimeException)ex;
            Configuration.logWarning((String)msg, (Throwable)ex);
            throw rte;
        }
        if (ex instanceof SQLException) {
            SQLException driverError = (SQLException)ex;
            Configuration.logWarning((String)msg, (Throwable)ex);
            throw driverError;
        }
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            Throwable cause = ite.getCause();
            if (cause != null) {
                Configuration.logDebug((String)msg, (Throwable)ite);
                JdbcConnectionProxyHelper.convertProxyError(cause, msg);
            } else {
                AtomikosSQLException.throwAtomikosSQLException(msg, ite);
            }
        }
        AtomikosSQLException.throwAtomikosSQLException(msg, ex);
    }

    public static void setIsolationLevel(Connection connection, int defaultIsolationLevel) throws CreateConnectionException {
        if (defaultIsolationLevel < 0) {
            return;
        }
        try {
            Configuration.logInfo((String)("setting isolation level to " + defaultIsolationLevel));
            connection.setTransactionIsolation(defaultIsolationLevel);
        }
        catch (SQLException ex) {
            Configuration.logWarning((String)("cannot set isolation level to " + defaultIsolationLevel), (Throwable)ex);
            throw new CreateConnectionException("The configured default isolation level " + defaultIsolationLevel + " seems unsupported by the driver - please check your JDBC driver documentation?", (Exception)ex);
        }
    }
}

