/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.nonxa.AtomikosNonXAConnectionFactory;
import com.atomikos.jdbc.nonxa.AtomikosThreadLocalConnection;
import com.atomikos.util.DynamicProxy;
import java.sql.Connection;
import java.sql.SQLException;

public class AtomikosNonXADataSourceBean
extends AbstractDataSourceBean {
    private static final long serialVersionUID = 1L;
    private String url;
    private String user;
    private String password;
    private String driverClassName;
    private boolean readOnly;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    protected void doClose() {
    }

    protected ConnectionFactory doInit() throws Exception {
        AtomikosNonXAConnectionFactory ret = null;
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": initializing with [" + " uniqueResourceName=" + this.getUniqueResourceName() + "," + " maxPoolSize=" + this.getMaxPoolSize() + "," + " minPoolSize=" + this.getMinPoolSize() + "," + " borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + "," + " maxIdleTime=" + this.getMaxIdleTime() + "," + " reapTimeout=" + this.getReapTimeout() + "," + " maintenanceInterval=" + this.getMaintenanceInterval() + "," + " testQuery=" + this.getTestQuery() + "," + " driverClassName=" + this.getDriverClassName() + "," + " user=" + this.getUser() + "," + " url=" + this.getUrl() + " loginTimeout=" + this.getLoginTimeout() + "]"));
        }
        ret = new AtomikosNonXAConnectionFactory(this, this.url, this.driverClassName, this.user, this.password, this.getLoginTimeout(), this.readOnly);
        ret.init();
        return ret;
    }

    public synchronized Connection getConnection(HeuristicMessage hmsg) throws SQLException {
        if (Configuration.isInfoLoggingEnabled()) {
            Configuration.logInfo((String)(this + ": getConnection ( " + hmsg + " )..."));
        }
        this.init();
        Connection proxy = super.getConnection(hmsg);
        DynamicProxy dproxy = (DynamicProxy)proxy;
        AtomikosThreadLocalConnection previous = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
        previous.incUseCount();
        previous.addHeuristicMessage(hmsg);
        if (Configuration.isDebugLoggingEnabled()) {
            Configuration.logDebug((String)(this + ": returning " + proxy));
        }
        return proxy;
    }

    public String toString() {
        String ret = "AtomikosNonXADataSourceBean";
        String name = this.getUniqueResourceName();
        if (name != null) {
            ret = ret + " '" + name + "'";
        }
        return ret;
    }
}

