/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jdbc.internal.AtomikosJdbcConnectionProxy;
import com.atomikos.jdbc.internal.JdbcConnectionProxyHelper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.XAConnection;

public class AtomikosXAPooledConnection
extends AbstractXPooledConnection<Connection> {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosXAPooledConnection.class);
    private static boolean isJdbc4Compatible = true;
    private SessionHandleState sessionHandleState;
    private XAConnection xaConnection;
    private Connection connection;
    private final boolean localTransactionMode;

    public AtomikosXAPooledConnection(XAConnection xaConnection, JdbcTransactionalResource jdbcTransactionalResource, ConnectionPoolProperties props) throws SQLException {
        super(props);
        this.xaConnection = xaConnection;
        this.connection = xaConnection.getConnection();
        this.sessionHandleState = new SessionHandleState((XATransactionalResource)jdbcTransactionalResource, xaConnection.getXAResource());
        this.sessionHandleState.registerSessionHandleStateChangeListener(new SessionHandleStateChangeListener(){

            public void onTerminated() {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("SessionHandleState terminated, firing XPooledConnectionTerminated event for " + (Object)((Object)AtomikosXAPooledConnection.this));
                }
                AtomikosXAPooledConnection.this.updateLastTimeReleased();
                AtomikosXAPooledConnection.this.fireOnXPooledConnectionTerminated();
            }
        });
        this.localTransactionMode = props.getLocalTransactionMode();
    }

    public synchronized void doDestroy(boolean reap) {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.logWarning((Object)((Object)this) + ": error closing Connection: ", (Throwable)e);
            }
        }
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (SQLException e) {
                LOGGER.logWarning((Object)((Object)this) + ": error closing XAConnection: ", (Throwable)e);
            }
        }
        this.connection = null;
        this.xaConnection = null;
    }

    protected Connection doCreateConnectionProxy() throws CreateConnectionException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace((Object)((Object)this) + ": creating connection proxy...");
        }
        JdbcConnectionProxyHelper.setIsolationLevel(this.connection, this.getDefaultIsolationLevel());
        AtomikosJdbcConnectionProxy proxy = new AtomikosJdbcConnectionProxy(this.connection, this.sessionHandleState, this.localTransactionMode);
        return (Connection)proxy.createDynamicProxy();
    }

    protected void testUnderlyingConnection() throws CreateConnectionException {
        if (this.isErroneous()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection is erroneous");
        }
        if (this.maxLifetimeExceeded()) {
            throw new CreateConnectionException((Object)((Object)this) + ": connection too old - will be replaced");
        }
        int queryTimeout = Math.max(0, this.getBorrowConnectionTimeout());
        String testQuery = this.getTestQuery();
        if (testQuery != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": testing connection with query [" + testQuery + "]");
            }
            try {
                PreparedStatement stmt = this.connection.prepareStatement(testQuery);
                stmt.setQueryTimeout(queryTimeout);
                stmt.execute();
                stmt.close();
            }
            catch (Exception e) {
                throw new CreateConnectionException("Error executing testQuery", e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": connection tested OK");
            }
        } else if (isJdbc4Compatible) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace((Object)((Object)this) + ": testing connection with connection.isValid()");
            }
            try {
                if (!this.connection.isValid(queryTimeout)) {
                    throw new CreateConnectionException("Connection no longer valid");
                }
            }
            catch (CreateConnectionException e) {
                throw e;
            }
            catch (Throwable e) {
                LOGGER.logWarning("JDBC connection validation not supported by DBMS driver - please set a testQuery if validation is desired...", e);
                isJdbc4Compatible = false;
            }
        }
    }

    public boolean isAvailable() {
        boolean available = false;
        available = this.sessionHandleState.isTerminated() && this.xaConnection != null;
        return available;
    }

    public boolean isErroneous() {
        return this.sessionHandleState.isErroneous();
    }

    public String toString() {
        return "atomikosXAPooledConnection with " + this.sessionHandleState;
    }

    public boolean canBeRecycledForCallingThread() {
        CompositeTransaction current;
        boolean ret = false;
        CompositeTransactionManager tm = Configuration.getCompositeTransactionManager();
        if (tm != null && (current = tm.getCompositeTransaction()) != null && TransactionManagerImp.isJtaTransaction((CompositeTransaction)current)) {
            ret = this.sessionHandleState.isInactiveInTransaction(current);
        }
        return ret;
    }
}

