/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.jms.AbstractBridge;
import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class Bridge
extends AbstractBridge {
    protected Message bridgeMessage(Message message) throws JMSException {
        TextMessage ret = null;
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            TextMessage m = this.createTextMessage();
            m.setText(text);
            ret = m;
        } else if (message instanceof MapMessage) {
            MapMessage m = this.createMapMessage();
            MapMessage src = (MapMessage)message;
            Enumeration names = src.getMapNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Object val = src.getObject(name);
                m.setObject(name, val);
            }
            ret = m;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage m = this.createObjectMessage();
            Serializable content = ((ObjectMessage)message).getObject();
            m.setObject(content);
            ret = m;
        } else if (message instanceof StreamMessage) {
            StreamMessage m = this.createStreamMessage();
            StreamMessage src = (StreamMessage)message;
            Object lastRead = null;
            do {
                lastRead = null;
                try {
                    lastRead = src.readObject();
                    if (lastRead == null) continue;
                    m.writeObject(lastRead);
                }
                catch (MessageEOFException noMoreData) {
                    // empty catch block
                }
            } while (lastRead != null);
            ret = m;
        } else if (message instanceof BytesMessage) {
            BytesMessage m = this.createBytesMessage();
            BytesMessage src = (BytesMessage)message;
            int LEN = 100;
            byte[] buf = new byte[100];
            int bytesRead = src.readBytes(buf);
            while (bytesRead >= 0) {
                m.writeBytes(buf, 0, bytesRead);
                bytesRead = src.readBytes(buf);
            }
            ret = m;
        } else {
            ret = this.createTextMessage();
        }
        this.copyHeadersAndProperties(message, (Message)ret);
        return ret;
    }
}

