/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.DefaultJtaMessageConsumer;
import com.atomikos.jms.DefaultJtaMessageProducer;
import com.atomikos.jms.JtaTopicSubscriber;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

class DefaultJtaSession
implements Session {
    private XASession session_;
    private TransactionalResource res_;
    private XAResource xares_;

    DefaultJtaSession(XASession session, TransactionalResource res, XAResource xares) {
        this.session_ = session;
        this.res_ = res;
        this.xares_ = xares;
    }

    protected Session getSession() {
        Session ret = null;
        try {
            ret = this.session_.getSession();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected TransactionalResource getTransactionalResource() {
        return this.res_;
    }

    protected XAResource getXAResource() {
        return this.xares_;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getSession().createTemporaryQueue();
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.getSession().createBrowser(queue, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getSession().createBrowser(queue);
    }

    public Queue createQueue(String name) throws JMSException {
        return this.getSession().createQueue(name);
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("XA Session: commit not allowed on session");
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("XA Session: rollback not allowed on session");
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public void run() {
        this.getSession().run();
    }

    public void setMessageListener(MessageListener l) throws JMSException {
        this.getSession().setMessageListener(l);
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getSession().getMessageListener();
    }

    public void recover() throws JMSException {
        throw new IllegalStateException("Transacted session: recover not allowed");
    }

    public void close() throws JMSException {
        Configuration.logDebug((String)"Closing JMS session...");
        this.session_.close();
        Configuration.logInfo((String)"Closed JMS session");
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.getSession().createTextMessage(text);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public ObjectMessage createObjectMessage(Serializable o) throws JMSException {
        return this.getSession().createObjectMessage(o);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getSession().getAcknowledgeMode();
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.getSession().createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriber s = this.getSession().createDurableSubscriber(topic, name);
        return new JtaTopicSubscriber(s, this.res_, this.xares_);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        TopicSubscriber s = this.getSession().createDurableSubscriber(topic, name, selector, noLocal);
        return new JtaTopicSubscriber(s, this.res_, this.xares_);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getSession().createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.getSession().unsubscribe(name);
    }

    public MessageProducer createProducer(Destination dest) throws JMSException {
        MessageProducer mp = this.getSession().createProducer(dest);
        return new DefaultJtaMessageProducer(mp, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        MessageConsumer mc = this.getSession().createConsumer(dest);
        return new DefaultJtaMessageConsumer(mc, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination dest, String messageSelector) throws JMSException {
        MessageConsumer mc = this.getSession().createConsumer(dest, messageSelector);
        return new DefaultJtaMessageConsumer(mc, this.res_, this.xares_);
    }

    public MessageConsumer createConsumer(Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        MessageConsumer mc = this.getSession().createConsumer(dest, messageSelector, noLocal);
        return new DefaultJtaMessageConsumer(mc, this.res_, this.xares_);
    }
}

