/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public abstract class MessageConsumerSession {
    private static final int DEFAULT_TIMEOUT = 30;
    private AbstractConnectionFactoryBean factory;
    private String user;
    private String password;
    private Destination destination;
    private int timeout = 30;
    private boolean notifyListenerOnClose;
    private String messageSelector;
    private boolean daemonThreads;
    private transient MessageListener listener;
    protected transient Thread current;
    private UserTransactionManager tm = new UserTransactionManager();
    private boolean active;
    private ExceptionListener exceptionListener;

    protected MessageConsumerSession() {
    }

    protected abstract String getSubscriberName();

    protected abstract void setSubscriberName(String var1);

    protected abstract void setNoLocal(boolean var1);

    protected abstract boolean getNoLocal();

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean bean) {
        this.factory = bean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.factory;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setTransactionTimeout(int seconds) {
        this.timeout = seconds;
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startListening() throws JMSException, SystemException {
        if (this.active) {
            throw new IllegalStateException("MessageConsumerSession: startListening() called a second time without stopListening() in between");
        }
        if (this.destination == null) {
            throw new JMSException("Please set the Destination first");
        }
        if (this.factory == null) {
            throw new JMSException("Please set the ConnectionFactory first");
        }
        this.tm.setStartupTransactionService(true);
        this.tm.init();
        this.tm.setStartupTransactionService(false);
        this.active = true;
        this.startNewThread();
        StringBuffer msg = new StringBuffer();
        msg.append("MessageConsumerSession configured with [");
        msg.append("user=").append(this.getUser()).append(", ");
        msg.append("password=").append(this.password).append(", ");
        msg.append("transactionTimeout=").append(this.getTransactionTimeout()).append(", ");
        msg.append("destination=").append(this.getDestinationName()).append(", ");
        msg.append("notifyListenerOnClose= ").append(this.getNotifyListenerOnClose()).append(", ");
        msg.append("messageSelector=").append(this.getMessageSelector()).append(", ");
        msg.append("daemonThreads=").append(this.getDaemonThreads()).append(", ");
        msg.append("messageListener=").append(this.getMessageListener()).append(", ");
        msg.append("exceptionListener=").append(this.getExceptionListener()).append(", ");
        msg.append("connectionFactory=").append(this.getAbstractConnectionFactoryBean());
        msg.append("]");
        Configuration.logDebug((String)msg.toString());
    }

    protected abstract String getDestinationName();

    protected void startNewThread() {
        if (this.active) {
            this.current = new ReceiverThread();
            this.current.setDaemon(this.daemonThreads);
            this.current.start();
            Configuration.logDebug((String)("MessageConsumerSession: started new thread: " + this.current));
        }
    }

    private synchronized void notifyExceptionListener(JMSException e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e);
        }
    }

    public void stopListening() {
        this.current = null;
        this.tm.close();
        this.active = false;
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    class ReceiverThread
    extends Thread {
        private Connection connection;
        private Session session;

        private ReceiverThread() {
        }

        private synchronized MessageConsumer refresh() throws JMSException {
            Object ret = null;
            this.connection = MessageConsumerSession.this.user != null ? MessageConsumerSession.this.factory.createConnection(MessageConsumerSession.this.user, MessageConsumerSession.this.password) : MessageConsumerSession.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(true, 0);
            String subscriberName = MessageConsumerSession.this.getSubscriberName();
            ret = subscriberName == null ? this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal()) : this.session.createDurableSubscriber((Topic)MessageConsumerSession.this.destination, subscriberName, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal());
            return ret;
        }

        private synchronized void close() {
            if (this.session != null) {
                try {
                    this.session.close();
                    this.session = null;
                }
                catch (JMSException e) {
                    Configuration.logInfo((String)"MessageConsumerSession: Error closing JMS session", (Throwable)e);
                    Configuration.logInfo((String)"MessageConsumerSession: linked exception is ", (Throwable)e.getLinkedException());
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (JMSException e) {
                    Configuration.logInfo((String)"MessageConsumerSession: Error closing JMS connection", (Throwable)e);
                    Configuration.logInfo((String)"MessageConsumerSession: linked exception is ", (Throwable)e.getLinkedException());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            MessageConsumer receiver = null;
            try {
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.timeout);
            }
            catch (SystemException e) {
                Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread while setting transaction timeout", (Throwable)e);
            }
            Configuration.logInfo((String)"MessageConsumerSession: Starting JMS listener thread.");
            while (Thread.currentThread() == MessageConsumerSession.this.current) {
                Exception fatal2222;
                SystemException err2222;
                Configuration.logDebug((String)"MessageConsumerSession: JMS listener thread iterating...");
                boolean refresh = false;
                boolean commit = true;
                Message msg = null;
                if (receiver == null) {
                    receiver = this.refresh();
                }
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.timeout);
                if (MessageConsumerSession.this.tm.getTransaction() != null) {
                    Configuration.logWarning((String)("MessageConsumerSession: Detected pending transaction: " + MessageConsumerSession.this.tm.getTransaction()));
                    throw new IllegalStateException("Can't reuse listener thread with pending transaction!");
                }
                MessageConsumerSession.this.tm.begin();
                msg = receiver.receive((long)(MessageConsumerSession.this.timeout * 1000 / 2));
                try {
                    if (msg != null && MessageConsumerSession.this.listener != null && Thread.currentThread() == MessageConsumerSession.this.current) {
                        Configuration.logInfo((String)("MessageConsumerSession: Consuming message: " + msg.toString()));
                        MessageConsumerSession.this.listener.onMessage(msg);
                        Configuration.logDebug((String)("MessageConsumerSession: Consumed message: " + msg.toString()));
                    } else {
                        commit = false;
                    }
                }
                catch (Exception e) {
                    Configuration.logInfo((String)("MessageConsumerSession: Error during JMS processing of message " + msg.toString() + " - rolling back."), (Throwable)e);
                    commit = false;
                }
                Object var7_10 = null;
                try {
                    if (commit) {
                        MessageConsumerSession.this.tm.commit();
                    } else {
                        MessageConsumerSession.this.tm.rollback();
                    }
                }
                catch (RollbackException e2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (HeuristicMixedException e2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (HeuristicRollbackException e2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                }
                catch (Exception e2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                    try {
                        Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                        MessageConsumerSession.this.tm.suspend();
                    }
                    catch (SystemException err2222) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                            MessageConsumerSession.this.startNewThread();
                        }
                        catch (Exception fatal2222) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                            MessageConsumerSession.this.stopListening();
                        }
                    }
                }
                if (!refresh) continue;
                receiver = null;
                this.close();
                {
                    continue;
                    catch (JMSException e) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Throwable)e);
                        Exception linkedException = e.getLinkedException();
                        if (linkedException != null) {
                            Configuration.logWarning((String)"Linked JMS exception is: ", (Throwable)linkedException);
                        }
                        refresh = true;
                        commit = false;
                        MessageConsumerSession.this.notifyExceptionListener(e);
                        var7_10 = null;
                        try {
                            if (commit) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicMixedException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicRollbackException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (Exception e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException err2222) {
                                Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception fatal2222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!refresh) continue;
                        receiver = null;
                        this.close();
                        continue;
                    }
                    catch (Exception e) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Throwable)e);
                        refresh = true;
                        commit = false;
                        JMSException listenerError = new JMSException("Unexpected error - please see Atomikos console file for more info");
                        MessageConsumerSession.this.notifyExceptionListener(listenerError);
                        var7_10 = null;
                        try {
                            if (commit) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicMixedException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (HeuristicRollbackException e2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                        }
                        catch (Exception e2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException err2222) {
                                Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception fatal2222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!refresh) continue;
                        receiver = null;
                        this.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    try {
                        if (commit) {
                            MessageConsumerSession.this.tm.commit();
                        } else {
                            MessageConsumerSession.this.tm.rollback();
                        }
                    }
                    catch (RollbackException e2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (HeuristicMixedException e2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (HeuristicRollbackException e2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Throwable)e2);
                    }
                    catch (Exception e2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Throwable)e2);
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                            MessageConsumerSession.this.tm.suspend();
                        }
                        catch (SystemException err2222) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Throwable)err2222);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                MessageConsumerSession.this.startNewThread();
                            }
                            catch (Exception fatal2222) {
                                Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Throwable)e2);
                                MessageConsumerSession.this.stopListening();
                            }
                        }
                    }
                    if (refresh) {
                        receiver = null;
                        this.close();
                    }
                    throw throwable;
                }
            }
            Configuration.logInfo((String)"MessageConsumerSession: JMS listener thread exiting.");
            if (MessageConsumerSession.this.listener != null && MessageConsumerSession.this.current == null && MessageConsumerSession.this.notifyListenerOnClose) {
                MessageConsumerSession.this.listener.onMessage(null);
            }
        }
    }
}

