/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.util.SerializableObjectFactory;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class J2eeTransactionManager
implements TransactionManager,
Serializable,
Referenceable {
    private transient TransactionManagerImp tm;

    private void checkSetup() throws SystemException {
        this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
        if (this.tm == null) {
            throw new RuntimeException("Transaction Service not running?");
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.checkSetup();
        this.tm.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.commit();
    }

    public int getStatus() throws SystemException {
        this.checkSetup();
        return this.tm.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        this.checkSetup();
        return this.tm.getTransaction();
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.resume(tx);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.checkSetup();
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.checkSetup();
        this.tm.setRollbackOnly();
    }

    public void setTransactionTimeout(int secs) throws SystemException {
        this.checkSetup();
        this.tm.setTransactionTimeout(secs);
    }

    public Transaction suspend() throws SystemException {
        this.checkSetup();
        return this.tm.suspend();
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }
}

