/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jms;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.util.Stack;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class JmsTransactionalResource
extends XATransactionalResource {
    private XAConnectionFactory factory_;
    private XAConnection conn_;

    public JmsTransactionalResource(String name, XAConnectionFactory factory) {
        super(name);
        this.factory_ = factory;
        this.conn_ = null;
    }

    public JmsTransactionalResource(String name, XAConnectionFactory qFactory, XidFactory xidFactory) {
        super(name, xidFactory);
        this.factory_ = qFactory;
        this.conn_ = null;
    }

    protected synchronized XAResource refreshXAConnection() throws ResourceException {
        XAResource res = null;
        if (this.conn_ != null) {
            try {
                this.conn_.close();
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        try {
            this.conn_ = this.factory_.createXAConnection();
            XASession session = this.conn_.createXASession();
            res = session.getXAResource();
        }
        catch (JMSException jms) {
            Stack<JMSException> errors = new Stack<JMSException>();
            errors.push(jms);
            throw new ResourceException("Error in getting XA resource", errors);
        }
        return res;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.conn_ != null) {
                this.conn_.close();
            }
        }
        catch (JMSException err) {
            throw new ResourceException(err.getMessage());
        }
    }
}

