/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.standalone;

import com.atomikos.icatch.Extent;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.BaseTransactionManager;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.util.UniqueIdMgr;
import java.util.Properties;

class StandAloneTransactionManager
extends BaseTransactionManager {
    private static final Logger LOGGER = LoggerFactory.createLogger(StandAloneTransactionManager.class);
    TransactionServiceImp service_;

    StandAloneTransactionManager(String tmName, StateRecoveryManager srecmgr, String outputDirPath, long maxTimeout, int maxActives, boolean single_threaded_2pc) {
        UniqueIdMgr idmgr = null;
        idmgr = new UniqueIdMgr(tmName, outputDirPath);
        if (idmgr.getMaxIdLengthInBytes() > 64) {
            String msg = "Value too long :" + tmName;
            LOGGER.logWarning(msg);
            throw new SysException(msg);
        }
        this.service_ = new TransactionServiceImp(tmName, srecmgr, idmgr, maxTimeout, maxActives, single_threaded_2pc);
    }

    TransactionServiceImp getTransactionService() {
        return this.service_;
    }

    public synchronized void init(Properties properties) throws SysException {
        super.init(this.service_, properties);
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.service_.shutdown(force);
    }

    public void addExtent(Extent extent) throws SysException {
        throw new SysException("Not implemented");
    }

    public Extent terminated(boolean commit) throws SysException, RollbackException {
        throw new SysException("Not implemented");
    }
}

