/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jmx;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.jmx.JmxTransactionalResourceMBean;
import com.atomikos.datasource.xa.jmx.XAResourceConfig;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxTransactionalResource
implements JmxTransactionalResourceMBean,
MBeanRegistration {
    private XATransactionalResource resource;
    private XAResourceConfig config;
    private String localName;

    public JmxTransactionalResource(XATransactionalResource resource, XAResourceConfig config, String localName) {
        this.resource = resource;
        this.config = config;
        this.localName = localName;
        this.setUseWeakCompare(config.usesWeakCompare());
        this.setAcceptAllXAResources(config.acceptsAllXAResources());
    }

    @Override
    public boolean getUseWeakCompare() {
        return this.resource.usesWeakCompare();
    }

    @Override
    public void setUseWeakCompare(boolean value) {
        this.resource.useWeakCompare(value);
        this.config.setUseWeakCompare(value);
    }

    @Override
    public ObjectName preRegister(MBeanServer arg0, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName("atomikos.resources", "name", this.resource.getName());
        }
        return name;
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public boolean getAcceptAllXAResources() {
        return this.resource.acceptsAllXAResources();
    }

    @Override
    public void setAcceptAllXAResources(boolean val) {
        this.resource.setAcceptAllXAResources(val);
        this.config.setAcceptAllXAResources(val);
    }
}

