/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.xa;

import com.atomikos.datasource.xa.RecoveryScan;
import com.atomikos.datasource.xa.XID;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.xa.XaRecoveryLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XaResourceRecoveryManager {
    private static final Logger LOGGER = LoggerFactory.createLogger(XaResourceRecoveryManager.class);
    private XaRecoveryLog log;
    private RecoveryScan.XidSelector xidSelector;
    private boolean autoForget = true;
    private static XaResourceRecoveryManager instance;

    private XaResourceRecoveryManager(XaRecoveryLog log, final String tmUniqueName) {
        this.log = log;
        this.xidSelector = new RecoveryScan.XidSelector(){

            @Override
            public boolean selects(Xid vendorXid) {
                boolean ret = false;
                String branch = new String(vendorXid.getBranchQualifier());
                XID xid = this.wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(vendorXid);
                if (branch.startsWith(tmUniqueName)) {
                    ret = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("Resource " + tmUniqueName + " recovering XID: " + xid);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("Resource " + tmUniqueName + ": XID " + xid + " with branch " + branch + " is not under my responsibility");
                }
                return ret;
            }

            private XID wrapWithOurOwnXidToHaveCorrectEqualsAndHashCode(Xid xid) {
                return new XID(xid);
            }
        };
    }

    public void recover(XAResource xaResource) {
        List<XID> xidsToRecover = this.retrievePreparedXidsFromXaResource(xaResource);
        try {
            Set<XID> xidsToCommit = this.retrieveExpiredCommittingXidsFromLog();
            for (XID xid : xidsToRecover) {
                if (xidsToCommit.contains(xid)) {
                    this.replayCommit(xid, xaResource);
                    continue;
                }
                this.attemptPresumedAbort(xid, xaResource);
            }
        }
        catch (LogException couldNotRetrieveCommittingXids) {
            LOGGER.logWarning("Transient error while recovering - will retry later...", (Throwable)couldNotRetrieveCommittingXids);
        }
    }

    private void replayCommit(XID xid, XAResource xaResource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("Replaying commit of xid: " + xid);
        }
        try {
            xaResource.commit(xid, false);
            this.log.terminated(xid);
        }
        catch (XAException e) {
            if (this.alreadyHeuristicallyTerminatedByResource(e)) {
                this.handleHeuristicTerminationByResource(xid, xaResource, e, true);
            }
            if (this.xidTerminatedInResourceByConcurrentCommit(e)) {
                this.log.terminated(xid);
            }
            LOGGER.logWarning("Transient error while replaying commit - will retry later...", (Throwable)e);
        }
    }

    private void handleHeuristicTerminationByResource(XID xid, XAResource xaResource, XAException e, boolean commitDesired) {
        try {
            this.notifyLogOfHeuristic(xid, e, commitDesired);
            this.forgetXidInXaResourceIfAllowed(xid, xaResource);
        }
        catch (LogException transientLogWriteException) {
            LOGGER.logWarning("Failed to log heuristic termination of Xid: " + xid + " - ignoring to retry later", (Throwable)transientLogWriteException);
        }
    }

    private boolean xidTerminatedInResourceByConcurrentRollback(XAException e) {
        return this.xidNoLongerKnownByResource(e);
    }

    private boolean alreadyHeuristicallyTerminatedByResource(XAException e) {
        boolean ret = false;
        switch (e.errorCode) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                ret = true;
            }
        }
        return ret;
    }

    private boolean xidTerminatedInResourceByConcurrentCommit(XAException e) {
        return this.xidNoLongerKnownByResource(e);
    }

    private boolean xidNoLongerKnownByResource(XAException e) {
        boolean ret = false;
        switch (e.errorCode) {
            case -5: 
            case -4: {
                ret = true;
            }
        }
        return ret;
    }

    private void forgetXidInXaResourceIfAllowed(Xid xid, XAResource xaResource) {
        try {
            if (this.autoForget) {
                xaResource.forget(xid);
            }
        }
        catch (XAException e) {
            LOGGER.logWarning("Unexpected error during forget - ignoring", (Throwable)e);
        }
    }

    private Set<XID> retrieveExpiredCommittingXidsFromLog() throws LogException {
        return this.log.getExpiredCommittingXids();
    }

    private List<XID> retrievePreparedXidsFromXaResource(XAResource xaResource) {
        ArrayList<XID> ret = new ArrayList();
        try {
            ret = RecoveryScan.recoverXids(xaResource, this.xidSelector);
        }
        catch (XAException e) {
            LOGGER.logWarning("Error while retrieving xids from resource - will retry later...", (Throwable)e);
        }
        return ret;
    }

    private void attemptPresumedAbort(XID xid, XAResource xaResource) {
        block8: {
            try {
                this.log.presumedAborting(xid);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("Presumed abort of xid: " + xid);
                }
                try {
                    xaResource.rollback(xid);
                    this.log.terminated(xid);
                }
                catch (XAException e) {
                    if (this.alreadyHeuristicallyTerminatedByResource(e)) {
                        this.handleHeuristicTerminationByResource(xid, xaResource, e, false);
                        break block8;
                    }
                    if (this.xidTerminatedInResourceByConcurrentRollback(e)) {
                        this.log.terminated(xid);
                        break block8;
                    }
                    LOGGER.logWarning("Unexpected exception during recovery - ignoring to retry later...", (Throwable)e);
                }
            }
            catch (IllegalStateException presumedAbortNotAllowedInCurrentLogState) {
            }
            catch (LogException logWriteException) {
                LOGGER.logWarning("log write failed for Xid: " + xid + ", ignoring to retry later", (Throwable)logWriteException);
            }
        }
    }

    private void notifyLogOfHeuristic(XID xid, XAException e, boolean commitDesired) throws LogException {
        switch (e.errorCode) {
            case 8: {
                this.log.terminatedWithHeuristicHazardByResource(xid);
                break;
            }
            case 7: {
                if (commitDesired) {
                    this.log.terminated(xid);
                    break;
                }
                this.log.terminatedWithHeuristicCommitByResource(xid);
                break;
            }
            case 5: {
                this.log.terminatedWithHeuristicMixedByResource(xid);
                break;
            }
            case 6: {
                if (commitDesired) {
                    this.log.terminatedWithHeuristicRollbackByResource(xid);
                    break;
                }
                this.log.terminated(xid);
                break;
            }
        }
    }

    public void setXaRecoveryLog(XaRecoveryLog log) {
        this.log = log;
    }

    public void setXidSelector(RecoveryScan.XidSelector xidSelector) {
        this.xidSelector = xidSelector;
    }

    public void setAutoForgetHeuristicsOnRecovery(boolean value) {
        this.autoForget = value;
    }

    public static XaResourceRecoveryManager getInstance() {
        return instance;
    }

    public static void installXaResourceRecoveryManager(XaRecoveryLog xaRecoveryLog, String tmUniqueName) {
        instance = xaRecoveryLog == null ? null : new XaResourceRecoveryManager(xaRecoveryLog, tmUniqueName);
    }
}

