/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.template;

import com.atomikos.icatch.jta.template.TransactionTemplate;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;

class RequiresNewTemplate
extends TransactionTemplate {
    public RequiresNewTemplate(TransactionManager utm, int timeout) {
        super(utm, timeout);
    }

    @Override
    public <T> T execute(Callable<T> work) throws Exception {
        T ret = null;
        Transaction suspendedTransaction = null;
        try {
            suspendedTransaction = this.utm.suspend();
            this.beginTransaction();
            ret = work.call();
            this.utm.commit();
        }
        catch (Exception e) {
            this.utm.rollback();
            throw e;
        }
        catch (Throwable e) {
            this.utm.rollback();
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (suspendedTransaction != null) {
                this.utm.resume(suspendedTransaction);
            }
        }
        return ret;
    }
}

