/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import java.util.Hashtable;
import java.util.Stack;

class CompositeTerminatorImp
implements CompositeTerminator {
    protected CoordinatorImp coordinator_ = null;
    protected CompositeTransactionImp transaction_ = null;
    protected TransactionService ts_ = null;

    CompositeTerminatorImp(TransactionService ts, CompositeTransactionImp transaction, CoordinatorImp coordinator) {
        this.ts_ = ts;
        this.coordinator_ = coordinator;
        this.transaction_ = transaction;
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        Stack<Exception> errors = new Stack<Exception>();
        this.transaction_.doCommit();
        this.setSiblingInfoForIncoming1pcRequestFromRemoteClient();
        if (this.transaction_.isRoot()) {
            try {
                this.coordinator_.terminate(true);
            }
            catch (RollbackException rb) {
                throw rb;
            }
            catch (HeurHazardException hh) {
                throw hh;
            }
            catch (HeurRollbackException hr) {
                throw hr;
            }
            catch (HeurMixedException hm) {
                throw hm;
            }
            catch (SysException se) {
                throw se;
            }
            catch (Exception e) {
                errors.push(e);
                throw new SysException("Unexpected error: " + e.getMessage(), errors);
            }
        }
    }

    private void setSiblingInfoForIncoming1pcRequestFromRemoteClient() {
        TransactionControl control = this.transaction_.getTransactionControl();
        Hashtable cascadelist = control.getExtent().getRemoteParticipants();
        this.coordinator_.setGlobalSiblingCount(this.coordinator_.getLocalSiblingCount());
        this.coordinator_.setCascadeList(cascadelist);
    }

    public void rollback() throws IllegalStateException, SysException {
        Stack<Exception> errors = new Stack<Exception>();
        this.transaction_.doRollback();
        if (this.transaction_.isRoot()) {
            try {
                this.coordinator_.terminate(false);
            }
            catch (Exception e) {
                errors.push(e);
                throw new SysException("Unexpected error in rollback: " + e.getMessage(), errors);
            }
        }
    }
}

