/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CommitMessage;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ForgetMessage;
import com.atomikos.icatch.imp.ForgetResult;
import com.atomikos.icatch.imp.HeurAbortedStateHandler;
import com.atomikos.icatch.imp.HeurCommittedStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.HeurMixedStateHandler;
import com.atomikos.icatch.imp.Propagator;
import com.atomikos.icatch.imp.RollbackMessage;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.imp.TerminationResult;
import com.atomikos.icatch.imp.thread.InterruptedExceptionHelper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

abstract class CoordinatorStateHandler
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5510459174124363958L;
    private static final Logger LOGGER = LoggerFactory.createLogger(CoordinatorStateHandler.class);
    private static final int THREADS = 1;
    private transient CoordinatorImp coordinator_;
    private Hashtable readOnlyTable_;
    private transient Propagator propagator_;
    private transient Stack replayStack_;
    private Boolean committed_;
    private transient Dictionary cascadeList_;
    private Hashtable heuristicMap_;

    protected CoordinatorStateHandler(CoordinatorImp coordinator) {
        this.coordinator_ = coordinator;
        this.replayStack_ = new Stack();
        this.readOnlyTable_ = new Hashtable();
        this.committed_ = null;
        this.heuristicMap_ = new Hashtable();
        this.heuristicMap_.put(TxState.HEUR_HAZARD, new Stack());
        this.heuristicMap_.put(TxState.HEUR_MIXED, new Stack());
        this.heuristicMap_.put(TxState.HEUR_ABORTED, new Stack());
        this.heuristicMap_.put(TxState.HEUR_COMMITTED, new Stack());
        this.heuristicMap_.put(TxState.TERMINATED, new Stack());
    }

    protected CoordinatorStateHandler(CoordinatorStateHandler other) {
        this.coordinator_ = other.coordinator_;
        this.propagator_ = other.propagator_;
        this.replayStack_ = other.replayStack_;
        this.readOnlyTable_ = other.readOnlyTable_;
        this.committed_ = other.committed_;
        this.cascadeList_ = other.cascadeList_;
        this.heuristicMap_ = other.heuristicMap_;
    }

    void setCommitted() {
        this.committed_ = new Boolean(true);
    }

    public Object clone() {
        CoordinatorStateHandler clone = null;
        try {
            clone = (CoordinatorStateHandler)super.clone();
            clone.readOnlyTable_ = (Hashtable)this.readOnlyTable_.clone();
            clone.heuristicMap_ = new Hashtable();
            Stack hazStack = (Stack)this.heuristicMap_.get(TxState.HEUR_HAZARD);
            Stack mixStack = (Stack)this.heuristicMap_.get(TxState.HEUR_MIXED);
            Stack comStack = (Stack)this.heuristicMap_.get(TxState.HEUR_COMMITTED);
            Stack abStack = (Stack)this.heuristicMap_.get(TxState.HEUR_ABORTED);
            Stack termStack = (Stack)this.heuristicMap_.get(TxState.TERMINATED);
            clone.heuristicMap_.put(TxState.HEUR_HAZARD, hazStack.clone());
            clone.heuristicMap_.put(TxState.HEUR_MIXED, mixStack.clone());
            clone.heuristicMap_.put(TxState.HEUR_COMMITTED, comStack.clone());
            clone.heuristicMap_.put(TxState.HEUR_ABORTED, abStack.clone());
            clone.heuristicMap_.put(TxState.TERMINATED, termStack.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("CoordinatorStateHandler: clone failure :" + e.getMessage());
        }
        return clone;
    }

    protected void addToHeuristicMap(Participant p, Object state) {
        Stack stack = (Stack)this.heuristicMap_.get(state);
        stack.push(p);
    }

    protected void addToHeuristicMap(Hashtable participants) {
        Enumeration parts = participants.keys();
        while (parts.hasMoreElements()) {
            Participant next = (Participant)parts.nextElement();
            Object state = participants.get(next);
            this.addToHeuristicMap(next, state);
        }
    }

    protected HeuristicMessage[] getHeuristicMessages(Object heuristicState) {
        Vector<HeuristicMessage> msgs = new Vector<HeuristicMessage>();
        Stack parts = (Stack)this.heuristicMap_.get(heuristicState);
        if (parts == null) {
            throw new RuntimeException("Error: getHeuristicMessages for non-mapped heuristic state: " + heuristicState);
        }
        Enumeration enumm = parts.elements();
        while (enumm.hasMoreElements()) {
            Participant p = (Participant)enumm.nextElement();
            HeuristicMessage[] errs = p.getHeuristicMessages();
            if (errs == null) continue;
            for (int i = 0; i < errs.length; ++i) {
                msgs.addElement(errs[i]);
            }
        }
        HeuristicMessage[] template = new HeuristicMessage[]{};
        return msgs.toArray(template);
    }

    protected HeuristicMessage[] getHeuristicMessages() {
        Vector<HeuristicMessage> msgs = new Vector<HeuristicMessage>();
        Enumeration enumm = this.coordinator_.getParticipants().elements();
        while (enumm.hasMoreElements()) {
            Participant p = (Participant)enumm.nextElement();
            HeuristicMessage[] errs = p.getHeuristicMessages();
            if (errs == null) continue;
            for (int i = 0; i < errs.length; ++i) {
                msgs.addElement(errs[i]);
            }
        }
        HeuristicMessage[] template = new HeuristicMessage[]{};
        return msgs.toArray(template);
    }

    protected CoordinatorImp getCoordinator() {
        return this.coordinator_;
    }

    protected long getRollbackTicks() {
        return 0L;
    }

    protected Stack getReplayStack() {
        return this.replayStack_;
    }

    protected Hashtable getReadOnlyTable() {
        return this.readOnlyTable_;
    }

    protected Dictionary getCascadeList() {
        return this.cascadeList_;
    }

    protected Propagator getPropagator() {
        return this.propagator_;
    }

    protected Boolean getCommitted() {
        return this.committed_;
    }

    protected boolean isCommitted() {
        if (this.committed_ == null) {
            return false;
        }
        return this.committed_;
    }

    protected void setReadOnlyTable(Hashtable table) {
        this.readOnlyTable_ = table;
    }

    protected void activate() {
        boolean threaded;
        boolean bl = threaded = !this.coordinator_.prefersSingleThreaded2PC();
        if (this.propagator_ == null) {
            this.propagator_ = new Propagator(threaded);
        }
    }

    protected void recover(CoordinatorImp coordinator) {
        this.coordinator_ = coordinator;
        this.replayStack_ = new Stack();
    }

    protected void dispose() {
        this.propagator_ = null;
    }

    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (!this.replayStack_.contains(participant)) {
            this.replayStack_.push(participant);
        }
        return this.committed_;
    }

    protected void addAllForReplay(Collection participants) {
        for (Participant p : participants) {
            this.replayCompletion(p);
        }
    }

    protected void setCascadeList(Dictionary allParticipants) {
        this.cascadeList_ = allParticipants;
    }

    protected abstract void onTimeout();

    abstract Object getState();

    abstract void setGlobalSiblingCount(int var1);

    protected abstract int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException;

    protected abstract HeuristicMessage[] commit(boolean var1) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException;

    protected abstract HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException;

    protected HeuristicMessage[] commit(boolean heuristic, boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        Stack<Exception> errors = new Stack<Exception>();
        CoordinatorStateHandler nextStateHandler = null;
        try {
            Vector participants = this.coordinator_.getParticipants();
            int count = participants.size() - this.readOnlyTable_.size();
            TerminationResult commitresult = new TerminationResult(count);
            this.committed_ = new Boolean(true);
            try {
                this.coordinator_.setState(TxState.COMMITTING);
            }
            catch (RuntimeException error) {
                String msg = "Error in committing: " + error.getMessage() + " - rolling back instead";
                LOGGER.logWarning(msg, error);
                try {
                    this.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
                    throw new RollbackException(msg);
                }
                catch (HeurCommitException e) {
                    LOGGER.logWarning("Illegal heuristic commit during rollback:" + e);
                    throw new HeurMixedException(e.getHeuristicMessages());
                }
            }
            Enumeration enumm = participants.elements();
            while (enumm.hasMoreElements()) {
                Participant p = (Participant)enumm.nextElement();
                if (this.readOnlyTable_.containsKey(p)) continue;
                CommitMessage cm = new CommitMessage(p, commitresult, onePhase);
                if (onePhase && this.cascadeList_ != null) {
                    Integer sibnum = (Integer)this.cascadeList_.get(p);
                    if (sibnum != null) {
                        p.setGlobalSiblingCount(sibnum);
                    }
                    p.setCascadeList(this.cascadeList_);
                }
                this.propagator_.submitPropagationMessage(cm);
            }
            commitresult.waitForReplies();
            int res = commitresult.getResult();
            if (res != 0) {
                Hashtable heuristics;
                Hashtable hazards;
                if (res == 2) {
                    hazards = commitresult.getPossiblyIndoubts();
                    heuristics = commitresult.getHeuristicParticipants();
                    this.addToHeuristicMap(heuristics);
                    enumm = participants.elements();
                    while (enumm.hasMoreElements()) {
                        Participant p = (Participant)enumm.nextElement();
                        if (heuristics.containsKey(p)) continue;
                        this.addToHeuristicMap(p, TxState.TERMINATED);
                    }
                    nextStateHandler = new HeurMixedStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                if (res == 6) {
                    nextStateHandler = new TerminatedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new RollbackException("Rolled back already.");
                }
                if (res == 3) {
                    nextStateHandler = new HeurAbortedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurRollbackException(this.getHeuristicMessages());
                }
                if (res == 1) {
                    hazards = commitresult.getPossiblyIndoubts();
                    heuristics = commitresult.getHeuristicParticipants();
                    this.addToHeuristicMap(heuristics);
                    enumm = participants.elements();
                    while (enumm.hasMoreElements()) {
                        Participant p = (Participant)enumm.nextElement();
                        if (heuristics.containsKey(p)) continue;
                        this.addToHeuristicMap(p, TxState.TERMINATED);
                    }
                    nextStateHandler = new HeurHazardStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
            } else {
                nextStateHandler = heuristic ? new HeurCommittedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(nextStateHandler);
            }
        }
        catch (RuntimeException runerr) {
            errors.push(runerr);
            throw new SysException("Error in commit: " + runerr.getMessage(), errors);
        }
        catch (InterruptedException intr) {
            InterruptedExceptionHelper.handleInterruptedException(intr);
            errors.push(intr);
            throw new SysException("Error in commit" + intr.getMessage(), errors);
        }
        return this.getHeuristicMessages();
    }

    protected HeuristicMessage[] rollback(boolean indoubt, boolean heuristic) throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        Stack<Exception> errors = new Stack<Exception>();
        CoordinatorStateHandler nextStateHandler = null;
        try {
            this.coordinator_.setState(TxState.ABORTING);
            this.committed_ = new Boolean(false);
            Vector participants = this.coordinator_.getParticipants();
            int count = participants.size() - this.readOnlyTable_.size();
            TerminationResult rollbackresult = new TerminationResult(count);
            Enumeration enumm = participants.elements();
            while (enumm.hasMoreElements()) {
                Participant p = (Participant)enumm.nextElement();
                if (this.readOnlyTable_.containsKey(p)) continue;
                RollbackMessage rm = new RollbackMessage(p, rollbackresult, indoubt);
                this.propagator_.submitPropagationMessage(rm);
            }
            rollbackresult.waitForReplies();
            int res = rollbackresult.getResult();
            if (indoubt && res != 0) {
                Hashtable hazards;
                if (res == 2) {
                    hazards = rollbackresult.getPossiblyIndoubts();
                    Hashtable heuristics = rollbackresult.getHeuristicParticipants();
                    this.addToHeuristicMap(heuristics);
                    enumm = participants.elements();
                    while (enumm.hasMoreElements()) {
                        Participant p = (Participant)enumm.nextElement();
                        if (heuristics.containsKey(p)) continue;
                        this.addToHeuristicMap(p, TxState.TERMINATED);
                    }
                    nextStateHandler = new HeurMixedStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                if (res == 4) {
                    nextStateHandler = new HeurCommittedStateHandler(this);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurCommitException(this.getHeuristicMessages());
                }
                if (res == 1) {
                    hazards = rollbackresult.getPossiblyIndoubts();
                    Hashtable heuristics = rollbackresult.getHeuristicParticipants();
                    this.addToHeuristicMap(heuristics);
                    enumm = participants.elements();
                    while (enumm.hasMoreElements()) {
                        Participant p = (Participant)enumm.nextElement();
                        if (heuristics.containsKey(p)) continue;
                        this.addToHeuristicMap(p, TxState.TERMINATED);
                    }
                    nextStateHandler = new HeurHazardStateHandler(this, hazards);
                    this.coordinator_.setStateHandler(nextStateHandler);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
            } else {
                nextStateHandler = heuristic ? new HeurAbortedStateHandler(this) : new TerminatedStateHandler(this);
                this.coordinator_.setStateHandler(nextStateHandler);
            }
        }
        catch (RuntimeException runerr) {
            errors.push(runerr);
            throw new SysException("Error in rollback: " + runerr.getMessage(), errors);
        }
        catch (InterruptedException e) {
            InterruptedExceptionHelper.handleInterruptedException(e);
            errors.push(e);
            throw new SysException("Error in rollback: " + e.getMessage(), errors);
        }
        return this.getHeuristicMessages();
    }

    protected void forget() {
        TerminatedStateHandler nextStateHandler = null;
        Vector participants = this.coordinator_.getParticipants();
        int count = participants.size() - this.readOnlyTable_.size();
        Enumeration enumm = participants.elements();
        ForgetResult result = new ForgetResult(count);
        while (enumm.hasMoreElements()) {
            Participant p = (Participant)enumm.nextElement();
            if (this.readOnlyTable_.containsKey(p)) continue;
            ForgetMessage fm = new ForgetMessage(p, result);
            this.propagator_.submitPropagationMessage(fm);
        }
        try {
            result.waitForReplies();
        }
        catch (InterruptedException inter) {
            InterruptedExceptionHelper.handleInterruptedException(inter);
        }
        nextStateHandler = new TerminatedStateHandler(this);
        this.coordinator_.setStateHandler(nextStateHandler);
    }
}

