/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.standalone;

import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.imp.LocalLogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.TSMetaData;
import com.atomikos.icatch.config.imp.TSInitInfoImp;
import com.atomikos.icatch.config.imp.TSMetaDataImp;
import com.atomikos.icatch.imp.BaseTransactionManager;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.jta.AbstractJtaUserTransactionService;
import com.atomikos.icatch.jta.J2eeUserTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServerImp;
import com.atomikos.icatch.standalone.ExportingTransactionManagerImp;
import com.atomikos.icatch.standalone.ImportingTransactionManagerImp;
import com.atomikos.icatch.standalone.StandAloneTransactionManager;
import com.atomikos.icatch.standalone.UserTransactionServiceFactory;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.FileLogStream;
import com.atomikos.persistence.imp.StateRecoveryManagerImp;
import com.atomikos.persistence.imp.StreamObjectLog;
import com.atomikos.persistence.imp.VolatileStateRecoveryManager;
import com.atomikos.util.Atomikos;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import javax.transaction.UserTransaction;

class UserTransactionServiceImp
extends AbstractJtaUserTransactionService {
    private static final Logger LOGGER = LoggerFactory.createLogger(UserTransactionServiceImp.class);
    private static final String PRODUCT_NAME = "TransactionsEssentials";
    private File lockfile_ = null;
    private FileOutputStream lockfilestream_ = null;
    private FileLock lock_ = null;
    private TSInitInfo info_ = null;
    private Properties properties_ = UserTransactionServiceImp.getDefaultProperties();

    UserTransactionServiceImp(Properties properties) {
        Enumeration<?> enumm = properties.propertyNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String property = properties.getProperty(name);
            this.properties_.setProperty(name, property);
        }
        if (System.getProperty("com.atomikos.icatch.no_file") != null) {
            String name;
            enumm = this.properties_.propertyNames();
            Stack<String> names = new Stack<String>();
            while (enumm.hasMoreElements()) {
                name = (String)enumm.nextElement();
                names.push(name);
            }
            while (!names.empty()) {
                name = (String)names.pop();
                if (System.getProperty(name) == null) continue;
                this.properties_.setProperty(name, System.getProperty(name));
            }
        }
    }

    private Properties getProperties() {
        return this.properties_;
    }

    private StandAloneTransactionManager createDefault(Properties p) throws IOException, FileNotFoundException {
        StandAloneTransactionManager ret = null;
        String logname = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.log_base_name", p);
        String logdir = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.log_base_dir", p);
        logdir = UserTransactionServiceImp.findOrCreateFolder(logdir);
        String recoveryPrefs = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.enable_logging", p);
        boolean enableRecovery = true;
        if ("false".equals(recoveryPrefs)) {
            enableRecovery = false;
        }
        String threadedCommitPrefs = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.threaded_2pc", p);
        boolean threadedCommit = true;
        if ("false".equals(threadedCommitPrefs)) {
            threadedCommit = false;
        }
        this.lockfile_ = new File(logdir, logname + ".lck");
        if (enableRecovery) {
            try {
                this.lockfilestream_ = new FileOutputStream(this.lockfile_);
                this.lock_ = this.lockfilestream_.getChannel().tryLock();
                this.lockfile_.deleteOnExit();
            }
            catch (OverlappingFileLockException failedToGetLock) {
                this.lock_ = null;
            }
            catch (IOException failedToGetLock) {
                this.lock_ = null;
            }
            if (this.lock_ == null) {
                System.err.println("ERROR: the specified log seems to be in use already. Make sure that no other instance is running, or kill any pending process if needed.");
                throw new RuntimeException("Log already in use?");
            }
        }
        int max = new Integer(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.max_actives", p));
        long chckpt = new Long(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.checkpoint_interval", p));
        FileLogStream logstream = new FileLogStream(logdir, logname);
        StreamObjectLog slog = new StreamObjectLog(logstream, chckpt);
        FSMPreEnterListener recmgr = null;
        recmgr = enableRecovery ? new StateRecoveryManagerImp(slog) : new VolatileStateRecoveryManager();
        long maxTimeout = new Long(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.max_timeout", p));
        long defaultTimeoutInMillis = new Long(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.default_jta_timeout", p));
        int defaultTimeout = 0;
        defaultTimeout = (int)defaultTimeoutInMillis / 1000;
        if (defaultTimeout <= 0) {
            LOGGER.logWarning("WARNING: com.atomikos.icatch.default_jta_timeout should be more than 1000 milliseconds - resetting to 10000 milliseconds instead...");
            defaultTimeout = 10;
        }
        TransactionManagerImp.setDefaultTimeout(defaultTimeout);
        String name = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.tm_unique_name", p);
        if (name == null || name.equals("")) {
            throw new SysException("Property not set: com.atomikos.icatch.tm_unique_name");
        }
        ret = new StandAloneTransactionManager(name, (StateRecoveryManager)((Object)recmgr), logdir, maxTimeout, max, !threadedCommit);
        if (new Boolean(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.serial_jta_transactions", p)).booleanValue()) {
            TransactionManagerImp.setDefaultSerial(true);
        }
        return ret;
    }

    public void init(TSInitInfo info) throws SysException {
        this.info_ = info;
        Properties p = info.getProperties();
        StandAloneTransactionManager tm = null;
        try {
            tm = this.createDefault(p);
            tm.init(info.getProperties());
            Configuration.installCompositeTransactionManager(tm);
            Configuration.installRecoveryService(tm.getTransactionService());
            Configuration.installImportingTransactionManager(new ImportingTransactionManagerImp(tm.getTransactionService()));
            Configuration.installExportingTransactionManager(new ExportingTransactionManagerImp());
            Configuration.installLogControl(tm.getTransactionService().getLogControl());
            Configuration.installTransactionService(tm.getTransactionService());
            String autoMode = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.automatic_resource_registration", p);
            if (autoMode != null) {
                autoMode = autoMode.trim();
            }
            boolean autoRegister = "true".equals(autoMode);
            TransactionManagerImp.installTransactionManager(tm, autoRegister);
            Enumeration admins = this.info_.getLogAdministrators();
            while (admins.hasMoreElements()) {
                LogAdministrator admin = (LogAdministrator)admins.nextElement();
                if (!(admin instanceof LocalLogAdministrator)) continue;
                LocalLogAdministrator ladmin = (LocalLogAdministrator)admin;
                ladmin.init(this);
            }
            boolean clientDemarcation = new Boolean(UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.client_demarcation", p));
            if (clientDemarcation) {
                String name = UserTransactionServiceImp.getTrimmedProperty("com.atomikos.icatch.tm_unique_name", p);
                if (name == null || name.equals("")) {
                    throw new SysException("Property not set: com.atomikos.icatch.tm_unique_name");
                }
                UserTransactionServerImp utxs = UserTransactionServerImp.getSingleton();
                utxs.init(name, p);
                String factory = UserTransactionServiceImp.getTrimmedProperty("java.naming.factory.initial", p);
                String url = UserTransactionServiceImp.getTrimmedProperty("java.naming.provider.url", p);
                if (url == null || url.equals("")) {
                    throw new SysException("Property not set: java.naming.provider.url");
                }
            }
            super.init(info);
        }
        catch (Exception e) {
            e.printStackTrace();
            Stack<Exception> errors = new Stack<Exception>();
            errors.push(e);
            throw (SysException)new SysException("Error in init(): " + e.getMessage(), errors).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean force) throws IllegalStateException {
        BaseTransactionManager tm = (BaseTransactionManager)Configuration.getCompositeTransactionManager();
        if (tm == null) {
            return;
        }
        tm.shutdown(force);
        tm = null;
        TaskManager exec = TaskManager.getInstance();
        if (exec != null) {
            exec.shutdown();
        }
        super.shutdown(force);
        try {
            if (this.lock_ != null) {
                this.lock_.release();
            }
            if (this.lockfilestream_ != null) {
                this.lockfilestream_.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error releasing file lock: " + e.getMessage());
        }
        finally {
            this.lock_ = null;
        }
        if (this.lockfile_ != null) {
            this.lockfile_.delete();
            this.lockfile_ = null;
        }
        this.info_ = null;
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        return null;
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        return null;
    }

    public TSInitInfo createTSInitInfo() {
        TSInitInfoImp ret = new TSInitInfoImp();
        ret.setProperties(this.getProperties());
        return ret;
    }

    public TSMetaData getTSMetaData() {
        return new TSMetaDataImp("1.0.1", Atomikos.VERSION, PRODUCT_NAME, false, false);
    }

    public UserTransaction getUserTransaction() {
        UserTransaction ret = null;
        ret = UserTransactionServerImp.getSingleton().getUserTransaction();
        if (ret == null) {
            ret = new J2eeUserTransaction();
        }
        return ret;
    }

    public static Properties getDefaultProperties() {
        Properties ret = new Properties();
        ret.setProperty("com.atomikos.icatch.console_file_name", "tm.out");
        ret.setProperty("com.atomikos.icatch.output_dir", "." + File.separator);
        ret.setProperty("com.atomikos.icatch.log_base_dir", "." + File.separator);
        ret.setProperty("com.atomikos.icatch.log_base_name", "tmlog");
        ret.setProperty("com.atomikos.icatch.max_actives", "50");
        ret.setProperty("com.atomikos.icatch.max_timeout", "300000");
        ret.setProperty("com.atomikos.icatch.default_jta_timeout", "10000");
        ret.setProperty("com.atomikos.icatch.checkpoint_interval", "500");
        ret.setProperty("com.atomikos.icatch.serial_jta_transactions", "true");
        ret.setProperty("com.atomikos.icatch.tm_unique_name", UserTransactionServiceFactory.getDefaultName());
        ret.setProperty("com.atomikos.icatch.client_demarcation", "false");
        ret.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        ret.setProperty("com.atomikos.icatch.console_log_level", "WARN");
        ret.setProperty("java.naming.provider.url", "rmi://localhost:1099");
        ret.setProperty("com.atomikos.icatch.automatic_resource_registration", "true");
        ret.setProperty("com.atomikos.icatch.enable_logging", "true");
        ret.setProperty("com.atomikos.icatch.console_file_limit", "-1");
        ret.setProperty("com.atomikos.icatch.console_file_count", "1");
        ret.setProperty("com.atomikos.icatch.threaded_2pc", "false");
        ret.setProperty("com.atomikos.icatch.force_shutdown_on_vm_exit", "false");
        return ret;
    }
}

