/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateObjectImage;
import java.util.Enumeration;
import java.util.Vector;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMPreEnterListener {
    protected ObjectLog objectlog_;

    public StateRecoveryManagerImp(ObjectLog objectlog) {
        this.objectlog_ = objectlog;
    }

    public void init() throws LogException {
        this.objectlog_.init();
    }

    public void register(StateRecoverable staterecoverable) {
        if (staterecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        Object[] states = staterecoverable.getRecoverableStates();
        if (states != null) {
            int i;
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
            states = staterecoverable.getFinalStates();
            for (i = 0; i < states.length; ++i) {
                staterecoverable.addFSMPreEnterListener(this, states[i]);
            }
        }
    }

    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        Object state = event.getState();
        StateRecoverable source = (StateRecoverable)event.getSource();
        ObjectImage img = source.getObjectImage(state);
        if (img != null) {
            StateObjectImage simg = new StateObjectImage(img);
            Object[] finalstates = source.getFinalStates();
            boolean delete = false;
            for (int i = 0; i < finalstates.length; ++i) {
                if (!state.equals(finalstates[i])) continue;
                delete = true;
            }
            try {
                if (!delete) {
                    this.objectlog_.flush(simg);
                } else {
                    this.objectlog_.delete(simg.getId());
                }
            }
            catch (LogException le) {
                throw new IllegalStateException("could not flush state image " + le.getMessage() + " " + le.getClass().getName());
            }
        }
    }

    public void close() throws LogException {
        this.objectlog_.close();
    }

    public StateRecoverable recover(Object id) throws LogException {
        StateRecoverable srec = (StateRecoverable)this.objectlog_.recover(id);
        if (srec != null) {
            this.register(srec);
        }
        return srec;
    }

    public Vector recover() throws LogException {
        Vector ret = this.objectlog_.recover();
        Enumeration enumm = ret.elements();
        while (enumm.hasMoreElements()) {
            StateRecoverable srec = (StateRecoverable)enumm.nextElement();
            this.register(srec);
        }
        return ret;
    }

    public void delete(Object id) throws LogException {
        this.objectlog_.delete(id);
    }
}

