/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleState;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.jms.internal.AbstractJmsSessionProxy;
import com.atomikos.jms.internal.AtomikosJmsMessageConsumerWrapper;
import com.atomikos.jms.internal.AtomikosJmsMessageProducerWrapper;
import com.atomikos.jms.internal.AtomikosJmsTopicSubscriberWrapper;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Proxied;
import java.lang.reflect.Method;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;

public class AtomikosJmsXaSessionProxy
extends AbstractJmsSessionProxy
implements SessionHandleStateChangeListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsXaSessionProxy.class);
    private final SessionHandleState state;

    public AtomikosJmsXaSessionProxy(XASession delegate, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) {
        super((Session)delegate);
        this.state = new SessionHandleState(jmsTransactionalResource, delegate.getXAResource());
        this.state.registerSessionHandleStateChangeListener(pooledConnection);
        this.state.registerSessionHandleStateChangeListener(connectionProxy);
        this.state.registerSessionHandleStateChangeListener(this);
        this.state.notifySessionBorrowed();
    }

    @Override
    protected void throwInvocationAfterClose(String methodName) throws Exception {
        String msg = "Session was closed already - calling " + methodName + " is no longer allowed.";
        LOGGER.logWarning(this + ": " + msg);
        throw new IllegalStateException(msg);
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return super.invoke(proxy, method, args);
    }

    @Proxied
    public void commit() throws JMSException {
        String msg = "Calling commit/rollback is not allowed on a managed session!";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": " + msg);
        }
        throw new TransactionInProgressException(msg);
    }

    @Proxied
    public void rollback() throws JMSException {
        String msg = "Calling commit/rollback is not allowed on a managed session!";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": " + msg);
        }
        throw new TransactionInProgressException(msg);
    }

    @Proxied
    public void close() throws JMSException {
        this.state.notifySessionClosed();
        if (this.state.isTerminated()) {
            this.destroy(true);
        } else {
            this.destroy(false);
        }
        this.markClosed();
    }

    protected void destroy(boolean closeXaSession) {
        if (closeXaSession) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": closing underlying vendor session");
            }
            try {
                ((Session)this.delegate).close();
            }
            catch (JMSException e) {
                LOGGER.logWarning(this + ": could not close underlying vendor session", e);
            }
        }
        this.closed = true;
    }

    @Proxied
    public MessageProducer createProducer(Destination destination) throws JMSException {
        MessageProducer vendorProducer = ((Session)this.delegate).createProducer(destination);
        return new AtomikosJmsMessageProducerWrapper(vendorProducer, this.state);
    }

    @Proxied
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessageConsumer vendorConsumer = ((Session)this.delegate).createConsumer(destination);
        return new AtomikosJmsMessageConsumerWrapper(vendorConsumer, this.state);
    }

    @Proxied
    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        MessageConsumer vendorConsumer = ((Session)this.delegate).createConsumer(destination, messageSelector);
        return new AtomikosJmsMessageConsumerWrapper(vendorConsumer, this.state);
    }

    @Proxied
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        MessageConsumer vendorConsumer = ((Session)this.delegate).createConsumer(destination, messageSelector, NoLocal);
        return new AtomikosJmsMessageConsumerWrapper(vendorConsumer, this.state);
    }

    @Proxied
    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        TopicSubscriber vendorSubscriber = ((Session)this.delegate).createDurableSubscriber(topic, name);
        return new AtomikosJmsTopicSubscriberWrapper(vendorSubscriber, this.state);
    }

    @Proxied
    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        TopicSubscriber vendorSubscriber = ((Session)this.delegate).createDurableSubscriber(topic, name, messageSelector, noLocal);
        return new AtomikosJmsTopicSubscriberWrapper(vendorSubscriber, this.state);
    }

    @Override
    protected boolean isAvailable() {
        return this.state.isTerminated();
    }

    @Override
    protected boolean isErroneous() {
        return this.state.isErroneous();
    }

    @Override
    protected boolean isInTransaction(CompositeTransaction ct) {
        return this.state.isActiveInTransaction(ct);
    }

    @Override
    protected boolean isInactiveTransaction(CompositeTransaction ct) {
        return this.state.isInactiveInTransaction(ct);
    }

    @Override
    public void onTerminated() {
        this.destroy(true);
    }

    public static Session newInstance(XASession wrapped, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener pooledConnection, SessionHandleStateChangeListener connectionProxy) {
        AtomikosJmsXaSessionProxy proxy = new AtomikosJmsXaSessionProxy(wrapped, jmsTransactionalResource, pooledConnection, connectionProxy);
        return (Session)proxy.createDynamicProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        AtomikosJmsXaSessionProxy atomikosJmsXaSessionProxy = this;
        synchronized (atomikosJmsXaSessionProxy) {
            this.closed = false;
            this.state.notifySessionBorrowed();
        }
    }

    @Override
    protected void handleInvocationException(Throwable e) throws Throwable {
        if (!(e instanceof TransactionInProgressException)) {
            this.state.notifySessionErrorOccurred();
        }
        throw e;
    }

    public String toString() {
        return "atomikosJmsXaSessionProxy (state = " + this.state + ") for vendor instance " + this.delegate;
    }

    @Override
    protected Class<Session> getRequiredInterfaceType() {
        return Session.class;
    }
}

