/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPool;
import com.atomikos.datasource.pool.ConnectionPoolException;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.ConnectionPoolWithConcurrentValidation;
import com.atomikos.datasource.pool.ConnectionPoolWithSynchronizedValidation;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.PoolExhaustedException;
import com.atomikos.icatch.OrderedLifecycleComponent;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.IntraVmObjectFactory;
import com.atomikos.util.IntraVmObjectRegistry;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public abstract class AbstractDataSourceBean
implements DataSource,
ConnectionPoolProperties,
Referenceable,
Serializable,
OrderedLifecycleComponent {
    private static final com.atomikos.logging.Logger LOGGER = LoggerFactory.createLogger(AbstractDataSourceBean.class);
    private int minPoolSize = 1;
    private int maxPoolSize = 1;
    private int borrowConnectionTimeout = 30;
    private int reapTimeout = 0;
    private int maxIdleTime = 60;
    private String testQuery;
    private int maintenanceInterval = 60;
    private int loginTimeout;
    private transient ConnectionPool<Connection> connectionPool;
    private transient PrintWriter logWriter;
    private String resourceName;
    private int defaultIsolationLevel = -1;
    private int maxLifetime = 0;
    private boolean enableConcurrentConnectionValidation = true;

    protected void throwAtomikosSQLException(String msg) throws AtomikosSQLException {
        this.throwAtomikosSQLException(msg, null);
    }

    private void throwAtomikosSQLException(String msg, Throwable cause) throws AtomikosSQLException {
        AtomikosSQLException.throwAtomikosSQLException(msg, cause);
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.minPoolSize = poolSize;
        this.maxPoolSize = poolSize;
    }

    @Override
    public int getBorrowConnectionTimeout() {
        return this.borrowConnectionTimeout;
    }

    public void setBorrowConnectionTimeout(int borrowConnectionTimeout) {
        this.borrowConnectionTimeout = borrowConnectionTimeout;
    }

    @Override
    public int getReapTimeout() {
        if (this.reapTimeout == 0) {
            return this.getMaxLifetime();
        }
        return this.reapTimeout;
    }

    public void setReapTimeout(int reapTimeout) {
        this.reapTimeout = reapTimeout;
    }

    public void setMaintenanceInterval(int maintenanceInterval) {
        this.maintenanceInterval = maintenanceInterval;
    }

    @Override
    public int getMaintenanceInterval() {
        return this.maintenanceInterval;
    }

    @Override
    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    @Override
    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public String getTestQuery() {
        return this.testQuery;
    }

    public void setTestQuery(String testQuery) {
        this.testQuery = testQuery;
    }

    public void setConcurrentConnectionValidation(boolean value) {
        this.enableConcurrentConnectionValidation = value;
    }

    public boolean getConcurrentConnectionValidation() {
        return this.enableConcurrentConnectionValidation;
    }

    public int poolAvailableSize() {
        return this.connectionPool.availableSize();
    }

    public int poolTotalSize() {
        return this.connectionPool.totalSize();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public synchronized void init() throws AtomikosSQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": init...");
        }
        if (this.connectionPool != null) {
            return;
        }
        if (this.maxPoolSize < 1) {
            this.throwAtomikosSQLException("Property 'maxPoolSize' must be greater than 0, was: " + this.maxPoolSize);
        }
        if (this.minPoolSize < 0 || this.minPoolSize > this.maxPoolSize) {
            this.throwAtomikosSQLException("Property 'minPoolSize' must be at least 0 and at most maxPoolSize, was: " + this.minPoolSize);
        }
        if (this.getUniqueResourceName() == null) {
            this.throwAtomikosSQLException("Property 'uniqueResourceName' cannot be null");
        }
        if (this.getMinPoolSize() == 1) {
            LOGGER.logWarning(this + ": poolSize equals default - this may cause performance problems!");
        }
        try {
            ConnectionFactory<Connection> cf = this.doInit();
            if (this.enableConcurrentConnectionValidation) {
                this.connectionPool = new ConnectionPoolWithConcurrentValidation<Connection>(cf, this);
            } else {
                if (this.getTestQuery() != null) {
                    LOGGER.logWarning(this + ": testQuery set - pool may be slower / you might want to consider setting maxLifetime instead...");
                }
                this.connectionPool = new ConnectionPoolWithSynchronizedValidation<Connection>(cf, this);
            }
            this.getReference();
        }
        catch (AtomikosSQLException e) {
            throw e;
        }
        catch (Exception ex) {
            String msg = "Cannot initialize AtomikosDataSourceBean";
            AtomikosSQLException.throwAtomikosSQLException(msg, ex);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": init done.");
        }
    }

    @Override
    public void close() {
        block5: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logInfo(this + ": close...");
            }
            if (this.connectionPool != null) {
                this.connectionPool.destroy();
            }
            this.connectionPool = null;
            this.doClose();
            try {
                IntraVmObjectRegistry.removeResource(this.getUniqueResourceName());
            }
            catch (NameNotFoundException e) {
                if (!LOGGER.isTraceEnabled()) break block5;
                LOGGER.logTrace(this + ": Error removing from JNDI", e);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": close done.");
        }
    }

    protected abstract ConnectionFactory<Connection> doInit() throws Exception;

    protected abstract void doClose();

    @Override
    public Connection getConnection() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getConnection()...");
        }
        Connection connection = null;
        this.init();
        try {
            connection = this.connectionPool.borrowConnection();
        }
        catch (CreateConnectionException ex) {
            this.throwAtomikosSQLException("Failed to create a connection", ex);
        }
        catch (PoolExhaustedException e) {
            this.throwAtomikosSQLException("Connection pool exhausted - try increasing 'maxPoolSize' and/or 'borrowConnectionTimeout' on the DataSourceBean.");
        }
        catch (ConnectionPoolException e) {
            this.throwAtomikosSQLException("Error borrowing connection", e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": returning " + connection);
        }
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        LOGGER.logWarning(this + ": getConnection ( user , password ) ignores authentication - returning default connection");
        return this.getConnection();
    }

    @Override
    public String getUniqueResourceName() {
        return this.resourceName;
    }

    public void setUniqueResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public boolean getLocalTransactionMode() {
        return false;
    }

    @Override
    public Reference getReference() throws NamingException {
        return IntraVmObjectFactory.createReference(this, this.getUniqueResourceName());
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    @Override
    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return this.isAssignableFromThisClass(iface) || this.isAssignableFromWrappedVendorClass(iface);
    }

    protected abstract boolean isAssignableFromWrappedVendorClass(Class<?> var1);

    private boolean isAssignableFromThisClass(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isAssignableFromThisClass(iface)) {
            return (T)this;
        }
        if (this.isAssignableFromWrappedVendorClass(iface)) {
            return (T)this.unwrapVendorInstance();
        }
        throw new SQLException("Not a wrapper for class: " + iface);
    }

    protected abstract Object unwrapVendorInstance();

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void refreshPool() {
        if (this.connectionPool != null) {
            this.connectionPool.refresh();
        }
    }

    public String toString() {
        return this.getUniqueResourceName();
    }
}

