/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.extra.JmsSenderTemplate;
import com.atomikos.jms.extra.JmsSenderTemplateCallback;
import com.atomikos.jms.extra.MessageCallback;
import com.atomikos.jms.extra.RetrieveDestinationCallback;
import com.atomikos.jms.internal.AtomikosJMSException;
import com.atomikos.jms.internal.AtomikosTransactionRequiredJMSException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.SystemException;

public abstract class AbstractJmsSenderTemplate
implements JmsSenderTemplate {
    private static final Logger LOGGER = LoggerFactory.createLogger(AbstractJmsSenderTemplate.class);
    private AtomikosConnectionFactoryBean connectionFactoryBean;
    private String user;
    private String password;
    private Destination destination;
    private String destinationName;
    private Destination replyToDestination;
    private String replyToDestinationName;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private boolean inited;

    protected AbstractJmsSenderTemplate() {
        this.setTimeToLive(0L);
        this.setDeliveryMode(2);
        this.setPriority(4);
    }

    protected abstract Session getOrRefreshSession(Connection var1) throws JMSException;

    protected abstract Connection getOrReuseConnection() throws JMSException;

    protected abstract void afterUseWithoutErrors(Connection var1, Session var2) throws JMSException;

    protected void destroy(Connection c, Session s) throws JMSException {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (JMSException warn) {
            LOGGER.logWarning(this + ": error closing session", warn);
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (JMSException warn) {
            LOGGER.logWarning(this + ": error closing connection", warn);
        }
    }

    protected synchronized Connection refreshConnection() throws JMSException {
        Connection connection = null;
        if (this.getDestinationName() == null) {
            throw new JMSException("Please call setDestination or setDestinationName first!");
        }
        connection = this.user != null ? this.connectionFactoryBean.createConnection(this.user, this.password) : this.connectionFactoryBean.createConnection();
        connection.start();
        return connection;
    }

    public void init() throws JMSException {
        if (!this.inited) {
            if (this.connectionFactoryBean == null) {
                throw new IllegalStateException("Property 'atomikosConnectionFactoryBean' must be set first!");
            }
            if (this.getDestinationName() == null) {
                throw new IllegalStateException("Property 'destination' or 'destinationName' must be set first!");
            }
            StringBuffer msg = new StringBuffer();
            msg.append(this + ":configured with [");
            msg.append("user=").append(this.getUser()).append(", ");
            msg.append("password=").append(this.password).append(", ");
            msg.append("deliveryMode=").append(this.getDeliveryMode()).append(", ");
            msg.append("timeToLive=").append(this.getTimeToLive()).append(", ");
            msg.append("priority=").append(this.getPriority()).append(", ");
            msg.append("destination=").append(this.getDestinationName()).append(", ");
            msg.append("replyToDestination=").append(this.getReplyToDestinationName());
            msg.append("]");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(msg.toString());
            }
            this.inited = true;
        }
    }

    private void retrieveDestinationIfNecessary() throws JMSException {
        if (this.getDestination() == null) {
            String dName = this.getDestinationName();
            RetrieveDestinationCallback cb = new RetrieveDestinationCallback(dName);
            this.executeCallbackInternal(cb);
            this.setDestination(cb.getDestination());
        }
    }

    private void retrieveReplyToDestinationIfNecessary() throws JMSException {
        String dName;
        if (this.getReplyToDestination() == null && (dName = this.getReplyToDestinationName()) != null) {
            RetrieveDestinationCallback cb = new RetrieveDestinationCallback(dName);
            this.executeCallbackInternal(cb);
            this.setReplyToDestination(cb.getDestination());
        }
    }

    public void setAtomikosConnectionFactoryBean(AtomikosConnectionFactoryBean connectionFactory) {
        this.connectionFactoryBean = connectionFactory;
    }

    public AtomikosConnectionFactoryBean getAtomikosConnectionFactoryBean() {
        return this.connectionFactoryBean;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    private String getName(Destination d, String destinationName) {
        String ret;
        block8: {
            ret = destinationName;
            if (ret == null) {
                if (d instanceof Queue) {
                    Queue q = (Queue)d;
                    try {
                        ret = q.getQueueName();
                    }
                    catch (JMSException e) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.logTrace(this + ": error retrieving queue name", e);
                        }
                        break block8;
                    }
                }
                if (d instanceof Topic) {
                    Topic t = (Topic)d;
                    try {
                        ret = t.getTopicName();
                    }
                    catch (JMSException e) {
                        if (!LOGGER.isTraceEnabled()) break block8;
                        LOGGER.logTrace(this + ": error retrieving topic name", e);
                    }
                }
            }
        }
        return ret;
    }

    protected String getDestinationName() {
        return this.getName(this.getDestination(), this.destinationName);
    }

    protected String getReplyToDestinationName() {
        return this.getName(this.getReplyToDestination(), this.replyToDestinationName);
    }

    public String getUser() {
        return this.user;
    }

    public void setReplyToDestination(Destination destination) {
        this.replyToDestination = destination;
    }

    public void setReplyToDestinationName(String replyToDestinationName) {
        this.replyToDestinationName = replyToDestinationName;
    }

    public Destination getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    protected void executeCallbackInternal(JmsSenderTemplateCallback callback) throws JMSException {
        this.init();
        Session session = null;
        Connection conn = null;
        try {
            conn = this.getOrReuseConnection();
            session = this.getOrRefreshSession(conn);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Calling callback...");
            }
            callback.doInJmsSession(session);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Callback done!");
            }
            this.afterUseWithoutErrors(conn, session);
        }
        catch (AtomikosTransactionRequiredJMSException notx) {
            this.destroy(conn, session);
            String msg = "The JMS session you are using requires a JTA transaction context for the calling thread and none was found.\nPlease correct your code to start a JTA transaction before sending any message.";
            LOGGER.logWarning(msg);
            AtomikosTransactionRequiredJMSException.throwAtomikosTransactionRequiredJMSException(msg);
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.destroy(conn, session);
            String msg = this + ": error in sending JMS message";
            AtomikosJMSException.throwAtomikosJMSException(msg, e);
        }
    }

    @Override
    public void executeCallback(JmsSenderTemplateCallback callback) throws JMSException {
        this.init();
        this.retrieveDestinationIfNecessary();
        this.retrieveReplyToDestinationIfNecessary();
        UserTransactionManager tm = new UserTransactionManager();
        try {
            if (tm.getStatus() != 0) {
                throw new JMSException("This method requires an active transaction!");
            }
        }
        catch (SystemException e) {
            LOGGER.logError(this + ": error in getting transaction status", e);
            throw new RuntimeException(e.getMessage());
        }
        this.executeCallbackInternal(callback);
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setDeliveryMode(int i) {
        this.deliveryMode = i;
    }

    public void setPriority(int i) {
        this.priority = i;
    }

    public void setTimeToLive(long l) {
        this.timeToLive = l;
    }

    @Override
    public void sendTextMessage(final String content) throws JMSException {
        this.retrieveDestinationIfNecessary();
        this.retrieveReplyToDestinationIfNecessary();
        MessageCallback cb = new MessageCallback(this.getDestination(), this.getReplyToDestination(), this.getDeliveryMode(), this.getPriority(), this.getTimeToLive()){

            @Override
            Message createMessage(Session session) throws JMSException {
                return session.createTextMessage(content);
            }
        };
        this.executeCallback(cb);
    }

    @Override
    public void sendMapMessage(final Map<String, ?> content) throws JMSException {
        this.retrieveDestinationIfNecessary();
        this.retrieveReplyToDestinationIfNecessary();
        MessageCallback cb = new MessageCallback(this.getDestination(), this.getReplyToDestination(), this.getDeliveryMode(), this.getPriority(), this.getTimeToLive()){

            @Override
            Message createMessage(Session session) throws JMSException {
                MapMessage message = session.createMapMessage();
                for (Map.Entry element : content.entrySet()) {
                    message.setObject((String)element.getKey(), element.getValue());
                }
                return message;
            }
        };
        this.executeCallback(cb);
    }

    @Override
    public void sendObjectMessage(final Serializable content) throws JMSException {
        this.retrieveDestinationIfNecessary();
        this.retrieveReplyToDestinationIfNecessary();
        MessageCallback cb = new MessageCallback(this.getDestination(), this.getReplyToDestination(), this.getDeliveryMode(), this.getPriority(), this.getTimeToLive()){

            @Override
            Message createMessage(Session session) throws JMSException {
                return session.createObjectMessage(content);
            }
        };
        this.executeCallback(cb);
    }

    @Override
    public void sendBytesMessage(final byte[] content) throws JMSException {
        this.retrieveDestinationIfNecessary();
        this.retrieveReplyToDestinationIfNecessary();
        MessageCallback cb = new MessageCallback(this.getDestination(), this.getReplyToDestination(), this.getDeliveryMode(), this.getPriority(), this.getTimeToLive()){

            @Override
            Message createMessage(Session session) throws JMSException {
                BytesMessage msg = session.createBytesMessage();
                msg.writeBytes(content);
                return msg;
            }
        };
        this.executeCallback(cb);
    }

    public void close() {
        try {
            Connection c = this.getOrReuseConnection();
            Session s = this.getOrRefreshSession(c);
            this.destroy(c, s);
        }
        catch (JMSException e) {
            LOGGER.logWarning(this + ": error closing", e);
        }
        this.connectionFactoryBean.close();
    }
}

