/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.extra;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.jms.AtomikosConnectionFactoryBean;
import com.atomikos.jms.extra.DestinationHelper;
import com.atomikos.jms.extra.MessageConsumerSessionProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

class MessageConsumerSession {
    private static final Logger LOGGER = LoggerFactory.createLogger(MessageConsumerSession.class);
    private AtomikosConnectionFactoryBean factory;
    private String user;
    private String password;
    private Destination destination;
    private String destinationName;
    private MessageConsumerSessionProperties properties;
    private boolean notifyListenerOnClose;
    private String messageSelector;
    private boolean daemonThreads;
    private transient MessageListener listener;
    protected transient ReceiverThread current;
    private UserTransactionManager tm;
    private boolean active;
    private ExceptionListener exceptionListener;
    private boolean noLocal;
    private String subscriberName;
    private String clientID;
    private Map<String, Long> messageCounterMap = new HashMap<String, Long>();

    protected MessageConsumerSession(MessageConsumerSessionProperties properties) {
        this.properties = properties;
        this.tm = new UserTransactionManager();
        this.noLocal = false;
        this.subscriberName = null;
    }

    protected String getSubscriberName() {
        return this.subscriberName;
    }

    protected void setSubscriberName(String name) {
        this.subscriberName = name;
    }

    protected void setNoLocal(boolean value) {
        this.noLocal = value;
    }

    protected boolean getNoLocal() {
        return this.noLocal;
    }

    protected void setAtomikosConnectionFactoryBean(AtomikosConnectionFactoryBean bean) {
        this.factory = bean;
    }

    protected AtomikosConnectionFactoryBean getAtomikosConnectionFactoryBean() {
        return this.factory;
    }

    public void setDaemonThreads(boolean value) {
        this.daemonThreads = value;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public int getTransactionTimeout() {
        return this.properties.getTransactionTimeout();
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startListening() throws JMSException, SystemException {
        if (this.active) {
            throw new IllegalStateException("MessageConsumerSession: startListening() called a second time without stopListening() in between");
        }
        if (this.getDestinationName() == null) {
            throw new JMSException("Please set property 'destination' or 'destinationName' first");
        }
        if (this.factory == null) {
            throw new JMSException("Please set the ConnectionFactory first");
        }
        this.tm.setStartupTransactionService(true);
        this.tm.init();
        this.tm.setStartupTransactionService(false);
        this.active = true;
        this.startNewThread();
        StringBuffer msg = new StringBuffer();
        msg.append("MessageConsumerSession configured with [");
        msg.append("user=").append(this.getUser()).append(", ");
        msg.append("password=").append(this.password).append(", ");
        msg.append("transactionTimeout=").append(this.getTransactionTimeout()).append(", ");
        msg.append("destination=").append(this.getDestinationName()).append(", ");
        msg.append("notifyListenerOnClose= ").append(this.getNotifyListenerOnClose()).append(", ");
        msg.append("messageSelector=").append(this.getMessageSelector()).append(", ");
        msg.append("daemonThreads=").append(this.getDaemonThreads()).append(", ");
        msg.append("messageListener=").append(this.getMessageListener()).append(", ");
        msg.append("exceptionListener=").append(this.getExceptionListener()).append(", ");
        msg.append("connectionFactory=").append(this.getAtomikosConnectionFactoryBean());
        msg.append("]");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(msg.toString());
        }
    }

    public String getDestinationName() {
        String ret;
        block8: {
            ret = this.destinationName;
            if (ret == null) {
                if (this.destination instanceof Queue) {
                    Queue q = (Queue)this.destination;
                    try {
                        ret = q.getQueueName();
                    }
                    catch (JMSException e) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.logTrace("Error retrieving queue name", e);
                        }
                        break block8;
                    }
                }
                if (this.destination instanceof Topic) {
                    Topic t = (Topic)this.destination;
                    try {
                        ret = t.getTopicName();
                    }
                    catch (JMSException e) {
                        if (!LOGGER.isTraceEnabled()) break block8;
                        LOGGER.logTrace("Error retrieving topic name", e);
                    }
                }
            }
        }
        return ret;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected void startNewThread() {
        if (this.active) {
            this.current = new ReceiverThread();
            this.current.setDaemon(this.daemonThreads);
            this.current.start();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("MessageConsumerSession: started new thread: " + this.current);
            }
        }
    }

    private synchronized void notifyExceptionListener(JMSException e) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(e);
        }
    }

    public void stopListening() {
        if (this.current != null) {
            ReceiverThread t = this.current;
            this.current = null;
            t.closeJmsResources(true);
        }
        this.tm.close();
        this.active = false;
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean b) {
        this.notifyListenerOnClose = b;
    }

    private void cleanRedeliveryLimit(Message msg) throws JMSException {
        this.messageCounterMap.remove(msg.getJMSMessageID());
    }

    private void checkRedeliveryLimit(Message msg) throws JMSException {
        if (msg.getJMSRedelivered()) {
            String key = msg.getJMSMessageID();
            Long redeliveryCount = this.messageCounterMap.get(key);
            if (redeliveryCount == null) {
                redeliveryCount = 1L;
            } else {
                Long l = redeliveryCount;
                Long l2 = redeliveryCount = Long.valueOf(redeliveryCount + 1L);
                if (redeliveryCount > 5L) {
                    LOGGER.logWarning("Possible poison message detected - check https://www.atomikos.com/Documentation/PoisonMessage: " + msg.toString());
                }
            }
            this.messageCounterMap.put(key, redeliveryCount);
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public int getReceiveTimeout() {
        return this.properties.getReceiveTimeout();
    }

    protected Message receiveNextMessage(MessageConsumer receiver) throws JMSException {
        return receiver.receive((long)(this.getReceiveTimeout() * 1000));
    }

    protected void processMessage(Message msg) throws JMSException {
        LOGGER.logDebug("MessageConsumerSession: Consuming message: " + msg.toString());
        this.checkRedeliveryLimit(msg);
        this.listener.onMessage(msg);
        LOGGER.logTrace("MessageConsumerSession: Consumed message: " + msg.toString());
        this.cleanRedeliveryLimit(msg);
    }

    class ReceiverThread
    extends Thread {
        private Connection connection;
        private Session session;

        private ReceiverThread() {
        }

        private synchronized MessageConsumer refreshJmsResources() throws JMSException {
            String subscriberName;
            Object ret = null;
            this.connection = MessageConsumerSession.this.user != null ? MessageConsumerSession.this.factory.createConnection(MessageConsumerSession.this.user, MessageConsumerSession.this.password) : MessageConsumerSession.this.factory.createConnection();
            if (MessageConsumerSession.this.clientID != null) {
                String connectionClientID = this.connection.getClientID();
                if (connectionClientID == null) {
                    this.connection.setClientID(MessageConsumerSession.this.clientID);
                } else {
                    LOGGER.logWarning("Reusing connection with preset clientID: " + connectionClientID);
                }
            }
            this.connection.start();
            this.session = this.connection.createSession(true, 0);
            if (MessageConsumerSession.this.getDestination() == null) {
                Destination d = DestinationHelper.findDestination(MessageConsumerSession.this.getDestinationName(), this.session);
                MessageConsumerSession.this.setDestination(d);
            }
            ret = (subscriberName = MessageConsumerSession.this.getSubscriberName()) == null ? (MessageConsumerSession.this.destination instanceof Topic ? this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal()) : this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector())) : this.session.createDurableSubscriber((Topic)MessageConsumerSession.this.destination, subscriberName, MessageConsumerSession.this.getMessageSelector(), MessageConsumerSession.this.getNoLocal());
            return ret;
        }

        private synchronized void closeJmsResources(boolean threadWillStop) {
            block21: {
                try {
                    block20: {
                        if (this.session != null) {
                            block19: {
                                if (threadWillStop) {
                                    try {
                                        LOGGER.logInfo("MessageConsumerSession: unsubscribing " + MessageConsumerSession.this.subscriberName + "...");
                                        if (Thread.currentThread() != this) {
                                            if (LOGGER.isDebugEnabled()) {
                                                LOGGER.logDebug("MessageConsumerSession: waiting for listener thread to finish...");
                                            }
                                            this.join();
                                            if (LOGGER.isTraceEnabled()) {
                                                LOGGER.logTrace("MessageConsumerSession: waiting done.");
                                            }
                                        }
                                        if (MessageConsumerSession.this.subscriberName != null && MessageConsumerSession.this.properties.getUnsubscribeOnClose()) {
                                            LOGGER.logInfo("MessageConsumerSession: unsubscribing " + MessageConsumerSession.this.subscriberName + "...");
                                            this.session.unsubscribe(MessageConsumerSession.this.subscriberName);
                                        }
                                    }
                                    catch (JMSException e) {
                                        if (!LOGGER.isDebugEnabled()) break block19;
                                        LOGGER.logDebug("MessageConsumerSession: Error closing on JMS session", e);
                                        LOGGER.logDebug("MessageConsumerSession: linked exception is ", e.getLinkedException());
                                    }
                                }
                            }
                            try {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.logDebug("MessageConsumerSession: closing JMS session...");
                                }
                                this.session.close();
                                this.session = null;
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.logTrace("MessageConsumerSession: JMS session closed.");
                                }
                            }
                            catch (JMSException e) {
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.logDebug("MessageConsumerSession: Error closing JMS session", e);
                                }
                                if (!LOGGER.isDebugEnabled()) break block20;
                                LOGGER.logDebug("MessageConsumerSession: linked exception is ", e.getLinkedException());
                            }
                        }
                    }
                    if (this.connection == null) break block21;
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.logDebug("MessageConsumerSession: closing JMS connection...");
                        }
                        this.connection.close();
                        this.connection = null;
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.logTrace("MessageConsumerSession: JMS connection closed.");
                        }
                    }
                    catch (JMSException e) {
                        LOGGER.logWarning("MessageConsumerSession: Error closing JMS connection", e);
                        LOGGER.logWarning("MessageConsumerSession: linked exception is ", e.getLinkedException());
                    }
                }
                catch (Throwable e) {
                    LOGGER.logWarning("MessageConsumerSession: Unexpected error during close: ", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessageConsumer receiver = null;
            try {
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
            }
            catch (SystemException e) {
                LOGGER.logError("MessageConsumerSession: Error in JMS thread while setting transaction timeout", e);
            }
            LOGGER.logDebug("MessageConsumerSession: Starting JMS listener thread.");
            while (Thread.currentThread() == MessageConsumerSession.this.current) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("MessageConsumerSession: JMS listener thread iterating...");
                }
                boolean refresh = false;
                boolean commit = true;
                try {
                    Message msg = null;
                    while (receiver == null) {
                        try {
                            receiver = this.refreshJmsResources();
                        }
                        catch (JMSException connectionGone) {
                            LOGGER.logWarning("Error refreshing JMS connection", connectionGone);
                            this.closeJmsResources(false);
                            Thread.sleep(MessageConsumerSession.this.getTransactionTimeout() * 1000 / 4);
                        }
                    }
                    MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.getTransactionTimeout());
                    if (MessageConsumerSession.this.tm.getTransaction() != null) {
                        LOGGER.logFatal("MessageConsumerSession: detected pending transaction: " + MessageConsumerSession.this.tm.getTransaction());
                        throw new IllegalStateException("Can't reuse listener thread with pending transaction!");
                    }
                    MessageConsumerSession.this.tm.begin();
                    msg = MessageConsumerSession.this.receiveNextMessage(receiver);
                    try {
                        if (msg != null && MessageConsumerSession.this.listener != null && Thread.currentThread() == MessageConsumerSession.this.current) {
                            MessageConsumerSession.this.processMessage(msg);
                            continue;
                        }
                        commit = false;
                    }
                    catch (Exception e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.logDebug("MessageConsumerSession: Error during JMS processing of message " + msg.toString() + " - rolling back.", e);
                        }
                        commit = false;
                    }
                }
                catch (JMSException e) {
                    LOGGER.logWarning("MessageConsumerSession: Error in JMS thread", e);
                    Exception linkedException = e.getLinkedException();
                    if (linkedException != null) {
                        LOGGER.logWarning("Linked JMS exception is: ", linkedException);
                    }
                    refresh = true;
                    commit = false;
                    MessageConsumerSession.this.notifyExceptionListener(e);
                }
                catch (Throwable e) {
                    LOGGER.logError("MessageConsumerSession: Error in JMS thread", e);
                    refresh = true;
                    commit = false;
                    JMSException listenerError = new JMSException("Unexpected error - please see application log for more info");
                    MessageConsumerSession.this.notifyExceptionListener(listenerError);
                }
                finally {
                    block70: {
                        try {
                            if (commit) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException e) {
                            LOGGER.logWarning("MessageConsumerSession: Error in ending transaction", e);
                        }
                        catch (HeuristicMixedException e) {
                            LOGGER.logWarning("MessageConsumerSession: Error in ending transaction", e);
                        }
                        catch (HeuristicRollbackException e) {
                            LOGGER.logWarning("MessageConsumerSession: Error in ending transaction", e);
                        }
                        catch (Throwable e) {
                            LOGGER.logWarning("MessageConsumerSession: Error ending thread tx association", e);
                            try {
                                LOGGER.logTrace("MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException err) {
                                LOGGER.logError("MessageConsumerSession: Error suspending transaction", err);
                                try {
                                    LOGGER.logTrace("MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Throwable fatal) {
                                    LOGGER.logFatal("MessageConsumerSession: Error starting new thread - stopping listener", e);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!refresh || Thread.currentThread() != MessageConsumerSession.this.current) continue;
                        try {
                            receiver.close();
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isTraceEnabled()) break block70;
                            LOGGER.logTrace("MessageConsumerSession: Error closing receiver", e);
                        }
                    }
                    receiver = null;
                    this.closeJmsResources(false);
                }
            }
            if (receiver != null) {
                try {
                    receiver.close();
                }
                catch (Throwable e) {
                    LOGGER.logTrace("MessageConsumerSession: Error closing receiver", e);
                }
                receiver = null;
            }
            LOGGER.logDebug("MessageConsumerSession: JMS listener thread exiting.");
            if (MessageConsumerSession.this.listener != null && MessageConsumerSession.this.current == null && MessageConsumerSession.this.notifyListenerOnClose) {
                MessageConsumerSession.this.listener.onMessage(null);
            }
        }
    }
}

